/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractClassSearcher;
import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;

public class FileClassSearcher
extends AbstractClassSearcher {
    private static final String[] PROTOCOLS = new String[]{"file"};

    @Override
    public <T> List<Class<?>> search(String packageName, URL url, boolean recursive) {
        String path = this.getPath(url);
        File file = new File(path);
        return this.searchInternal(packageName, file, recursive);
    }

    protected <T> List<Class<? extends T>> searchInternal(String packageName, File file, boolean recursive) {
        String[] pathes;
        List<Class<T>> classes = CommonUtils.list();
        if (file.isFile()) {
            if (!this.isClassFile(file.getAbsolutePath())) {
                return classes;
            }
            try {
                Class<?> clazz = this.getClassLoader().loadClass(packageName + "." + this.fileNameToClassName(file.getName()));
                if (this.getFilter().test(clazz)) {
                    classes.add(clazz);
                }
                return classes;
            }
            catch (Exception e) {
                this.getExceptionHandler().accept(e);
            }
            catch (ClassFormatError e) {
                this.getExceptionHandler().accept(e);
            }
        }
        if ((pathes = file.list()) == null) {
            return classes;
        }
        for (String path : pathes) {
            File entry = new File(file, path);
            if (entry.isFile()) {
                if (!this.isClassFile(entry.getName())) continue;
                try {
                    Class<?> clazz = this.getClassLoader().loadClass(packageName + "." + this.fileNameToClassName(entry.getName()));
                    if (!this.getFilter().test(clazz)) continue;
                    classes.add(clazz);
                }
                catch (Exception e) {
                    this.getExceptionHandler().accept(e);
                }
                catch (ClassFormatError e) {
                    this.getExceptionHandler().accept(e);
                }
                continue;
            }
            if (!recursive) continue;
            List<Class<T>> cls = this.searchInternal(packageName + "." + entry.getName(), entry, recursive);
            classes.addAll(cls);
        }
        return classes;
    }

    private String getPath(URL url) {
        String file = url.getFile();
        try {
            return URLDecoder.decode(file, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] supportProtocols() {
        return PROTOCOLS;
    }
}

