/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.exceptions.InvalidPropertyException;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.LowerUnderScoreISMap;
import com.sqlapp.util.SimpleBeanUtils;
import com.sqlapp.util.ToStringBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleBeanWrapper {
    private final Class<?> clazz;
    private final Map<String, Method> getterMap = CommonUtils.linkedMap();
    private final Map<String, Method> setterMap = CommonUtils.linkedMap();
    private final Set<String> propertyNameSet = CommonUtils.linkedSet();
    private final Map<String, String> propertyNameMapping = new LowerUnderScoreISMap<String>();
    private final Map<String, Map<Class<?>, Method>> setterOverloadMap = CommonUtils.linkedMap();
    private final Map<String, Field> fieldMap = CommonUtils.linkedMap();
    private final Map<String, Field> protectedFieldMap = CommonUtils.linkedMap();
    private boolean initialized = false;
    private static final Pattern GETTER_GET_PATTERN = Pattern.compile("^get[_A-Z]+.*");
    private static final Pattern GETTER_IS_PATTERN = Pattern.compile("^is[_A-Z]+.*");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set[_A-Z]+.*");
    private final DoubleKeyMap<String, Integer, Method[]> METHOD_CACHE = CommonUtils.doubleKeyMap();

    protected SimpleBeanWrapper(String className) {
        this.clazz = CommonUtils.classForName(className);
        this.initialize(this.clazz);
    }

    protected SimpleBeanWrapper(Class<?> clazz) {
        this.clazz = clazz;
        this.initialize(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        synchronized (clazz2) {
            Field[] fields;
            if (this.initialized) {
                return;
            }
            this.initializeGetterSetter(clazz);
            for (Field field : fields = clazz.getFields()) {
                String propertyName = field.getName();
                if ("serialversionuid".equalsIgnoreCase(propertyName) && field.getType() == Long.TYPE || "class".equalsIgnoreCase(propertyName) || Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
                this.fieldMap.put(propertyName, field);
                this.propertyNameSet.add(propertyName);
                this.propertyNameMapping.put(propertyName, propertyName);
            }
            this.setProtectedFields(clazz);
            this.initialized = true;
        }
    }

    private void setProtectedFields(Class<?> clazz) {
        Field[] fields;
        if (clazz == Object.class) {
            return;
        }
        if (clazz == null) {
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            String propertyName = field.getName();
            if ("serialversionuid".equalsIgnoreCase(propertyName) && field.getType() == Long.TYPE || Modifier.isPublic(field.getModifiers()) || this.protectedFieldMap.containsKey(propertyName)) continue;
            field.setAccessible(true);
            this.protectedFieldMap.put(propertyName, field);
        }
        this.setProtectedFields(clazz.getSuperclass());
    }

    private void initializeGetterSetter(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String propertyName;
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameterTypes = method.getParameterTypes();
            String methodName = method.getName();
            if (this.isSetter(clazz, method)) {
                Class<?> argClass;
                propertyName = this.getPropertyName(methodName);
                Map<Class<?>, Method> classMap = this.setterOverloadMap.get(propertyName);
                if (classMap == null) {
                    classMap = CommonUtils.concurrentMap();
                    this.setterOverloadMap.put(propertyName, classMap);
                    this.propertyNameMapping.put(propertyName, propertyName);
                }
                if ((argClass = method.getParameterTypes()[0]).isPrimitive()) {
                    Class<?> wrapperClass = CommonUtils.getWrapperClass(argClass);
                    classMap.put(wrapperClass, method);
                }
                classMap.put(argClass, method);
                this.setterMap.put(propertyName, method);
                this.propertyNameMapping.put(propertyName, propertyName);
                continue;
            }
            if (parameterTypes.length != 0 || methodName.startsWith("getClass") || methodName.startsWith("getSerialversionuid") && Modifier.isStatic(method.getModifiers()) && returnType == Long.TYPE) continue;
            propertyName = null;
            Matcher getMatcher = GETTER_GET_PATTERN.matcher(methodName);
            if (getMatcher.matches()) {
                propertyName = this.getPropertyName(methodName);
                this.getterMap.put(propertyName, method);
                this.propertyNameSet.add(propertyName);
                this.propertyNameMapping.put(propertyName, propertyName);
                continue;
            }
            Matcher isMatcher = GETTER_IS_PATTERN.matcher(methodName);
            if (!isMatcher.matches() || !Boolean.TYPE.equals(returnType) && !Boolean.class.equals(returnType)) continue;
            propertyName = this.getIsPropertyName(methodName);
            this.getterMap.put(propertyName, method);
            this.propertyNameSet.add(propertyName);
            this.propertyNameMapping.put(propertyName, propertyName);
        }
    }

    private boolean isSetter(Class<?> clazz, Method method) {
        Matcher matcher;
        Class<?> returnType = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        String methodName = method.getName();
        return (returnType == Void.TYPE || Object.class != clazz && returnType.isAssignableFrom(clazz)) && parameterTypes.length == 1 && (matcher = SETTER_PATTERN.matcher(methodName)).matches();
    }

    private String getPropertyName(String methodName) {
        Object propertyName = methodName.substring(3);
        propertyName = ((String)propertyName).substring(0, 1).toLowerCase() + ((String)propertyName).substring(1);
        return propertyName;
    }

    private String getIsPropertyName(String methodName) {
        Object propertyName = methodName.substring(2);
        propertyName = ((String)propertyName).substring(0, 1).toLowerCase() + ((String)propertyName).substring(1);
        return propertyName;
    }

    public <T> T newInstance(Object ... initargs) {
        try {
            if (this.clazz.equals(Map.class)) {
                return (T)new LinkedHashMap();
            }
            if (this.clazz.equals(List.class)) {
                return (T)new ArrayList();
            }
            if (this.clazz.equals(Set.class)) {
                return (T)new LinkedHashSet();
            }
            if (this.clazz.isInterface()) {
                return null;
            }
            return this.newInstanceInternal(initargs);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Class=" + this.clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Class=" + this.clazz, e);
        }
        catch (InvocationTargetException e) {
            throw SimpleBeanUtils.throwInvocationTargetException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Class=" + this.clazz, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class=" + this.clazz, e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Class=" + this.clazz, e);
        }
    }

    private <T> T newInstanceInternal(Object ... initargs) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            return (T)this.clazz.getConstructor(new Class[0]).newInstance(initargs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            try {
                return (T)this.clazz.getConstructor(new Class[0]).newInstance(initargs);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
                return (T)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
    }

    public <T> T getValue(boolean caseInsensitive, Object obj, String propertyName) {
        if (caseInsensitive) {
            return this.getValueCI(obj, propertyName);
        }
        return this.getValue(obj, propertyName);
    }

    public <T> T getValue(Object obj, String propertyName) {
        try {
            Method method = this.getterMap.get(propertyName);
            if (method != null) {
                return (T)method.invoke(obj, new Object[0]);
            }
            Field field = this.fieldMap.get(propertyName);
            if (field != null) {
                return (T)field.get(obj);
            }
            return null;
        }
        catch (InvocationTargetException e) {
            throw SimpleBeanUtils.throwInvocationTargetException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public Type getPropertyGenericType(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        Method method = this.getterMap.get(propertyName);
        if (method != null) {
            return method.getGenericReturnType();
        }
        return this.fieldMap.get(propertyName).getGenericType();
    }

    public Type getPropertyGenericTypeCI(String propertyName) {
        return this.getPropertyGenericType(this.getPropertyNameCI(propertyName));
    }

    protected Type getPropertyGenericType(boolean caseInsensitive, String propertyName) {
        if (caseInsensitive) {
            return this.getPropertyGenericTypeCI(propertyName);
        }
        return this.getPropertyGenericType(propertyName);
    }

    public Class<?> getPropertyClass(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        Method method = this.getterMap.get(propertyName);
        if (method != null) {
            return method.getReturnType();
        }
        Field field = this.fieldMap.get(propertyName);
        if (field != null) {
            return field.getType();
        }
        return null;
    }

    public Class<?> getPropertyClassCI(String propertyName) {
        return this.getPropertyClass(this.getPropertyNameCI(propertyName));
    }

    public Class<?> getPropertyClass(boolean caseInsensitive, String propertyName) {
        if (caseInsensitive) {
            return this.getPropertyClass(this.getPropertyNameCI(propertyName));
        }
        return this.getPropertyClass(propertyName);
    }

    public String getPropertyNameCI(String propertyName) {
        return this.propertyNameMapping.get(propertyName);
    }

    public <T> T getValueCI(Object obj, String propertyName) {
        return this.getValue(obj, this.propertyNameMapping.get(propertyName));
    }

    public boolean setValueCI(Object obj, String propertyName, Object value) {
        return this.setValue(obj, this.propertyNameMapping.get(propertyName), value);
    }

    public boolean setValueCI(Object obj, String propertyName, Object value, boolean force) {
        return this.setValue(obj, this.propertyNameMapping.get(propertyName), value, force);
    }

    protected boolean setValue(boolean caseInsensitive, Object obj, String propertyName, Object value) {
        if (caseInsensitive) {
            return this.setValueCI(obj, propertyName, value);
        }
        return this.setValue(obj, propertyName, value);
    }

    public void setValuesCI(Collection<?> list, String propertyName, Object value) {
        for (Object obj : list) {
            this.setValueCI(obj, propertyName, value);
        }
    }

    public void setValues(Collection<?> list, String propertyName, Object value) {
        for (Object obj : list) {
            this.setValue(obj, propertyName, value);
        }
    }

    public boolean hasSetter(boolean caseInsensitive, String propertyName, Class<?> argClass) {
        Method method;
        if (caseInsensitive) {
            propertyName = this.getPropertyNameCI(propertyName);
        }
        return (method = this.getSetterMethod(propertyName, argClass)) != null;
    }

    public boolean setValue(Object obj, String propertyName, Object value) {
        return this.setValue(obj, propertyName, value, false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setField(Object obj, String fieldName, Object value) {
        block6: {
            parameterType = null;
            field = this.protectedFieldMap.get(fieldName);
            converters = Converters.getDefault();
            if (field == null) ** GOTO lbl22
            parameterType = field.getType();
            if (!converters.isConvertable(parameterType)) ** GOTO lbl19
            if (!parameterType.isPrimitive() || value != null) break block6;
            return false;
            {
                catch (Exception e) {
                    throw new InvalidPropertyException(fieldName, value, parameterType, e);
                }
            }
        }
        try {
            field.set(obj, converters.convertObject(value, parameterType));
            return true;
        }
        catch (Exception e) {
            return false;
lbl19:
            // 1 sources

            if (value != null && parameterType.isInstance(value)) {
                field.set(obj, value);
                return true;
            }
lbl22:
            // 3 sources

            return false;
        }
    }

    public <T> T getField(Object obj, String fieldName) {
        Class<?> parameterType = null;
        try {
            Field field = this.protectedFieldMap.get(fieldName);
            if (field != null) {
                return (T)field.get(obj);
            }
            return null;
        }
        catch (Exception e) {
            throw new InvalidPropertyException(fieldName, null, parameterType, e);
        }
    }

    public <T> T getFieldCI(Object obj, String propertyName) {
        return this.getField(obj, this.propertyNameMapping.get(propertyName));
    }

    public boolean setFieldCI(Object obj, String propertyName, Object value) {
        return this.setField(obj, this.propertyNameMapping.get(propertyName), value);
    }

    /*
     * Exception decompiling
     */
    public boolean setValue(Object obj, String propertyName, Object value, boolean force) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Method getSetterMethod(String propertyName, Class<?> argClass) {
        Map<Class<?>, Method> classMap = this.setterOverloadMap.get(propertyName);
        if (classMap != null) {
            Method method = classMap.get(argClass);
            if (method != null) {
                return method;
            }
            for (Map.Entry<Class<?>, Method> entry : classMap.entrySet()) {
                if (!entry.getKey().isAssignableFrom(argClass)) continue;
                method = entry.getValue();
                classMap.put(argClass, entry.getValue());
                return method;
            }
        }
        return null;
    }

    private Field getField(String propertyName) {
        Field field = this.fieldMap.get(propertyName);
        return field;
    }

    private Field getProtectedField(String propertyName) {
        Field field = this.protectedFieldMap.get(propertyName);
        return field;
    }

    public <S, T> Map<S, T> convertMap(Collection<T> fromCllection, String propertyName) {
        if (fromCllection == null) {
            return null;
        }
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        if (fromCllection.size() == 0) {
            return map;
        }
        for (T obj : fromCllection) {
            T key = this.getValue(obj, propertyName);
            map.put(key, obj);
        }
        return map;
    }

    public <S, T> Map<S, T> convertMapCI(Collection<T> fromCllection, String propertyName) {
        if (fromCllection == null) {
            return null;
        }
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        if (fromCllection.size() == 0) {
            return map;
        }
        for (T obj : fromCllection) {
            T key = this.getValueCI(obj, propertyName);
            map.put(key, obj);
        }
        return map;
    }

    public void copyProperties(Object fromObj, Object toObj) {
        if (fromObj == null) {
            return;
        }
        if (toObj == null) {
            return;
        }
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(toObj.getClass());
        Map<String, Object> map = this.toMap(fromObj);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            wrapper.setValue(toObj, entry.getKey(), entry.getValue());
        }
    }

    public void copyPropertiesCI(Object fromObj, Object toObj) {
        if (fromObj == null) {
            return;
        }
        if (toObj == null) {
            return;
        }
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(toObj.getClass());
        Map<String, Object> map = this.toMap(fromObj);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            wrapper.setValueCI(toObj, entry.getKey(), entry.getValue());
        }
    }

    public boolean is(Object value) {
        return value.getClass() == this.clazz;
    }

    public boolean hasProperty(String name) {
        return this.propertyNameMapping.containsKey(name);
    }

    public boolean hasPropertyCI(String name) {
        return this.propertyNameMapping.containsKey(name);
    }

    public Set<String> getPropertyNames() {
        return this.propertyNameSet;
    }

    public Map<String, Object> toMap(Object val) {
        if (val == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (val instanceof Map) {
            Map map = (Map)val;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() instanceof String) {
                    result.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                if (entry.getKey() == null) {
                    result.put(null, entry.getValue());
                    continue;
                }
                result.put(entry.getKey().toString(), entry.getValue());
            }
        } else {
            for (String name : this.propertyNameSet) {
                result.put(name, this.getValue(val, name));
            }
        }
        return result;
    }

    protected Map<String, Object> toMap(Object val, SimpleBeanWrapper simpleBeanWrapper, boolean caseInsensitive) {
        if (val == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (val instanceof Map) {
            Map map = (Map)val;
            for (Map.Entry entry : map.entrySet()) {
                String key = null;
                key = entry.getKey() instanceof String ? (String)entry.getKey() : (entry.getKey() == null ? (String)entry.getKey() : entry.getKey().toString());
                if (caseInsensitive) {
                    if (!simpleBeanWrapper.hasPropertyCI(key)) continue;
                    result.put(key, entry.getValue());
                    continue;
                }
                if (!simpleBeanWrapper.hasProperty(key)) continue;
                result.put(key, entry.getValue());
            }
        } else {
            for (String name : this.propertyNameSet) {
                if (caseInsensitive) {
                    if (!simpleBeanWrapper.hasPropertyCI(name)) continue;
                    result.put(name, this.getValue(val, name));
                    continue;
                }
                if (!simpleBeanWrapper.hasProperty(name)) continue;
                result.put(name, this.getValue(val, name));
            }
        }
        return result;
    }

    public Map<String, Object> toTreeMap(Object val) {
        if (val == null) {
            return null;
        }
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        if (val instanceof Map) {
            Map map = (Map)val;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() instanceof String) {
                    result.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                if (entry.getKey() == null) {
                    result.put(null, entry.getValue());
                    continue;
                }
                result.put(entry.getKey().toString(), entry.getValue());
            }
        } else {
            for (String name : this.propertyNameSet) {
                result.put(name, this.getValue(val, name));
            }
        }
        return result;
    }

    public Map<String, Annotation[]> getGetterAnnotationMap() {
        Map<String, Annotation[]> map = CommonUtils.map();
        for (String name : this.getPropertyNames()) {
            Annotation[] annotations;
            Method method = this.getterMap.get(name);
            if (method == null || CommonUtils.isEmpty(annotations = method.getAnnotations())) continue;
            map.put(name, annotations);
        }
        return map;
    }

    public Map<String, Annotation[]> getSetterAnnotationMap() {
        Map<String, Annotation[]> map = CommonUtils.map();
        for (String name : this.getPropertyNames()) {
            Annotation[] annotations;
            Method method = this.setterMap.get(name);
            if (method == null || CommonUtils.isEmpty(annotations = method.getAnnotations())) continue;
            map.put(name, annotations);
        }
        return map;
    }

    public Map<String, Annotation[]> getFieldAnnotationMap() {
        Map<String, Annotation[]> map = CommonUtils.map();
        for (String name : this.getPropertyNames()) {
            Annotation[] annotations;
            Field field = this.fieldMap.get(name);
            if (field != null && !CommonUtils.isEmpty(annotations = field.getAnnotations())) {
                map.put(name, annotations);
            }
            if ((field = this.protectedFieldMap.get(name)) == null || CommonUtils.isEmpty(annotations = field.getAnnotations())) continue;
            map.put(name, annotations);
        }
        return map;
    }

    public Map<String, Annotation[]> getPropertyAnnotationMap() {
        Map<String, Annotation[]> getterAnnotationMap = this.getGetterAnnotationMap();
        Map<String, Annotation[]> setterAnnotationMap = this.getSetterAnnotationMap();
        Map<String, Annotation[]> fieldAnnotationMap = this.getFieldAnnotationMap();
        Map<String, Annotation[]> map = CommonUtils.map();
        for (String name : this.getPropertyNames()) {
            List<Annotation> list = CommonUtils.list();
            Annotation[] annotations = getterAnnotationMap.get(name);
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    list.add(annotation);
                }
            }
            if ((annotations = setterAnnotationMap.get(name)) != null) {
                for (Annotation annotation : annotations) {
                    list.add(annotation);
                }
            }
            if ((annotations = fieldAnnotationMap.get(name)) != null) {
                for (Annotation annotation : annotations) {
                    list.add(annotation);
                }
            }
            if (list.isEmpty()) continue;
            map.put(name, list.toArray(new Annotation[0]));
        }
        return map;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        this.toString(builder);
        return builder.toString();
    }

    protected void toString(ToStringBuilder builder) {
        builder.add("clazz", this.clazz);
    }

    public <T> T invoke(Object obj, String name, Object ... args) {
        MethodArgs methodArgs = this.getMethod(name, args);
        if (methodArgs == null) {
            throw new RuntimeException(new NoSuchMethodException(name));
        }
        try {
            return (T)methodArgs.method.invoke(obj, methodArgs.args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw SimpleBeanUtils.throwInvocationTargetException(e);
        }
    }

    public boolean hasMethod(String name, Object ... args) {
        MethodArgs methodArgs = this.getMethod(name, args);
        return methodArgs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MethodArgs getMethod(String name, Object ... args) {
        Method[] methods = this.METHOD_CACHE.get(name, args.length);
        if (methods == null) {
            DoubleKeyMap<String, Integer, Method[]> doubleKeyMap = this.METHOD_CACHE;
            synchronized (doubleKeyMap) {
                List<Method> list = CommonUtils.list();
                Method[] methodArray = this.clazz.getMethods();
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    Class<?>[] parameterTypes;
                    Method method = methodArray[i];
                    if (!CommonUtils.eq(method.getName(), name) || (parameterTypes = method.getParameterTypes()).length != args.length) continue;
                    list.add(method);
                }
                methods = list.toArray(new Method[0]);
                this.METHOD_CACHE.put(name, args.length, methods);
            }
        }
        MethodArgs methodArgs = new MethodArgs();
        methodArgs.args = new Object[args.length];
        System.arraycopy(args, 0, methodArgs.args, 0, args.length);
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean match = true;
            Converters converters = Converters.getDefault();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Class<?> paramClass = parameterTypes[i];
                if (arg == null) {
                    if (!paramClass.isPrimitive()) continue;
                    match = false;
                    break;
                }
                Class<?> argClass = arg.getClass();
                if (paramClass == argClass || paramClass.isAssignableFrom(argClass)) continue;
                if (converters.isConvertable(paramClass) && converters.isConvertable(argClass)) {
                    methodArgs.args[i] = converters.convertObject(args[i], paramClass);
                    continue;
                }
                match = false;
                break;
            }
            if (!match) continue;
            methodArgs.method = method;
            return methodArgs;
        }
        return null;
    }

    private static class MethodArgs {
        Method method;
        Object[] args;

        private MethodArgs() {
        }
    }
}

