/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;

public class SimpleURLClassLoader
extends URLClassLoader {
    public SimpleURLClassLoader(URL ... urls) {
        super(urls);
    }

    public SimpleURLClassLoader(File ... files) {
        super(SimpleURLClassLoader.toURL(files));
    }

    static URL[] toURL(File ... files) {
        List<URL> urls = CommonUtils.list();
        for (File file : files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return urls.toArray(new URL[0]);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        Enumeration[] tmp = new Enumeration[1];
        try {
            tmp[0] = this.findResources(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new CompoundEnumeration<URL>(tmp);
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(name);
    }

    public static class CompoundEnumeration<E>
    implements Enumeration<E> {
        private Enumeration<E>[] enums;
        private int index = 0;

        public CompoundEnumeration(Enumeration<E>[] paramArrayOfEnumeration) {
            this.enums = paramArrayOfEnumeration;
        }

        private boolean next() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }
}

