/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private Comparator<String> comparator;

    public SortedProperties() {
        this.comparator = new StringComparator();
    }

    public SortedProperties(Comparator<String> comparator) {
        this.comparator = comparator;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        Collections.sort(keyList, this.comparator);
        return keyList.elements();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        Enumeration<Object> keysEnum = this.keys();
        while (keysEnum.hasMoreElements()) {
            Object key = keysEnum.nextElement();
            map.put(key, this.get(key));
        }
        return map.entrySet();
    }

    static class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            String[] split2;
            String[] split1 = o1.split("\\.");
            if (split1.length > (split2 = o2.split("\\.")).length) {
                return 1;
            }
            if (split1.length < split2.length) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

