/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class TableUtils {
    private TableUtils(Table table) {
    }

    public static List<String> getColumnNames(Table table, String ... exceptColumnNames) {
        List<String> result = CommonUtils.list();
        Set excepts = CommonUtils.set();
        for (String exceptColumnName : exceptColumnNames) {
            excepts.add(exceptColumnName);
        }
        for (Column column : table.getColumns()) {
            if (result.contains(column.getName()) || excepts.contains(column.getName())) continue;
            result.add(column.getName());
        }
        return result;
    }

    public static List<Column> getColumns(Table table, String ... columnNames) {
        List<Column> result = CommonUtils.list();
        if (columnNames == null) {
            return result;
        }
        for (String columnName : columnNames) {
            if (!table.getColumns().contains(columnName)) continue;
            result.add((Column)table.getColumns().get(columnName));
        }
        return result;
    }

    public static List<Column> getColumns(Table table, List<String> columnNames) {
        List<Column> result = CommonUtils.list();
        if (columnNames == null) {
            return result;
        }
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            String columnName = columnNames.get(i);
            if (!table.getColumns().contains(columnName)) continue;
            result.add((Column)table.getColumns().get(columnName));
        }
        return result;
    }

    public static List<Column> getAutoIncrementColumn(Table table) {
        List<Column> columns = TableUtils.filterColumns(table, new Predicate<Column>(){

            @Override
            public boolean test(Column column) {
                return column.isIdentity();
            }
        });
        return columns;
    }

    public static List<Column> filterColumns(Table table, Predicate<Column> filter) {
        List<Column> result = CommonUtils.list();
        ColumnCollection columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = (Column)columns.get(i);
            if (!filter.test(column)) continue;
            result.add(column);
        }
        return result;
    }

    public static void trim(Table table) {
        for (Row row : table.getRows()) {
            for (Column column : table.getColumns()) {
                Object obj = row.get(column);
                if (obj == null || !(obj instanceof String)) continue;
                row.put(column, (Object)((String)obj).trim());
            }
        }
    }
}

