/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbInfo;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.BinaryUtils;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public final class ToStringBuilder
implements Serializable {
    private static final long serialVersionUID = -5691665855745766445L;
    private String className = null;
    private SeparatedStringBuilder builder = new SeparatedStringBuilder(", ");
    private String openQuate = "[";
    private String closeQuate = "]";
    private boolean exceptEmpty = true;

    public ToStringBuilder() {
        this.className = "";
    }

    public ToStringBuilder(String className) {
        this.className = className;
    }

    public ToStringBuilder(Class<?> clazz) {
        this.className = clazz.getSimpleName();
    }

    public ToStringBuilder(Object obj) {
        this.className = obj.getClass().getSimpleName();
    }

    public ToStringBuilder add(String propertyName, List<?> text) {
        if (this.exceptEmpty && CommonUtils.isEmpty(text)) {
            return this;
        }
        SeparatedStringBuilder sep = new SeparatedStringBuilder("\n");
        sep.setStart("(").setEnd(")");
        sep.add(text);
        this.addElement("\n" + propertyName, sep.toString());
        return this;
    }

    public ToStringBuilder add(Object value) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value)) {
            return this;
        }
        this.builder.add(value);
        return this;
    }

    public ToStringBuilder addColumnNames(Column ... columns) {
        if (this.exceptEmpty && CommonUtils.isEmpty(columns)) {
            return this;
        }
        SeparatedStringBuilder cols = new SeparatedStringBuilder(", ");
        cols.setStart("(").setEnd(")");
        cols.addNames(columns);
        this.addElement(SchemaProperties.COLUMN_NAME.getLabel(), cols.toString());
        return this;
    }

    public ToStringBuilder addColumnNames(Collection<Column> columns) {
        return this.addColumnNames(SchemaProperties.COLUMN_NAME.getLabel(), columns);
    }

    public ToStringBuilder addColumnNames(String propertyName, Collection<Column> columns) {
        if (this.exceptEmpty && CommonUtils.isEmpty(columns)) {
            return this;
        }
        String val = ToStringBuilder.getColumnNames(propertyName, columns);
        this.add(val);
        return this;
    }

    public static String getColumnNames(String propertyName, Collection<Column> columns) {
        if (CommonUtils.isEmpty(columns)) {
            return null;
        }
        SeparatedStringBuilder cols = new SeparatedStringBuilder(", ");
        cols.setStart(propertyName + "(").setEnd(")");
        cols.addNames(columns);
        return cols.toString();
    }

    public ToStringBuilder addColumnNames(String propertyName, Column ... columns) {
        if (this.exceptEmpty && CommonUtils.isEmpty(columns)) {
            return this;
        }
        String val = ToStringBuilder.getColumnNames(propertyName, columns);
        this.add(val);
        return this;
    }

    public static String getColumnNames(String propertyName, Column ... columns) {
        if (CommonUtils.isEmpty(columns)) {
            return null;
        }
        SeparatedStringBuilder cols = new SeparatedStringBuilder(", ");
        cols.setStart(propertyName + "=(").setEnd(")");
        cols.addNames(columns);
        return cols.toString();
    }

    public ToStringBuilder add(ISchemaProperty props, Object value) {
        Object obj = props.getValue(value);
        return this.add(props.getLabel(), obj != null ? obj : value);
    }

    public ToStringBuilder add(String propertyName, Object value) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value)) {
            return this;
        }
        if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                return this.add(propertyName, (byte[])value);
            }
            String text = Arrays.toString((Object[])value);
            this.addElement(propertyName, text);
        } else {
            this.addElement(propertyName, value);
        }
        return this;
    }

    public ToStringBuilder add(String propertyName, byte[] value) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value)) {
            return this;
        }
        this.addElement(propertyName, BinaryUtils.toHexString(value));
        return this;
    }

    public ToStringBuilder add(String propertyName, DbInfo value) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value)) {
            return this;
        }
        this.addElement(propertyName, value);
        return this;
    }

    public ToStringBuilder add(String propertyName, long value) {
        if (this.exceptEmpty && value == 0L) {
            return this;
        }
        this.addElement(propertyName, value);
        return this;
    }

    public ToStringBuilder add(String propertyName, BigDecimal value) {
        if (this.exceptEmpty && (value == null || BigDecimal.ZERO.compareTo(value) == 0)) {
            return this;
        }
        this.addElement(propertyName, value);
        return this;
    }

    public ToStringBuilder add(String propertyName, String value) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value)) {
            return this;
        }
        this.addElement(propertyName, value);
        return this;
    }

    public ToStringBuilder add(ISchemaProperty props, String value) {
        this.add(props.getLabel(), value);
        return this;
    }

    public ToStringBuilder add(String propertyName, Collection<?> values) {
        if (this.exceptEmpty && CommonUtils.isEmpty(values)) {
            return this;
        }
        SeparatedStringBuilder builder = new SeparatedStringBuilder(", ");
        builder.setStart(propertyName + "=(").setEnd(")");
        builder.add(values);
        this.addElement(propertyName, builder.toString());
        return this;
    }

    public ToStringBuilder add(String propertyName, Date value) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value)) {
            return this;
        }
        this.addElement(propertyName, DateUtils.format(value));
        return this;
    }

    public ToStringBuilder add(String propertyName, Time value) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value)) {
            return this;
        }
        this.addElement(propertyName, DateUtils.format(value));
        return this;
    }

    public ToStringBuilder add(String propertyName, Calendar value) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value)) {
            return this;
        }
        this.addElement(propertyName, DateUtils.format(value));
        return this;
    }

    private void addElement(String propertyName, Object value) {
        this.builder.add((Object)(propertyName + "=" + value));
    }

    public ToStringBuilder add(String propertyName, Boolean value) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value)) {
            return this;
        }
        if (value.booleanValue()) {
            this.addElement(propertyName, value);
        }
        return this;
    }

    public String toString() {
        String val = this.builder.toString();
        StringBuilder result = new StringBuilder(this.className.length() + val.length() + 2);
        result.append(this.className).append(this.openQuate).append(val).append(this.closeQuate);
        return result.toString();
    }

    public String toStringSimple() {
        String val = this.builder.toString();
        StringBuilder result = new StringBuilder();
        result.append(this.openQuate).append(val).append(this.closeQuate);
        return result.toString();
    }

    public ToStringBuilder setOpenQuate(String openQuate) {
        this.openQuate = openQuate;
        return this;
    }

    public ToStringBuilder setCloseQuate(String closeQuate) {
        this.closeQuate = closeQuate;
        return this;
    }

    public ToStringBuilder setSeparator(String separator) {
        this.builder.setSeparator(separator);
        return this;
    }
}

