/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.eval.mvel;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.Java8DateUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public final class MvelUtils {
    private static String basePath = null;
    private static String encoding = "UTF8";

    private MvelUtils() {
    }

    public static boolean isEmpty(Object obj) {
        return CommonUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(Object obj) {
        return CommonUtils.isNotEmpty(obj);
    }

    public static boolean isNotBlank(Object obj) {
        return CommonUtils.isNotBlank(obj);
    }

    public static boolean isBlank(Object obj) {
        return CommonUtils.isBlank(obj);
    }

    public static <T> T coalesce(Object ... args) {
        return CommonUtils.coalesce(args);
    }

    public static String reverse(String value) {
        return CommonUtils.reverse(value);
    }

    public static boolean isIterable(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().isArray()) {
            return obj.getClass().isArray();
        }
        if (obj instanceof Iterable) {
            return true;
        }
        if (obj instanceof Map) {
            return true;
        }
        return obj instanceof Enumeration;
    }

    public static Object addSeconds(Object date, int seconds) {
        if (date == null) {
            return null;
        }
        if (date instanceof Time) {
            return DateUtils.addSeconds((Time)date, seconds);
        }
        if (date instanceof Timestamp) {
            return DateUtils.addSeconds((Timestamp)date, seconds);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.addSeconds((java.util.Date)date, seconds);
        }
        if (date instanceof Calendar) {
            return DateUtils.addSeconds((Calendar)date, seconds);
        }
        if (date instanceof Temporal) {
            return Java8DateUtils.addSeconds((Temporal)date, seconds);
        }
        throw new IllegalArgumentException("invalid type. date=" + date.getClass());
    }

    public static Object addMinutes(Object date, int minutes) {
        if (date == null) {
            return null;
        }
        if (date instanceof Time) {
            return DateUtils.addMinutes((Time)date, minutes);
        }
        if (date instanceof Timestamp) {
            return DateUtils.addMinutes((Timestamp)date, minutes);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.addMinutes((java.util.Date)date, minutes);
        }
        if (date instanceof Calendar) {
            return DateUtils.addMinutes((Calendar)date, minutes);
        }
        if (date instanceof Temporal) {
            return Java8DateUtils.addMinutes((Temporal)date, minutes);
        }
        throw new IllegalArgumentException("invalid type. date=" + date.getClass());
    }

    public static Object addHours(Object date, int hours) {
        if (date == null) {
            return null;
        }
        if (date instanceof Time) {
            return DateUtils.addHours((Time)date, hours);
        }
        if (date instanceof Timestamp) {
            return DateUtils.addHours((Timestamp)date, hours);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.addHours((java.util.Date)date, hours);
        }
        if (date instanceof Calendar) {
            return DateUtils.addHours((Calendar)date, hours);
        }
        if (date instanceof Temporal) {
            return Java8DateUtils.addHours((Temporal)date, hours);
        }
        throw new IllegalArgumentException("invalid type. date=" + date.getClass());
    }

    public static Object addDays(Object date, int days) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return DateUtils.addDays((Date)date, days);
        }
        if (date instanceof Timestamp) {
            return DateUtils.addDays((Timestamp)date, days);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.addDays((java.util.Date)date, days);
        }
        if (date instanceof Calendar) {
            return DateUtils.addDays((Calendar)date, days);
        }
        if (date instanceof Temporal) {
            return Java8DateUtils.addDays((Temporal)date, days);
        }
        if (date instanceof MonthDay) {
            return Java8DateUtils.addDays((MonthDay)date, days);
        }
        throw new IllegalArgumentException("invalid type. date=" + date.getClass());
    }

    public static Object addMonths(Object date, int months) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return DateUtils.addMonths((Date)date, months);
        }
        if (date instanceof Timestamp) {
            return DateUtils.addMonths((Timestamp)date, months);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.addMonths((java.util.Date)date, months);
        }
        if (date instanceof Calendar) {
            return DateUtils.addMonths((Calendar)date, months);
        }
        if (date instanceof Temporal) {
            return Java8DateUtils.addMonths((Temporal)date, months);
        }
        if (date instanceof MonthDay) {
            return Java8DateUtils.addMonths((MonthDay)date, months);
        }
        if (date instanceof Month) {
            return Java8DateUtils.addMonths((Month)date, months);
        }
        throw new IllegalArgumentException("invalid type. date=" + date.getClass());
    }

    public static Object addYears(Object date, int years) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return DateUtils.addYears((Date)date, years);
        }
        if (date instanceof Timestamp) {
            return DateUtils.addYears((Timestamp)date, years);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.addYears((java.util.Date)date, years);
        }
        if (date instanceof Calendar) {
            return DateUtils.addYears((Calendar)date, years);
        }
        if (date instanceof Temporal) {
            return Java8DateUtils.addYears((Temporal)date, years);
        }
        if (date instanceof YearMonth) {
            return Java8DateUtils.addMonths((YearMonth)date, years);
        }
        if (date instanceof Year) {
            return Java8DateUtils.addMonths((Year)date, years);
        }
        throw new IllegalArgumentException("invalid type. date=" + date.getClass());
    }

    public static Object truncateTime(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date instanceof Timestamp) {
            return DateUtils.truncateTime((Timestamp)date);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.truncateTime((java.util.Date)date);
        }
        if (date instanceof Calendar) {
            return DateUtils.truncateTime((Calendar)date);
        }
        if (date instanceof LocalDateTime) {
            return Java8DateUtils.truncateTime((LocalDateTime)date);
        }
        if (date instanceof OffsetDateTime) {
            return Java8DateUtils.truncateTime((OffsetDateTime)date);
        }
        if (date instanceof ZonedDateTime) {
            return Java8DateUtils.truncateTime((ZonedDateTime)date);
        }
        throw new IllegalArgumentException("invalid type. date=" + date.getClass());
    }

    public static Object truncateMilisecond(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date instanceof Timestamp) {
            return DateUtils.truncateMilisecond((Timestamp)date);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.truncateMilisecond((java.util.Date)date);
        }
        if (date instanceof Calendar) {
            return DateUtils.truncateMilisecond((Calendar)date);
        }
        if (date instanceof LocalDateTime) {
            return Java8DateUtils.truncateMilisecond((LocalDateTime)date);
        }
        if (date instanceof OffsetDateTime) {
            return Java8DateUtils.truncateMilisecond((OffsetDateTime)date);
        }
        if (date instanceof ZonedDateTime) {
            return Java8DateUtils.truncateMilisecond((ZonedDateTime)date);
        }
        throw new IllegalArgumentException("invalid type. date=" + date.getClass());
    }

    public static Object beginningOfYear(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return DateUtils.beginningOfYear((Date)date);
        }
        if (date instanceof Timestamp) {
            return DateUtils.beginningOfYear((Timestamp)date);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.beginningOfYear((java.util.Date)date);
        }
        if (date instanceof Calendar) {
            return DateUtils.beginningOfYear((Calendar)date);
        }
        if (date instanceof Temporal) {
            return Java8DateUtils.beginningOfYear((Temporal)date);
        }
        throw new IllegalArgumentException("date is not valid. " + date.getClass());
    }

    public static Object beginningOfQuarter(Object date, int accountingPeriod) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return DateUtils.beginningOfQuarter((Date)date, accountingPeriod);
        }
        if (date instanceof Timestamp) {
            return DateUtils.beginningOfQuarter((Timestamp)date, accountingPeriod);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.beginningOfQuarter((java.util.Date)date, accountingPeriod);
        }
        if (date instanceof Calendar) {
            return DateUtils.beginningOfQuarter((Calendar)date, accountingPeriod);
        }
        if (date instanceof Temporal) {
            ZonedDateTime zonedDateTime = Converters.getDefault().convertObject(date, ZonedDateTime.class);
            return Java8DateUtils.beginningOfQuarter(zonedDateTime, accountingPeriod);
        }
        throw new IllegalArgumentException("date is not valid. " + date.getClass());
    }

    public static Object sunday(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return DateUtils.sunday((Date)date);
        }
        if (date instanceof Timestamp) {
            return DateUtils.sunday((Timestamp)date);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.sunday((java.util.Date)date);
        }
        if (date instanceof Calendar) {
            return DateUtils.sunday((Calendar)date);
        }
        if (date instanceof Temporal) {
            return Java8DateUtils.sunday((Temporal)date);
        }
        throw new IllegalArgumentException("date is not valid. " + date.getClass());
    }

    public static Object monday(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return DateUtils.monday((Date)date);
        }
        if (date instanceof Timestamp) {
            return DateUtils.monday((Timestamp)date);
        }
        if (date instanceof java.util.Date) {
            return DateUtils.monday((java.util.Date)date);
        }
        if (date instanceof Calendar) {
            return DateUtils.monday((Calendar)date);
        }
        if (date instanceof Temporal) {
            return Java8DateUtils.monday((Temporal)date);
        }
        throw new IllegalArgumentException("date is not valid. " + date.getClass());
    }

    public static void setBasePath(String basePath) {
        MvelUtils.basePath = basePath;
    }

    public static void setDefaultEncoding(String encoding) {
        MvelUtils.encoding = encoding;
    }

    public static String readFileAsText(String filePath) {
        return MvelUtils.readFileAsText(filePath, encoding);
    }

    public static byte[] readFileAsBytes(String filePath) throws FileNotFoundException, IOException {
        File file = basePath == null ? new File(filePath) : new File(basePath, filePath);
        try (FileInputStream fs = new FileInputStream(file);){
            byte[] byArray;
            try (BufferedInputStream bis = new BufferedInputStream(fs);){
                int len;
                byte[] buf = new byte[4096];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((len = bis.read(buf)) != -1) {
                    bos.write(buf, 0, len);
                }
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    public static String readFileAsText(String filePath, String encoding) {
        if (basePath == null) {
            return FileUtils.readText(filePath, encoding);
        }
        return FileUtils.readText(FileUtils.combinePath(basePath, filePath), encoding);
    }

    public static String writeZip(String filePath, String zipFilePath, String encoding) throws URISyntaxException, IOException {
        if (basePath != null) {
            filePath = FileUtils.combinePath(basePath, filePath);
            zipFilePath = FileUtils.combinePath(basePath, zipFilePath);
        }
        final Path fromDir = Paths.get(filePath, new String[0]);
        Path zipPath = Paths.get(zipFilePath, new String[0]);
        Files.deleteIfExists(zipPath);
        final String zipRootDirName = fromDir.getFileName().toString();
        URI zipUri = new URI("jar", zipPath.toUri().toString(), null);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        if (encoding != null) {
            env.put("encoding", encoding);
        }
        try (final FileSystem fs = FileSystems.newFileSystem(zipUri, env, ClassLoader.getSystemClassLoader());){
            Files.walkFileTree(fromDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relative = fromDir.relativize(file);
                    Path zipFile = fs.getPath(zipRootDirName, relative.toString());
                    Path parent = zipFile.getParent();
                    if (parent != null) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    Files.copy(file, zipFile, StandardCopyOption.COPY_ATTRIBUTES);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return zipFilePath;
    }

    public static String writeZip(String filePath, String zipFilePath) throws URISyntaxException, IOException {
        return MvelUtils.writeZip(filePath, zipFilePath, null);
    }

    public static InputStream getInputStream(String filePath) throws FileNotFoundException {
        if (basePath == null) {
            return new FileInputStream(filePath);
        }
        return new FileInputStream(FileUtils.combinePath(basePath, filePath));
    }

    public static Reader getReader(String filePath, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        return new InputStreamReader(MvelUtils.getInputStream(filePath), encoding);
    }

    public static Reader getReader(String filePath) throws FileNotFoundException, UnsupportedEncodingException {
        return MvelUtils.getReader(filePath, encoding);
    }
}

