/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.Instant;

final class InstantIterator
extends AbstractObjectIterator<Instant, Integer> {
    private static final long serialVersionUID = 1L;

    public InstantIterator(Instant start, Instant end) {
        this(start, end, 86400);
    }

    public InstantIterator(Instant start, Instant end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            return ((Instant)this.next).compareTo((Instant)this.end) < 0;
        }
        return ((Instant)this.next).compareTo((Instant)this.end) > 0;
    }

    @Override
    protected Instant getNext() {
        return ((Instant)this.current).plusSeconds(((Integer)this.step).intValue());
    }

    public InstantIterator clone() {
        InstantIterator clone = new InstantIterator((Instant)this.start, (Instant)this.end, (Integer)this.step);
        return clone;
    }
}

