/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;

final class LocalDateIterator
extends AbstractObjectIterator<LocalDate, Integer> {
    private static final long serialVersionUID = 1L;

    public LocalDateIterator(LocalDate start, LocalDate end) {
        this(start, end, 86400);
    }

    public LocalDateIterator(LocalDate start, LocalDate end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            return ((LocalDate)this.next).compareTo((ChronoLocalDate)this.end) < 0;
        }
        return ((LocalDate)this.next).compareTo((ChronoLocalDate)this.end) > 0;
    }

    @Override
    protected LocalDate getNext() {
        return ((LocalDate)this.current).plusDays(((Integer)this.step).intValue());
    }

    public LocalDateIterator clone() {
        LocalDateIterator clone = new LocalDateIterator((LocalDate)this.start, (LocalDate)this.end, (Integer)this.step);
        return clone;
    }
}

