/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;

final class LocalDateTimeIterator
extends AbstractObjectIterator<LocalDateTime, Integer> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeIterator(LocalDateTime start, LocalDateTime end) {
        this(start, end, 86400);
    }

    public LocalDateTimeIterator(LocalDateTime start, LocalDateTime end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            return ((LocalDateTime)this.next).compareTo((ChronoLocalDateTime)this.end) < 0;
        }
        return ((LocalDateTime)this.next).compareTo((ChronoLocalDateTime)this.end) > 0;
    }

    @Override
    protected LocalDateTime getNext() {
        return ((LocalDateTime)this.current).plusSeconds(((Integer)this.step).intValue());
    }

    public LocalDateTimeIterator clone() {
        LocalDateTimeIterator clone = new LocalDateTimeIterator((LocalDateTime)this.start, (LocalDateTime)this.end, (Integer)this.step);
        return clone;
    }
}

