/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.LocalTime;

final class LocalTimeIntervalIterator
extends AbstractObjectIterator<LocalTime, Interval> {
    private static final long serialVersionUID = 1L;

    public LocalTimeIntervalIterator(LocalTime start, LocalTime end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            if (((LocalTime)this.start).compareTo((LocalTime)this.next) >= 0) {
                return false;
            }
            if (((LocalTime)this.next).compareTo((LocalTime)this.end) < 0) {
                return true;
            }
        } else {
            if (((LocalTime)this.start).compareTo((LocalTime)this.next) <= 0) {
                return false;
            }
            if (((LocalTime)this.next).compareTo((LocalTime)this.end) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected LocalTime getNext() {
        return ((Interval)this.step).add((LocalTime)this.start, (int)this.count);
    }

    public LocalTimeIntervalIterator clone() {
        LocalTimeIntervalIterator clone = new LocalTimeIntervalIterator((LocalTime)this.start, (LocalTime)this.end, (Interval)this.step);
        return clone;
    }
}

