/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.sql.Timestamp;

final class TimestampIntervalIterator
extends AbstractObjectIterator<Timestamp, Interval> {
    private static final long serialVersionUID = 1L;

    public TimestampIntervalIterator(Timestamp start, Timestamp end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            return ((Timestamp)this.next).compareTo((Timestamp)this.end) < 0;
        }
        return ((Timestamp)this.next).compareTo((Timestamp)this.end) > 0;
    }

    @Override
    protected Timestamp getNext() {
        return ((Interval)this.step).add((Timestamp)this.start, (int)this.count);
    }

    public TimestampIntervalIterator clone() {
        TimestampIntervalIterator clone = new TimestampIntervalIterator((Timestamp)this.start, (Timestamp)this.end, (Interval)this.step);
        return clone;
    }
}

