/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.test;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileUtils {
    public static List<String> getFileList(String rootPath, String fileFilter, boolean caseInsensitive, boolean recursive) {
        ArrayList<String> fileList = new ArrayList<String>();
        File dir = null;
        dir = rootPath == null ? new File("") : new File(rootPath);
        Pattern pattern = null;
        if (fileFilter != null) {
            pattern = caseInsensitive ? Pattern.compile(fileFilter, 2) : Pattern.compile(fileFilter);
        }
        FileUtils.searchFileList(dir, pattern, recursive, fileList);
        return fileList;
    }

    private static void searchFileList(File targetFile, Pattern pattern, boolean recursive, List<String> fileList) {
        if (targetFile.isFile()) {
            if (FileUtils.isTargetFile(targetFile, pattern)) {
                fileList.add(targetFile.getAbsolutePath());
            }
            return;
        }
        if (!recursive) {
            return;
        }
        File[] files = targetFile.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    if (!FileUtils.isTargetFile(file, pattern)) continue;
                    fileList.add(file.getAbsolutePath());
                    continue;
                }
                FileUtils.searchFileList(file, pattern, recursive, fileList);
            }
        }
    }

    private static boolean isTargetFile(File file, Pattern pattern) {
        if (pattern == null) {
            return true;
        }
        Matcher matcher = pattern.matcher(file.getName());
        return matcher.matches();
    }

    public static void close(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean exists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static String getFileNameWithoutExtension(String filePath) {
        String fileName = FileUtils.getFileName(filePath);
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }

    public static String getFileNameWithoutExtension(File file) {
        return FileUtils.getFileNameWithoutExtension(file.getName());
    }

    public static String getFileName(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        return fileName;
    }

    public static String getExtension(String filePath) {
        String fileName = FileUtils.getFileName(filePath);
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            return fileName.substring(pos + 1);
        }
        return "";
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(file.getName());
    }

    public static String getExtension(Path path) {
        if (path == null) {
            return null;
        }
        if (path.getFileName() == null) {
            return null;
        }
        return FileUtils.getExtension(path.getFileName().toString());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObject(String filePath) {
        Object e2222222;
        FileInputStream inFile = null;
        ObjectInputStream inObject = null;
        try {
            inFile = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e2222222) {
            throw new RuntimeException(e2222222);
        }
        try {
            inObject = new ObjectInputStream(inFile);
            e2222222 = inObject.readObject();
        }
        catch (IOException e3) {
            try {
                throw new RuntimeException(e3);
                catch (ClassNotFoundException e4) {
                    throw new RuntimeException(e4);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(inObject);
                FileUtils.close(inFile);
                throw throwable;
            }
        }
        FileUtils.close(inObject);
        FileUtils.close(inFile);
        return (T)e2222222;
    }

    public static void mkDirs(File file) {
        if (file == null || file.mkdirs()) {
            // empty if block
        }
    }

    public static List<String> readTextList(String filePath, String encoding) {
        List<String> list;
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            list = FileUtils.readTextList(is, encoding);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.close(is);
                throw throwable;
            }
        }
        FileUtils.close(is);
        return list;
    }

    public static List<String> readTextList(File file, String encoding) {
        List<String> list;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            list = FileUtils.readTextList(is, encoding);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.close(is);
                throw throwable;
            }
        }
        FileUtils.close(is);
        return list;
    }

    public static List<String> readTextList(InputStream is, String encoding) {
        ArrayList<String> arrayList;
        BufferedReader br = null;
        InputStreamReader in = null;
        try {
            in = encoding == null || encoding.isEmpty() ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
            br = new BufferedReader(in);
            ArrayList<String> list = new ArrayList<String>();
            while (br.ready()) {
                String line = br.readLine();
                list.add(line);
            }
            arrayList = list;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.close(br);
                FileUtils.close(in);
                FileUtils.close(is);
                throw throwable;
            }
        }
        FileUtils.close(br);
        FileUtils.close(in);
        FileUtils.close(is);
        return arrayList;
    }

    public static List<String> readTextList(Path path, Charset charset) {
        try {
            List<String> list = charset == null ? Files.readAllLines(path) : Files.readAllLines(path, charset);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readText(InputStream is, String encoding) {
        return FileUtils.readText(is, Charset.forName(encoding));
    }

    public static String readText(InputStream is, Charset encoding) {
        String string;
        BufferedReader br = null;
        InputStreamReader in = null;
        try {
            String line;
            in = encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
            br = new BufferedReader(in);
            StringBuilder builder = new StringBuilder();
            if (br.ready()) {
                line = br.readLine();
                builder.append(line);
            }
            while (br.ready()) {
                line = br.readLine();
                builder.append('\n');
                builder.append(line);
            }
            string = builder.toString();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.close(br);
                FileUtils.close(in);
                FileUtils.close(is);
                throw throwable;
            }
        }
        FileUtils.close(br);
        FileUtils.close(in);
        FileUtils.close(is);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(String filePath, String encoding) {
        InputStream is = null;
        try {
            is = FileUtils.getInputStream(filePath);
            String string = FileUtils.readText(is, encoding);
            return string;
        }
        finally {
            FileUtils.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(File file, String encoding) {
        InputStream is = null;
        try {
            is = FileUtils.getInputStream(file);
            String string = FileUtils.readText(is, encoding);
            return string;
        }
        finally {
            FileUtils.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(File file, Charset encoding) {
        InputStream is = null;
        try {
            is = FileUtils.getInputStream(file);
            String string = FileUtils.readText(is, encoding);
            return string;
        }
        finally {
            FileUtils.close(is);
        }
    }

    public static String readText(Path path, String encoding) {
        return FileUtils.readText(path.toFile(), encoding);
    }

    public static boolean remove(String path) {
        File file = new File(path);
        return FileUtils.remove(file);
    }

    public static boolean remove(File file) {
        if (!file.isDirectory()) {
            return file.delete();
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                FileUtils.remove(child);
            }
        }
        return file.delete();
    }

    public static void copyFile(String srcPath, String destPath) {
        FileInputStream is = null;
        FileOutputStream os = null;
        FileChannel srcChannel = null;
        FileChannel destChannel = null;
        try {
            File file = new File(destPath);
            FileUtils.mkDirs(file);
            is = new FileInputStream(srcPath);
            os = new FileOutputStream(destPath);
            srcChannel = is.getChannel();
            destChannel = os.getChannel();
            srcChannel.transferTo(0L, srcChannel.size(), destChannel);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.close(srcChannel);
                FileUtils.close(destChannel);
                FileUtils.close(is);
                FileUtils.close(os);
                throw throwable;
            }
        }
        FileUtils.close(srcChannel);
        FileUtils.close(destChannel);
        FileUtils.close(is);
        FileUtils.close(os);
    }

    public static boolean rename(String srcPath, String destPath) {
        if (Objects.equals(srcPath, destPath)) {
            return false;
        }
        File srcFile = new File(srcPath);
        if (!srcFile.exists()) {
            return false;
        }
        File destFile = new File(destPath);
        return srcFile.renameTo(destFile);
    }

    public static String read(Reader reader) {
        BufferedReader br = null;
        br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        StringBuilder builder = new StringBuilder();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                builder.append(line).append('\n');
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.close(br);
            FileUtils.close(reader);
        }
        return builder.toString();
    }

    public static String combinePath(String ... paths) {
        char separator = '/';
        for (String path : paths) {
            if (path == null) continue;
            if (path.contains("\\")) {
                separator = '\\';
                break;
            }
            if (!path.contains("/")) continue;
            separator = '/';
            break;
        }
        StringBuilder result = new StringBuilder(128);
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (path == null || path.isEmpty()) continue;
            if (result.length() > 0) {
                if (result.charAt(result.length() - 1) == separator) {
                    if (path.charAt(0) == separator) {
                        result.append(path.substring(1));
                        continue;
                    }
                    result.append(path);
                    continue;
                }
                if (path.charAt(0) == separator) {
                    result.append(path);
                    continue;
                }
                result.append(separator);
                result.append(path);
                continue;
            }
            result.append(path);
        }
        return result.toString();
    }

    public static String combinePath(Object ... args) {
        ArrayList<String> pathList = new ArrayList<String>();
        for (Object arg : args) {
            if (arg == null) continue;
            if (arg instanceof String) {
                pathList.add((String)arg);
                continue;
            }
            if (arg instanceof File) {
                pathList.add(((File)arg).getAbsolutePath());
                continue;
            }
            pathList.add(arg.toString());
        }
        return FileUtils.combinePath(pathList.toArray(new String[0]));
    }

    public static void createParentDirectory(String filePath) {
        File file = new File(filePath);
        FileUtils.createParentDirectory(file);
    }

    public static void createParentDirectory(File file) {
        if (file.exists()) {
            return;
        }
        if (file.getPath() == null) {
            return;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            FileUtils.mkDirs(parentFile);
        }
    }

    public static void createParentDirectory(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getInputStream(Class<?> clazz, String path) {
        InputStream stream = clazz.getResourceAsStream(path);
        if (stream != null) {
            return stream;
        }
        return FileUtils.getInputStream(path);
    }

    public static InputStream getInputStream(String path) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (stream == null) {
            File file = new File(path);
            try {
                return new FileInputStream(file);
            }
            catch (Exception exception) {
                try {
                    URL sourceUrl = new URL(path);
                    if (sourceUrl != null) {
                        stream = sourceUrl.openStream();
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return stream;
    }

    public static InputStream getInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

