/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.internal.reference;

import com.squareup.anvil.annotations.ExperimentalAnvilApi;
import com.squareup.anvil.compiler.internal.reference.AnnotatedReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReferenceKt;
import com.squareup.anvil.compiler.internal.reference.AnvilModuleDescriptor;
import com.squareup.anvil.compiler.internal.reference.ClassReference;
import com.squareup.anvil.compiler.internal.reference.ClassReferenceKt;
import com.squareup.anvil.compiler.internal.reference.FunctionReference;
import com.squareup.anvil.compiler.internal.reference.FunctionReferenceKt;
import com.squareup.anvil.compiler.internal.reference.ParameterReference;
import com.squareup.anvil.compiler.internal.reference.ParameterReferenceKt;
import com.squareup.anvil.compiler.internal.reference.TypeReference;
import com.squareup.anvil.compiler.internal.reference.TypeReferenceKt;
import com.squareup.anvil.compiler.internal.reference.Visibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002+,B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001dH&J\b\u0010#\u001a\u00020\u001dH&J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J\u0010\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010'\u001a\u0004\u0018\u00010\u0019J\b\u0010(\u001a\u00020\u0010H\u0016J\b\u0010)\u001a\u00020*H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u0082\u0001\u0002-.\u00a8\u0006/"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/FunctionReference;", "Lcom/squareup/anvil/compiler/internal/reference/AnnotatedReference;", "()V", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "module", "Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "getModule", "()Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "name", "", "getName", "()Ljava/lang/String;", "parameters", "", "Lcom/squareup/anvil/compiler/internal/reference/ParameterReference;", "getParameters", "()Ljava/util/List;", "returnType", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "getReturnType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "equals", "", "other", "", "hashCode", "", "isAbstract", "isConstructor", "resolveGenericReturnType", "implementingClass", "resolveGenericReturnTypeOrNull", "returnTypeOrNull", "toString", "visibility", "Lcom/squareup/anvil/compiler/internal/reference/Visibility;", "Descriptor", "Psi", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Psi;", "compiler-utils"})
@ExperimentalAnvilApi
public abstract class FunctionReference
implements AnnotatedReference {
    private FunctionReference() {
    }

    @NotNull
    public abstract FqName getFqName();

    @NotNull
    public abstract ClassReference getDeclaringClass();

    @NotNull
    public final String getName() {
        String string = this.getFqName().shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqName.shortName().asString()");
        return string;
    }

    @NotNull
    public final AnvilModuleDescriptor getModule() {
        return this.getDeclaringClass().getModule();
    }

    @NotNull
    public abstract List<ParameterReference> getParameters();

    @Nullable
    protected abstract TypeReference getReturnType();

    @Nullable
    public final TypeReference returnTypeOrNull() {
        return this.getReturnType();
    }

    @NotNull
    public final TypeReference returnType() {
        TypeReference typeReference = this.getReturnType();
        if (typeReference == null) {
            throw FunctionReferenceKt.AnvilCompilationExceptionFunctionReference$default(this, "Unable to get the return type for function " + this.getFqName() + '.', null, 4, null);
        }
        return typeReference;
    }

    public abstract boolean isAbstract();

    public abstract boolean isConstructor();

    @NotNull
    public abstract Visibility visibility();

    @Nullable
    public final ClassReference resolveGenericReturnTypeOrNull(@NotNull ClassReference implementingClass) {
        TypeReference typeReference;
        Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
        TypeReference typeReference2 = this.getReturnType();
        return typeReference2 != null && (typeReference = typeReference2.resolveGenericTypeOrNull(implementingClass)) != null ? typeReference.asClassReferenceOrNull() : null;
    }

    @NotNull
    public final ClassReference resolveGenericReturnType(@NotNull ClassReference implementingClass) {
        Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
        ClassReference classReference2 = this.resolveGenericReturnTypeOrNull(implementingClass);
        if (classReference2 == null) {
            throw FunctionReferenceKt.AnvilCompilationExceptionFunctionReference$default(this, "Unable to resolve return type for function " + this.getFqName() + " with the implementing class " + implementingClass.getFqName() + '.', null, 4, null);
        }
        return classReference2;
    }

    @NotNull
    public String toString() {
        return this.getFqName() + "()";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassReference)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getFqName(), (Object)((ClassReference)other).getFqName());
    }

    public int hashCode() {
        return this.getFqName().hashCode();
    }

    @Override
    public boolean isAnnotatedWith(@NotNull FqName fqName) {
        return AnnotatedReference.DefaultImpls.isAnnotatedWith(this, fqName);
    }

    public /* synthetic */ FunctionReference(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020#H\u0016R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0018\u0010\rR\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Psi;", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;Lorg/jetbrains/kotlin/name/FqName;)V", "annotations", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Psi;", "getAnnotations", "()Ljava/util/List;", "annotations$delegate", "Lkotlin/Lazy;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getFunction", "()Lorg/jetbrains/kotlin/psi/KtFunction;", "parameters", "Lcom/squareup/anvil/compiler/internal/reference/ParameterReference$Psi;", "getParameters", "parameters$delegate", "returnType", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Psi;", "getReturnType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Psi;", "returnType$delegate", "isAbstract", "", "isConstructor", "visibility", "Lcom/squareup/anvil/compiler/internal/reference/Visibility;", "compiler-utils"})
    public static final class Psi
    extends FunctionReference {
        @NotNull
        private final KtFunction function;
        @NotNull
        private final ClassReference.Psi declaringClass;
        @NotNull
        private final FqName fqName;
        @NotNull
        private final Lazy annotations$delegate;
        @NotNull
        private final Lazy returnType$delegate;
        @NotNull
        private final Lazy parameters$delegate;

        public Psi(@NotNull KtFunction function, @NotNull ClassReference.Psi declaringClass, @NotNull FqName fqName) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)declaringClass, (String)"declaringClass");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            super(null);
            this.function = function;
            this.declaringClass = declaringClass;
            this.fqName = fqName;
            this.annotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Psi>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Psi> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = this.this$0.getFunction().getAnnotationEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"function.annotationEntries");
                    Iterable iterable = list;
                    Psi psi = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        collection.add(AnnotationReferenceKt.toAnnotationReference((KtAnnotationEntry)it, null, (ModuleDescriptor)psi.getModule()));
                    }
                    return (List)destination$iv$iv;
                }
            }));
            this.returnType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TypeReference.Psi>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final TypeReference.Psi invoke() {
                    KtTypeReference ktTypeReference = this.this$0.getFunction().getTypeReference();
                    return ktTypeReference != null ? TypeReferenceKt.toTypeReference(ktTypeReference, this.this$0.getDeclaringClass()) : null;
                }
            }));
            this.parameters$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends ParameterReference.Psi>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<ParameterReference.Psi> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = this.this$0.getFunction().getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"function.valueParameters");
                    Iterable iterable = list;
                    Psi psi = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtParameter ktParameter = (KtParameter)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        collection.add(ParameterReferenceKt.toParameterReference((KtParameter)it, psi));
                    }
                    return (List)destination$iv$iv;
                }
            }));
        }

        @NotNull
        public final KtFunction getFunction() {
            return this.function;
        }

        @Override
        @NotNull
        public ClassReference.Psi getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        @NotNull
        public FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public List<AnnotationReference.Psi> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @Nullable
        protected TypeReference.Psi getReturnType() {
            Lazy lazy = this.returnType$delegate;
            return (TypeReference.Psi)lazy.getValue();
        }

        @NotNull
        public List<ParameterReference.Psi> getParameters() {
            Lazy lazy = this.parameters$delegate;
            return (List)lazy.getValue();
        }

        @Override
        public boolean isAbstract() {
            return this.function.hasModifier(KtTokens.ABSTRACT_KEYWORD) || this.getDeclaringClass().isInterface() && !this.function.hasBody();
        }

        @Override
        public boolean isConstructor() {
            return this.function instanceof KtConstructor;
        }

        @Override
        @NotNull
        public Visibility visibility() {
            Visibility visibility;
            KtModifierKeywordToken visibility2 = KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)this.function));
            if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.PUBLIC_KEYWORD)) {
                visibility = Visibility.PUBLIC;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.INTERNAL_KEYWORD)) {
                visibility = Visibility.INTERNAL;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.PROTECTED_KEYWORD)) {
                visibility = Visibility.PROTECTED;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.PRIVATE_KEYWORD)) {
                visibility = Visibility.PRIVATE;
            } else {
                throw ClassReferenceKt.AnvilCompilationExceptionClassReference$default(this.getDeclaringClass(), "Couldn't get visibility " + visibility2 + " for function " + this.getFqName() + '.', null, 4, null);
            }
            return visibility;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020'H\u0016R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R)\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00030\u00030\n8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0018\u0010\rR!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000f\u001a\u0004\b\u001c\u0010\rR\u001d\u0010\u001e\u001a\u0004\u0018\u00010\u001f8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u000f\u001a\u0004\b \u0010!\u00a8\u0006("}, d2={"Lcom/squareup/anvil/compiler/internal/reference/FunctionReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/FunctionReference;", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;Lorg/jetbrains/kotlin/name/FqName;)V", "annotations", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Descriptor;", "getAnnotations", "()Ljava/util/List;", "annotations$delegate", "Lkotlin/Lazy;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getFunction", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "overriddenFunctions", "kotlin.jvm.PlatformType", "getOverriddenFunctions$compiler_utils", "overriddenFunctions$delegate", "parameters", "Lcom/squareup/anvil/compiler/internal/reference/ParameterReference$Descriptor;", "getParameters", "parameters$delegate", "returnType", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor;", "getReturnType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor;", "returnType$delegate", "isAbstract", "", "isConstructor", "visibility", "Lcom/squareup/anvil/compiler/internal/reference/Visibility;", "compiler-utils"})
    public static final class Descriptor
    extends FunctionReference {
        @NotNull
        private final FunctionDescriptor function;
        @NotNull
        private final ClassReference.Descriptor declaringClass;
        @NotNull
        private final FqName fqName;
        @NotNull
        private final Lazy annotations$delegate;
        @NotNull
        private final Lazy parameters$delegate;
        @NotNull
        private final Lazy returnType$delegate;
        @NotNull
        private final Lazy overriddenFunctions$delegate;

        public Descriptor(@NotNull FunctionDescriptor function, @NotNull ClassReference.Descriptor declaringClass, @NotNull FqName fqName) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)declaringClass, (String)"declaringClass");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            super(null);
            this.function = function;
            this.declaringClass = declaringClass;
            this.fqName = fqName;
            this.annotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Descriptor> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = (Iterable)this.this$0.getFunction().getAnnotations();
                    Descriptor descriptor = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(AnnotationReferenceKt.toAnnotationReference((AnnotationDescriptor)it, null, (ModuleDescriptor)descriptor.getModule()));
                    }
                    return (List)destination$iv$iv;
                }
            }));
            this.parameters$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends ParameterReference.Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<ParameterReference.Descriptor> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = this.this$0.getFunction().getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"function.valueParameters");
                    Iterable iterable = list;
                    Descriptor descriptor = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        collection.add(ParameterReferenceKt.toParameterReference((ValueParameterDescriptor)it, descriptor));
                    }
                    return (List)destination$iv$iv;
                }
            }));
            this.returnType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TypeReference.Descriptor>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final TypeReference.Descriptor invoke() {
                    KotlinType kotlinType = this.this$0.getFunction().getReturnType();
                    return kotlinType != null ? TypeReferenceKt.toTypeReference(kotlinType, this.this$0.getDeclaringClass()) : null;
                }
            }));
            this.overriddenFunctions$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends FunctionDescriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final List<FunctionDescriptor> invoke() {
                    return SequencesKt.toList((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.generateSequence((Object)this.this$0.getFunction().getOverriddenDescriptors(), (Function1)overriddenFunctions.1.INSTANCE)));
                }
            }));
        }

        public /* synthetic */ Descriptor(FunctionDescriptor functionDescriptor, ClassReference.Descriptor descriptor, FqName fqName, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                fqName = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)functionDescriptor));
            }
            this(functionDescriptor, descriptor, fqName);
        }

        @NotNull
        public final FunctionDescriptor getFunction() {
            return this.function;
        }

        @Override
        @NotNull
        public ClassReference.Descriptor getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        @NotNull
        public FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public List<AnnotationReference.Descriptor> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public List<ParameterReference.Descriptor> getParameters() {
            Lazy lazy = this.parameters$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @Nullable
        protected TypeReference.Descriptor getReturnType() {
            Lazy lazy = this.returnType$delegate;
            return (TypeReference.Descriptor)lazy.getValue();
        }

        @NotNull
        public final List<FunctionDescriptor> getOverriddenFunctions$compiler_utils() {
            Lazy lazy = this.overriddenFunctions$delegate;
            return (List)lazy.getValue();
        }

        @Override
        public boolean isAbstract() {
            return this.function.getModality() == Modality.ABSTRACT;
        }

        @Override
        public boolean isConstructor() {
            return this.function instanceof ClassConstructorDescriptor;
        }

        @Override
        @NotNull
        public Visibility visibility() {
            Visibility visibility;
            DescriptorVisibility descriptorVisibility = this.function.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"function.visibility");
            DescriptorVisibility visibility2 = descriptorVisibility;
            if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PUBLIC)) {
                visibility = Visibility.PUBLIC;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.INTERNAL)) {
                visibility = Visibility.INTERNAL;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PROTECTED)) {
                visibility = Visibility.PROTECTED;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PRIVATE)) {
                visibility = Visibility.PRIVATE;
            } else {
                throw ClassReferenceKt.AnvilCompilationExceptionClassReference$default(this.getDeclaringClass(), "Couldn't get visibility " + visibility2 + " for function " + this.getFqName() + '.', null, 4, null);
            }
            return visibility;
        }
    }
}

