/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.internal.reference;

import com.squareup.anvil.annotations.ExperimentalAnvilApi;
import com.squareup.anvil.compiler.internal.PsiUtilsKt;
import com.squareup.anvil.compiler.internal.reference.AnnotatedReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReferenceKt;
import com.squareup.anvil.compiler.internal.reference.AnvilModuleDescriptor;
import com.squareup.anvil.compiler.internal.reference.ClassReference;
import com.squareup.anvil.compiler.internal.reference.ClassReferenceKt;
import com.squareup.anvil.compiler.internal.reference.PropertyReferenceKt;
import com.squareup.anvil.compiler.internal.reference.TypeReference;
import com.squareup.anvil.compiler.internal.reference.TypeReferenceKt;
import com.squareup.anvil.compiler.internal.reference.Visibility;
import com.squareup.kotlinpoet.MemberName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002-.B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020#H&J\b\u0010)\u001a\u00020\u0019H\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010*\u001a\u0004\u0018\u00010\u001fJ\b\u0010+\u001a\u00020,H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u0082\u0001\u0002/0\u00a8\u00061"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/PropertyReference;", "Lcom/squareup/anvil/compiler/internal/reference/AnnotatedReference;", "()V", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getterAnnotations", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference;", "getGetterAnnotations", "()Ljava/util/List;", "memberName", "Lcom/squareup/kotlinpoet/MemberName;", "getMemberName", "()Lcom/squareup/kotlinpoet/MemberName;", "module", "Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "getModule", "()Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "name", "", "getName", "()Ljava/lang/String;", "setterAnnotations", "getSetterAnnotations", "type", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "getType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "equals", "", "other", "", "hashCode", "", "isLateinit", "toString", "typeOrNull", "visibility", "Lcom/squareup/anvil/compiler/internal/reference/Visibility;", "Descriptor", "Psi", "Lcom/squareup/anvil/compiler/internal/reference/PropertyReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/PropertyReference$Psi;", "compiler-utils"})
@ExperimentalAnvilApi
public abstract class PropertyReference
implements AnnotatedReference {
    private PropertyReference() {
    }

    @NotNull
    public abstract FqName getFqName();

    @NotNull
    public abstract ClassReference getDeclaringClass();

    @NotNull
    public final AnvilModuleDescriptor getModule() {
        return this.getDeclaringClass().getModule();
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public final MemberName getMemberName() {
        return new MemberName(ClassReferenceKt.asClassName(this.getDeclaringClass()), this.getName());
    }

    @Nullable
    protected abstract TypeReference getType();

    @NotNull
    public abstract List<AnnotationReference> getSetterAnnotations();

    @NotNull
    public abstract List<AnnotationReference> getGetterAnnotations();

    @NotNull
    public abstract Visibility visibility();

    public abstract boolean isLateinit();

    @Nullable
    public final TypeReference typeOrNull() {
        return this.getType();
    }

    @NotNull
    public final TypeReference type() {
        TypeReference typeReference = this.getType();
        if (typeReference == null) {
            throw PropertyReferenceKt.AnvilCompilationExceptionPropertyReference$default(this, "Unable to get type for property " + this.getFqName() + '.', null, 4, null);
        }
        return typeReference;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getFqName());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassReference)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getFqName(), (Object)((ClassReference)other).getFqName());
    }

    public int hashCode() {
        return this.getFqName().hashCode();
    }

    @Override
    public boolean isAnnotatedWith(@NotNull FqName fqName) {
        return AnnotatedReference.DefaultImpls.isAnnotatedWith(this, fqName);
    }

    public /* synthetic */ PropertyReference(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0011\u001a\u0004\b\u001e\u0010\u000fR\u001d\u0010 \u001a\u0004\u0018\u00010!8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0011\u001a\u0004\b\"\u0010#\u00a8\u0006*"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/PropertyReference$Psi;", "Lcom/squareup/anvil/compiler/internal/reference/PropertyReference;", "property", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)V", "annotations", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Psi;", "getAnnotations", "()Ljava/util/List;", "annotations$delegate", "Lkotlin/Lazy;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getterAnnotations", "getGetterAnnotations", "getterAnnotations$delegate", "getName", "()Ljava/lang/String;", "getProperty", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "setterAnnotations", "getSetterAnnotations", "setterAnnotations$delegate", "type", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "getType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "type$delegate", "isLateinit", "", "visibility", "Lcom/squareup/anvil/compiler/internal/reference/Visibility;", "Companion", "compiler-utils"})
    public static final class Psi
    extends PropertyReference {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final KtCallableDeclaration property;
        @NotNull
        private final ClassReference.Psi declaringClass;
        @NotNull
        private final FqName fqName;
        @NotNull
        private final String name;
        @NotNull
        private final Lazy annotations$delegate;
        @NotNull
        private final Lazy type$delegate;
        @NotNull
        private final Lazy setterAnnotations$delegate;
        @NotNull
        private final Lazy getterAnnotations$delegate;

        private Psi(KtCallableDeclaration property, ClassReference.Psi declaringClass, FqName fqName, String name) {
            super(null);
            this.property = property;
            this.declaringClass = declaringClass;
            this.fqName = fqName;
            this.name = name;
            this.annotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Psi>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Psi> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$filterTo$iv$iv;
                    List list = this.this$0.getProperty().getAnnotationEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"property.annotationEntries");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
                        boolean bl = false;
                        KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = it.getUseSiteTarget();
                        Object annotationUseSiteTarget = ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null;
                        if (!(annotationUseSiteTarget != AnnotationUseSiteTarget.PROPERTY_SETTER && annotationUseSiteTarget != AnnotationUseSiteTarget.PROPERTY_GETTER)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    Psi psi = this.this$0;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtAnnotationEntry bl = (KtAnnotationEntry)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        collection.add(AnnotationReferenceKt.toAnnotationReference((KtAnnotationEntry)it, psi.getDeclaringClass(), (ModuleDescriptor)psi.getModule()));
                    }
                    return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Iterable)this.this$0.getSetterAnnotations()), (Iterable)this.this$0.getGetterAnnotations());
                }
            }));
            this.type$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TypeReference.Psi>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final TypeReference.Psi invoke() {
                    KtTypeReference ktTypeReference = this.this$0.getProperty().getTypeReference();
                    return ktTypeReference != null ? TypeReferenceKt.toTypeReference(ktTypeReference, this.this$0.getDeclaringClass()) : null;
                }
            }));
            this.setterAnnotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Psi>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Psi> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    KtCallableDeclaration $this$filterTo$iv$iv;
                    List list = this.this$0.getProperty().getAnnotationEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"property.annotationEntries");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
                        boolean bl = false;
                        KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = it.getUseSiteTarget();
                        if (!((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) == AnnotationUseSiteTarget.PROPERTY_SETTER)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterTo$iv$iv = this.this$0.getProperty();
                    KtProperty ktProperty = $this$filterTo$iv$iv instanceof KtProperty ? (KtProperty)$this$filterTo$iv$iv : null;
                    List list2 = ktProperty != null && (ktProperty = ktProperty.getSetter()) != null ? ktProperty.getAnnotationEntries() : null;
                    $this$filter$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)(list2 == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)list2));
                    Psi psi = this.this$0;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtAnnotationEntry bl = (KtAnnotationEntry)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        collection.add(AnnotationReferenceKt.toAnnotationReference((KtAnnotationEntry)it, psi.getDeclaringClass(), (ModuleDescriptor)psi.getModule()));
                    }
                    return (List)destination$iv$iv2;
                }
            }));
            this.getterAnnotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Psi>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Psi> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    KtCallableDeclaration $this$filterTo$iv$iv;
                    List list = this.this$0.getProperty().getAnnotationEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"property.annotationEntries");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
                        boolean bl = false;
                        KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = it.getUseSiteTarget();
                        if (!((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) == AnnotationUseSiteTarget.PROPERTY_GETTER)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterTo$iv$iv = this.this$0.getProperty();
                    KtProperty ktProperty = $this$filterTo$iv$iv instanceof KtProperty ? (KtProperty)$this$filterTo$iv$iv : null;
                    List list2 = ktProperty != null && (ktProperty = ktProperty.getGetter()) != null ? ktProperty.getAnnotationEntries() : null;
                    $this$filter$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)(list2 == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)list2));
                    Psi psi = this.this$0;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtAnnotationEntry bl = (KtAnnotationEntry)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        collection.add(AnnotationReferenceKt.toAnnotationReference((KtAnnotationEntry)it, psi.getDeclaringClass(), (ModuleDescriptor)psi.getModule()));
                    }
                    return (List)destination$iv$iv2;
                }
            }));
        }

        @NotNull
        public final KtCallableDeclaration getProperty() {
            return this.property;
        }

        @Override
        @NotNull
        public ClassReference.Psi getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        @NotNull
        public FqName getFqName() {
            return this.fqName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public List<AnnotationReference.Psi> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @Nullable
        protected TypeReference getType() {
            Lazy lazy = this.type$delegate;
            return (TypeReference)lazy.getValue();
        }

        @NotNull
        public List<AnnotationReference.Psi> getSetterAnnotations() {
            Lazy lazy = this.setterAnnotations$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public List<AnnotationReference.Psi> getGetterAnnotations() {
            Lazy lazy = this.getterAnnotations$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public Visibility visibility() {
            Visibility visibility;
            KtModifierKeywordToken visibility2 = KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)this.property));
            if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.PUBLIC_KEYWORD)) {
                visibility = Visibility.PUBLIC;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.INTERNAL_KEYWORD)) {
                visibility = Visibility.INTERNAL;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.PROTECTED_KEYWORD)) {
                visibility = Visibility.PROTECTED;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)KtTokens.PRIVATE_KEYWORD)) {
                visibility = Visibility.PRIVATE;
            } else {
                throw ClassReferenceKt.AnvilCompilationExceptionClassReference$default(this.getDeclaringClass(), "Couldn't get visibility " + visibility2 + " for property " + this.getFqName() + '.', null, 4, null);
            }
            return visibility;
        }

        @Override
        public boolean isLateinit() {
            KtModifierList ktModifierList = this.property.getModifierList();
            return ktModifierList != null ? ktModifierList.hasModifier(KtTokens.LATEINIT_KEYWORD) : false;
        }

        public /* synthetic */ Psi(KtCallableDeclaration property, ClassReference.Psi declaringClass, FqName fqName, String name, DefaultConstructorMarker $constructor_marker) {
            this(property, declaringClass, fqName, name);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u0004\"\f\b\u0000\u0010\u0005*\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0080\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/PropertyReference$Psi$Companion;", "", "()V", "invoke", "Lcom/squareup/anvil/compiler/internal/reference/PropertyReference$Psi;", "T", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;", "property", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "", "invoke$compiler_utils", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)Lcom/squareup/anvil/compiler/internal/reference/PropertyReference$Psi;", "compiler-utils"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final <T extends KtCallableDeclaration & KtValVarKeywordOwner> Psi invoke$compiler_utils(@NotNull T property, @NotNull ClassReference.Psi declaringClass, @NotNull FqName fqName, @NotNull String name) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)declaringClass, (String)"declaringClass");
                Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new Psi(property, declaringClass, fqName, name, null);
            }

            public static /* synthetic */ Psi invoke$compiler_utils$default(Companion companion, KtCallableDeclaration ktCallableDeclaration, ClassReference.Psi psi, FqName fqName, String string, int n, Object object) {
                if ((n & 4) != 0) {
                    fqName = PsiUtilsKt.requireFqName((KtNamedDeclaration)ktCallableDeclaration);
                }
                if ((n & 8) != 0) {
                    String string2 = fqName.shortName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.shortName().asString()");
                    string = string2;
                }
                return companion.invoke$compiler_utils(ktCallableDeclaration, psi, fqName, string);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0011\u001a\u0004\b\u001e\u0010\u000fR\u001b\u0010 \u001a\u00020!8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0011\u001a\u0004\b\"\u0010#\u00a8\u0006)"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/PropertyReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/PropertyReference;", "property", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)V", "annotations", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Descriptor;", "getAnnotations", "()Ljava/util/List;", "annotations$delegate", "Lkotlin/Lazy;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getterAnnotations", "getGetterAnnotations", "getterAnnotations$delegate", "getName", "()Ljava/lang/String;", "getProperty", "()Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "setterAnnotations", "getSetterAnnotations", "setterAnnotations$delegate", "type", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "getType", "()Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "type$delegate", "isLateinit", "", "visibility", "Lcom/squareup/anvil/compiler/internal/reference/Visibility;", "compiler-utils"})
    public static final class Descriptor
    extends PropertyReference {
        @NotNull
        private final PropertyDescriptor property;
        @NotNull
        private final ClassReference.Descriptor declaringClass;
        @NotNull
        private final FqName fqName;
        @NotNull
        private final String name;
        @NotNull
        private final Lazy annotations$delegate;
        @NotNull
        private final Lazy setterAnnotations$delegate;
        @NotNull
        private final Lazy getterAnnotations$delegate;
        @NotNull
        private final Lazy type$delegate;

        public Descriptor(@NotNull PropertyDescriptor property, @NotNull ClassReference.Descriptor declaringClass, @NotNull FqName fqName, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)declaringClass, (String)"declaringClass");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(null);
            this.property = property;
            this.declaringClass = declaringClass;
            this.fqName = fqName;
            this.name = name;
            this.annotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Descriptor> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    FieldDescriptor fieldDescriptor;
                    Iterable iterable = CollectionsKt.plus((Iterable)((Iterable)this.this$0.getProperty().getAnnotations()), (Iterable)((fieldDescriptor = this.this$0.getProperty().getBackingField()) != null && (fieldDescriptor = fieldDescriptor.getAnnotations()) != null ? (Iterable)fieldDescriptor : (Iterable)CollectionsKt.emptyList()));
                    Descriptor descriptor = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(AnnotationReferenceKt.toAnnotationReference((AnnotationDescriptor)it, descriptor.getDeclaringClass(), (ModuleDescriptor)descriptor.getModule()));
                    }
                    return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.this$0.getSetterAnnotations()), (Iterable)this.this$0.getGetterAnnotations());
                }
            }));
            this.setterAnnotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Descriptor> invoke() {
                    List list;
                    List list2;
                    Annotations annotations2;
                    PropertySetterDescriptor propertySetterDescriptor = this.this$0.getProperty().getSetter();
                    if (propertySetterDescriptor != null && (annotations2 = propertySetterDescriptor.getAnnotations()) != null) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = (Iterable)annotations2;
                        Descriptor descriptor = this.this$0;
                        boolean $i$f$map = false;
                        void var6_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(AnnotationReferenceKt.toAnnotationReference((AnnotationDescriptor)it, descriptor.getDeclaringClass(), (ModuleDescriptor)descriptor.getModule()));
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = list = null;
                    }
                    if (list2 == null) {
                        list = CollectionsKt.emptyList();
                    }
                    return list;
                }
            }));
            this.getterAnnotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationReference.Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationReference.Descriptor> invoke() {
                    List list;
                    List list2;
                    Annotations annotations2;
                    PropertyGetterDescriptor propertyGetterDescriptor = this.this$0.getProperty().getGetter();
                    if (propertyGetterDescriptor != null && (annotations2 = propertyGetterDescriptor.getAnnotations()) != null) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = (Iterable)annotations2;
                        Descriptor descriptor = this.this$0;
                        boolean $i$f$map = false;
                        void var6_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(AnnotationReferenceKt.toAnnotationReference((AnnotationDescriptor)it, descriptor.getDeclaringClass(), (ModuleDescriptor)descriptor.getModule()));
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = list = null;
                    }
                    if (list2 == null) {
                        list = CollectionsKt.emptyList();
                    }
                    return list;
                }
            }));
            this.type$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TypeReference.Descriptor>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final TypeReference.Descriptor invoke() {
                    KotlinType kotlinType = this.this$0.getProperty().getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"property.type");
                    return TypeReferenceKt.toTypeReference(kotlinType, this.this$0.getDeclaringClass());
                }
            }));
        }

        public /* synthetic */ Descriptor(PropertyDescriptor propertyDescriptor, ClassReference.Descriptor descriptor, FqName fqName, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                fqName = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)propertyDescriptor));
            }
            if ((n & 8) != 0) {
                String string2 = fqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.shortName().asString()");
                string = string2;
            }
            this(propertyDescriptor, descriptor, fqName, string);
        }

        @NotNull
        public final PropertyDescriptor getProperty() {
            return this.property;
        }

        @Override
        @NotNull
        public ClassReference.Descriptor getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        @NotNull
        public FqName getFqName() {
            return this.fqName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public List<AnnotationReference.Descriptor> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public List<AnnotationReference.Descriptor> getSetterAnnotations() {
            Lazy lazy = this.setterAnnotations$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public List<AnnotationReference.Descriptor> getGetterAnnotations() {
            Lazy lazy = this.getterAnnotations$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        protected TypeReference getType() {
            Lazy lazy = this.type$delegate;
            return (TypeReference)lazy.getValue();
        }

        @Override
        @NotNull
        public Visibility visibility() {
            Visibility visibility;
            DescriptorVisibility descriptorVisibility = this.property.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"property.visibility");
            DescriptorVisibility visibility2 = descriptorVisibility;
            if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PUBLIC)) {
                visibility = Visibility.PUBLIC;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.INTERNAL)) {
                visibility = Visibility.INTERNAL;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PROTECTED)) {
                visibility = Visibility.PROTECTED;
            } else if (Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.PRIVATE)) {
                visibility = Visibility.PRIVATE;
            } else {
                throw ClassReferenceKt.AnvilCompilationExceptionClassReference$default(this.getDeclaringClass(), "Couldn't get visibility " + visibility2 + " for property " + this.getFqName() + '.', null, 4, null);
            }
            return visibility;
        }

        @Override
        public boolean isLateinit() {
            return this.property.isLateInit();
        }
    }
}

