/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.plugin;

import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.SourceProvider;
import com.squareup.anvil.plugin.CheckMixedSourceSet;
import com.squareup.anvil.plugin.Variant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.Kapt3GradleSubplugin;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/squareup/anvil/plugin/CheckMixedSourceSet;", "", "()V", "disablePreciseJavaTrackingIfNeeded", "", "compileTask", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "input", "Lcom/squareup/anvil/plugin/CheckMixedSourceSet$Input;", "getAndroidSourceDirs", "Lorg/gradle/api/file/FileCollection;", "variant", "Lcom/squareup/anvil/plugin/Variant;", "getJvmSourceDirs", "preparePreciseJavaTrackingCheck", "isKaptApplied", "Lorg/gradle/api/provider/Property;", "", "Lorg/gradle/api/Project;", "Input", "gradle-plugin"})
public final class CheckMixedSourceSet {
    @NotNull
    public static final CheckMixedSourceSet INSTANCE = new CheckMixedSourceSet();

    private CheckMixedSourceSet() {
    }

    @NotNull
    public final Input preparePreciseJavaTrackingCheck(@NotNull Variant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        FileCollection fileCollection = this.getAndroidSourceDirs(variant);
        if (fileCollection == null) {
            fileCollection = this.getJvmSourceDirs(variant);
        }
        return new Input(fileCollection, this.isKaptApplied(variant.getProject()));
    }

    /*
     * WARNING - void declaration
     */
    public final void disablePreciseJavaTrackingIfNeeded(@NotNull KotlinCompile compileTask, @NotNull Input input) {
        block14: {
            block13: {
                boolean hasJavaFile2;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)compileTask, (String)"compileTask");
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Object object = input.getSources();
                if (object == null) {
                    bl = false;
                } else {
                    Sequence sequence = CollectionsKt.asSequence((Iterable)((Iterable)object));
                    if (sequence == null) {
                        bl = false;
                    } else {
                        Sequence sequence2 = SequencesKt.flatMap((Sequence)sequence, (Function1)disablePreciseJavaTrackingIfNeeded.hasJavaFile.1.INSTANCE);
                        if (sequence2 == null) {
                            bl = false;
                        } else {
                            Sequence sequence3 = SequencesKt.filter((Sequence)sequence2, (Function1)disablePreciseJavaTrackingIfNeeded.hasJavaFile.2.INSTANCE);
                            if (sequence3 == null) {
                                bl = false;
                            } else {
                                boolean bl2;
                                boolean bl3;
                                block12: {
                                    void $this$any$iv;
                                    Sequence sequence4 = sequence3;
                                    boolean $i$f$any = false;
                                    for (Object element$iv : $this$any$iv) {
                                        File it = (File)element$iv;
                                        boolean bl4 = false;
                                        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"java")) continue;
                                        bl3 = true;
                                        break block12;
                                    }
                                    bl3 = false;
                                }
                                bl = hasJavaFile2 = (bl2 = bl3);
                            }
                        }
                    }
                }
                if (hasJavaFile2) break block13;
                object = input.isKaptApplied().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.isKaptApplied.get()");
                if (!((Boolean)object).booleanValue()) break block14;
            }
            compileTask.setUsePreciseJavaTracking(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FileCollection getAndroidSourceDirs(Variant variant) {
        ConfigurableFileCollection configurableFileCollection;
        BaseVariant baseVariant = variant.getAndroidVariant();
        if (baseVariant == null) {
            configurableFileCollection = null;
        } else {
            List list = baseVariant.getSourceSets();
            if (list == null) {
                configurableFileCollection = null;
            } else {
                List list2;
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Iterable iterable = list;
                boolean $i$f$flatMap = false;
                void var7_7 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    SourceProvider it = (SourceProvider)element$iv$iv;
                    boolean bl = false;
                    Collection collection = it.getJavaDirectories();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.javaDirectories");
                    Iterable list$iv$iv = collection;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List it = list2 = (List)destination$iv$iv;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                configurableFileCollection = variant.getProject().files(objectArray);
            }
        }
        return (FileCollection)configurableFileCollection;
    }

    /*
     * WARNING - void declaration
     */
    private final FileCollection getJvmSourceDirs(Variant variant) {
        SourceDirectorySet sourceDirectorySet;
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)variant.getProject().getExtensions().findByType(JavaPluginExtension.class);
        if (javaPluginExtension == null) {
            sourceDirectorySet = null;
        } else {
            SourceSetContainer sourceSetContainer = javaPluginExtension.getSourceSets();
            if (sourceSetContainer == null) {
                sourceDirectorySet = null;
            } else {
                void $this$single$iv;
                Iterable iterable = (Iterable)sourceSetContainer;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    SourceSet it = (SourceSet)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)variant.getName())) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                SourceSet sourceSet = single$iv;
                sourceDirectorySet = sourceSet == null ? null : sourceSet.getAllJava();
            }
        }
        return (FileCollection)sourceDirectorySet;
    }

    private final Property<Boolean> isKaptApplied(Project $this$isKaptApplied) {
        Property property;
        Property it = property = $this$isKaptApplied.getObjects().property(Boolean.TYPE);
        boolean bl = false;
        it.set((Object)$this$isKaptApplied.getPlugins().hasPlugin(Kapt3GradleSubplugin.class));
        Property property2 = property;
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"objects\n      .property(\u2026gin::class.java))\n      }");
        return property2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/squareup/anvil/plugin/CheckMixedSourceSet$Input;", "", "sources", "Lorg/gradle/api/file/FileCollection;", "isKaptApplied", "Lorg/gradle/api/provider/Property;", "", "(Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/provider/Property;)V", "()Lorg/gradle/api/provider/Property;", "getSources", "()Lorg/gradle/api/file/FileCollection;", "gradle-plugin"})
    public static final class Input {
        @Nullable
        private final FileCollection sources;
        @NotNull
        private final Property<Boolean> isKaptApplied;

        public Input(@Nullable FileCollection sources, @NotNull Property<Boolean> isKaptApplied) {
            Intrinsics.checkNotNullParameter(isKaptApplied, (String)"isKaptApplied");
            this.sources = sources;
            this.isKaptApplied = isKaptApplied;
        }

        @Nullable
        public final FileCollection getSources() {
            return this.sources;
        }

        @NotNull
        public final Property<Boolean> isKaptApplied() {
            return this.isKaptApplied;
        }
    }
}

