/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.appcompat.v7.api.app;

import android.support.v7.app.ActionBar;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class ActionBarAssert
extends AbstractAssert<ActionBarAssert, ActionBar> {
    public ActionBarAssert(ActionBar actual) {
        super((Object)actual, ActionBarAssert.class);
    }

    public ActionBarAssert hasCustomView() {
        this.isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)((ActionBar)this.actual).getCustomView()).overridingErrorMessage("Expected custom view but was not present.", new Object[0])).isNotNull();
        return this;
    }

    public ActionBarAssert hasDisplayOptions(int options) {
        this.isNotNull();
        int actualOptions = ((ActionBar)this.actual).getDisplayOptions();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOptions).overridingErrorMessage("Expected display options <%s> but was <%s>.", new Object[]{ActionBarAssert.displayOptionsToString(options), ActionBarAssert.displayOptionsToString(actualOptions)})).isEqualTo(options);
        return this;
    }

    public ActionBarAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((ActionBar)this.actual).getHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public ActionBarAssert hasNavigationItemCount(int count) {
        this.isNotNull();
        int actualCount = ((ActionBar)this.actual).getNavigationItemCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public ActionBarAssert hasNavigationMode(int mode) {
        this.isNotNull();
        int actualMode = ((ActionBar)this.actual).getNavigationMode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected mode <%s> but was <%s>.", new Object[]{ActionBarAssert.navigationModeToString(mode), ActionBarAssert.navigationModeToString(actualMode)})).isEqualTo(mode);
        return this;
    }

    public ActionBarAssert hasSelectedNavigationIndex(int index) {
        this.isNotNull();
        int actualIndex = ((ActionBar)this.actual).getSelectedNavigationIndex();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected selected index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public ActionBarAssert hasSubtitle(CharSequence subtitle) {
        this.isNotNull();
        CharSequence actualSubtitle = ((ActionBar)this.actual).getSubtitle();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualSubtitle).overridingErrorMessage("Expected subtitle <%s> but was <%s>.", new Object[]{subtitle, actualSubtitle})).isEqualTo((Object)subtitle);
        return this;
    }

    public ActionBarAssert hasSubtitle(int resId) {
        return this.hasSubtitle(((ActionBar)this.actual).getThemedContext().getString(resId));
    }

    public ActionBarAssert hasTabCount(int count) {
        this.isNotNull();
        int actualCount = ((ActionBar)this.actual).getTabCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected tab count of <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public ActionBarAssert hasTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((ActionBar)this.actual).getTitle();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return this;
    }

    public ActionBarAssert hasTitle(int resId) {
        return this.hasTitle(((ActionBar)this.actual).getThemedContext().getString(resId));
    }

    public ActionBarAssert isShowing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ActionBar)this.actual).isShowing()).overridingErrorMessage("Expected to be showing but was not showing.", new Object[0])).isTrue();
        return this;
    }

    public ActionBarAssert isNotShowing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ActionBar)this.actual).isShowing()).overridingErrorMessage("Expected to be not showing but was showing.", new Object[0])).isFalse();
        return this;
    }

    public static String navigationModeToString(int mode) {
        return IntegerUtils.buildNamedValueString((int)mode).value(1, "list").value(0, "standard").value(2, "tabs").get();
    }

    public static String displayOptionsToString(int options) {
        return IntegerUtils.buildBitMaskString((int)options).flag(4, "homeAsUp").flag(16, "showCustom").flag(2, "showHome").flag(8, "showTitle").flag(1, "useLogo").get();
    }
}

