/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.appcompat.v7.api.widget;

import android.support.v4.widget.CursorAdapter;
import android.support.v7.widget.SearchView;
import org.assertj.android.appcompat.v7.api.widget.AbstractLinearLayoutCompatAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class SearchViewAssert
extends AbstractLinearLayoutCompatAssert<SearchViewAssert, SearchView> {
    public SearchViewAssert(SearchView actual) {
        super(actual, SearchViewAssert.class);
    }

    public SearchViewAssert hasImeOptions(int options) {
        this.isNotNull();
        int actualOptions = ((SearchView)this.actual).getImeOptions();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOptions).overridingErrorMessage("Expected IME options <%s> but was <%s>.", new Object[]{options, actualOptions})).isEqualTo(options);
        return this;
    }

    public SearchViewAssert hasInputType(int type) {
        this.isNotNull();
        int actualType = ((SearchView)this.actual).getInputType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected input type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo(type);
        return this;
    }

    public SearchViewAssert hasMaximumWidth(int width) {
        this.isNotNull();
        int actualWidth = ((SearchView)this.actual).getMaxWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected maximum width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public SearchViewAssert hasQuery(CharSequence query) {
        this.isNotNull();
        CharSequence actualQuery = ((SearchView)this.actual).getQuery();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualQuery).overridingErrorMessage("Expected query <%s> but was <%s>.", new Object[]{query, actualQuery})).isEqualTo((Object)query);
        return this;
    }

    public SearchViewAssert hasQueryHint(CharSequence hint) {
        this.isNotNull();
        CharSequence actualHint = ((SearchView)this.actual).getQueryHint();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualHint).overridingErrorMessage("Expected query hint <%s> but was <%s>.", new Object[]{hint, actualHint})).isEqualTo((Object)hint);
        return this;
    }

    public SearchViewAssert hasQueryHint(int resId) {
        this.isNotNull();
        return this.hasQueryHint(((SearchView)this.actual).getContext().getString(resId));
    }

    public SearchViewAssert hasSuggestionsAdapter(CursorAdapter adapter) {
        this.isNotNull();
        CursorAdapter actualAdapter = ((SearchView)this.actual).getSuggestionsAdapter();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualAdapter).overridingErrorMessage("Expected suggestions adapter <%s> but was <%s>.", new Object[]{adapter, actualAdapter})).isSameAs((Object)adapter);
        return this;
    }

    public SearchViewAssert isIconifiedByDefault() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SearchView)this.actual).isIconfiedByDefault()).overridingErrorMessage("Expected to be iconified by default but was not.", new Object[0])).isTrue();
        return this;
    }

    public SearchViewAssert isNotIconifiedByDefault() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SearchView)this.actual).isIconfiedByDefault()).overridingErrorMessage("Expected to not be iconified by default but was not.", new Object[0])).isFalse();
        return this;
    }

    public SearchViewAssert isIconified() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SearchView)this.actual).isIconified()).overridingErrorMessage("Expected to be iconified but was not.", new Object[0])).isTrue();
        return this;
    }

    public SearchViewAssert isNotIconified() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SearchView)this.actual).isIconified()).overridingErrorMessage("Expected to not be iconified but was not.", new Object[0])).isFalse();
        return this;
    }

    public SearchViewAssert isQueryRefinementEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SearchView)this.actual).isQueryRefinementEnabled()).overridingErrorMessage("Expected query refinement to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public SearchViewAssert isQueryRefinementDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SearchView)this.actual).isQueryRefinementEnabled()).overridingErrorMessage("Expected query refinement to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }

    public SearchViewAssert isSubmitButtonEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SearchView)this.actual).isSubmitButtonEnabled()).overridingErrorMessage("Expected submit button to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public SearchViewAssert isSubmitButtonDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((SearchView)this.actual).isSubmitButtonEnabled()).overridingErrorMessage("Expected submit button to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }
}

