/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.java.JavaWriter;
import dagger.Module;
import dagger.Provides;
import dagger.internal.Binding;
import dagger.internal.Linker;
import dagger.internal.ModuleAdapter;
import dagger.internal.SetBinding;
import dagger.internal.codegen.CodeGen;
import dagger.internal.codegen.GeneratorKeys;
import dagger.internal.codegen.ProcessorJavadocs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"dagger.Provides", "dagger.Module"})
public final class ProvidesProcessor
extends AbstractProcessor {
    private final LinkedHashMap<String, List<ExecutableElement>> remainingTypes = new LinkedHashMap();
    private static final String BINDINGS_MAP = JavaWriter.type(Map.class, (String[])new String[]{String.class.getCanonicalName(), Binding.class.getCanonicalName() + "<?>"});

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> types, RoundEnvironment env) {
        this.remainingTypes.putAll(this.providerMethodsByClass(env));
        Iterator<String> i = this.remainingTypes.keySet().iterator();
        while (i.hasNext()) {
            String typeName = i.next();
            TypeElement type = this.processingEnv.getElementUtils().getTypeElement(typeName);
            List<ExecutableElement> providesTypes = this.remainingTypes.get(typeName);
            try {
                Map<String, Object> parsedAnnotation = CodeGen.getAnnotation(Module.class, type);
                try {
                    this.writeModuleAdapter(type, parsedAnnotation, providesTypes);
                }
                catch (IOException e) {
                    this.error("Code gen failed: " + e, type);
                }
                i.remove();
            }
            catch (IllegalStateException e) {}
        }
        if (env.processingOver() && this.remainingTypes.size() > 0) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not find types required by provides methods for " + this.remainingTypes.keySet());
        }
        return false;
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    private Map<String, List<ExecutableElement>> providerMethodsByClass(RoundEnvironment env) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement providerElement = elementUtils.getTypeElement("javax.inject.Provider");
        TypeMirror providerType = typeUtils.erasure(providerElement.asType());
        TypeElement lazyElement = elementUtils.getTypeElement("dagger.Lazy");
        TypeMirror lazyType = typeUtils.erasure(lazyElement.asType());
        HashMap<String, List<ExecutableElement>> result = new HashMap<String, List<ExecutableElement>>();
        for (Element element : this.providesMethods(env)) {
            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
            Set<Modifier> typeModifiers = typeElement.getModifiers();
            if (typeElement.getKind() != ElementKind.CLASS) {
                this.error("Unexpected @Provides on " + element, element);
                continue;
            }
            if (typeModifiers.contains((Object)Modifier.PRIVATE) || typeModifiers.contains((Object)Modifier.ABSTRACT)) {
                this.error("Classes declaring @Provides methods must not be private or abstract: " + typeElement.getQualifiedName(), typeElement);
                continue;
            }
            Set<Modifier> methodModifiers = element.getModifiers();
            if (methodModifiers.contains((Object)Modifier.PRIVATE) || methodModifiers.contains((Object)Modifier.ABSTRACT) || methodModifiers.contains((Object)Modifier.STATIC)) {
                this.error("@Provides methods must not be private, abstract or static: " + typeElement.getQualifiedName() + "." + element, element);
                continue;
            }
            ExecutableElement providerMethodAsExecutable = (ExecutableElement)element;
            if (!providerMethodAsExecutable.getThrownTypes().isEmpty()) {
                this.error("@Provides methods must not have a throws clause: " + typeElement.getQualifiedName() + "." + element, element);
                continue;
            }
            TypeMirror returnType = typeUtils.erasure(providerMethodAsExecutable.getReturnType());
            if (typeUtils.isSameType(returnType, providerType)) {
                this.error("@Provides method must not return Provider directly: " + typeElement.getQualifiedName() + "." + element, element);
                continue;
            }
            if (typeUtils.isSameType(returnType, lazyType)) {
                this.error("@Provides method must not return Lazy directly: " + typeElement.getQualifiedName() + "." + element, element);
                continue;
            }
            ArrayList<ExecutableElement> methods = (ArrayList<ExecutableElement>)result.get(typeElement.getQualifiedName().toString());
            if (methods == null) {
                methods = new ArrayList<ExecutableElement>();
                result.put(typeElement.getQualifiedName().toString(), methods);
            }
            methods.add(providerMethodAsExecutable);
        }
        TypeMirror objectType = elementUtils.getTypeElement("java.lang.Object").asType();
        for (Element element : env.getElementsAnnotatedWith(Module.class)) {
            String moduleName;
            if (!element.getKind().equals((Object)ElementKind.CLASS)) {
                this.error("Modules must be classes: " + element, element);
                continue;
            }
            TypeElement moduleType = (TypeElement)element;
            if (!((Object)moduleType.getSuperclass()).equals(objectType)) {
                this.error("Modules must not extend from other classes: " + element, element);
            }
            if (result.containsKey(moduleName = moduleType.getQualifiedName().toString())) continue;
            result.put(moduleName, new ArrayList());
        }
        return result;
    }

    private Set<? extends Element> providesMethods(RoundEnvironment env) {
        LinkedHashSet<? extends Element> result = new LinkedHashSet<Element>();
        result.addAll(env.getElementsAnnotatedWith(Provides.class));
        return result;
    }

    private void writeModuleAdapter(TypeElement type, Map<String, Object> module, List<ExecutableElement> providerMethods) throws IOException {
        if (module == null) {
            this.error(type + " has @Provides methods but no @Module annotation", type);
            return;
        }
        Object[] staticInjections = (Object[])module.get("staticInjections");
        Object[] injects = (Object[])module.get("injects");
        Object[] includes = (Object[])module.get("includes");
        boolean overrides = (Boolean)module.get("overrides");
        boolean complete = (Boolean)module.get("complete");
        boolean library = (Boolean)module.get("library");
        String adapterName = CodeGen.adapterName(type, "$$ModuleAdapter");
        JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(adapterName, type);
        JavaWriter writer = new JavaWriter(sourceFile.openWriter());
        boolean multibindings = this.checkForMultibindings(providerMethods);
        boolean providerMethodDependencies = this.checkForDependencies(providerMethods);
        writer.emitEndOfLineComment("Code generated by dagger-compiler.  Do not edit.", new Object[0]);
        writer.emitPackage(CodeGen.getPackage(type).getQualifiedName().toString());
        writer.emitEmptyLine();
        writer.emitImports(this.getImports(multibindings, !providerMethods.isEmpty(), providerMethodDependencies));
        String typeName = type.getQualifiedName().toString();
        writer.emitEmptyLine();
        writer.emitJavadoc("A manager of modules and provides adapters allowing for proper linking and\ninstance provision of types served by {@code @Provides} methods.", new Object[0]);
        writer.beginType(adapterName, "class", 17, JavaWriter.type(ModuleAdapter.class, (String[])new String[]{typeName}), new String[0]);
        StringBuilder injectsField = new StringBuilder().append("{ ");
        for (Object injectableType : injects) {
            TypeMirror typeMirror = (TypeMirror)injectableType;
            String key = CodeGen.isInterface(typeMirror) ? GeneratorKeys.get(typeMirror) : GeneratorKeys.rawMembersKey(typeMirror);
            injectsField.append(JavaWriter.stringLiteral((String)key)).append(", ");
        }
        injectsField.append("}");
        writer.emitField("String[]", "INJECTS", 26, injectsField.toString());
        StringBuilder staticInjectionsField = new StringBuilder().append("{ ");
        for (Object staticInjection : staticInjections) {
            TypeMirror typeMirror = (TypeMirror)staticInjection;
            staticInjectionsField.append(CodeGen.typeToString(typeMirror)).append(".class, ");
        }
        staticInjectionsField.append("}");
        writer.emitField("Class<?>[]", "STATIC_INJECTIONS", 26, staticInjectionsField.toString());
        StringBuilder includesField = new StringBuilder().append("{ ");
        for (Object include : includes) {
            if (!(include instanceof TypeMirror)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unexpected value: " + include + " in includes of " + type, type);
                continue;
            }
            TypeMirror typeMirror = (TypeMirror)include;
            includesField.append(CodeGen.typeToString(typeMirror)).append(".class, ");
        }
        includesField.append("}");
        writer.emitField("Class<?>[]", "INCLUDES", 26, includesField.toString());
        writer.emitEmptyLine();
        writer.beginMethod(null, adapterName, 1, new String[0]);
        writer.emitStatement("super(INJECTS, STATIC_INJECTIONS, %s /*overrides*/, INCLUDES, %s /*complete*/, %s /*library*/)", new Object[]{overrides, complete, library});
        writer.endMethod();
        ExecutableElement noArgsConstructor = CodeGen.getNoArgsConstructor(type);
        if (noArgsConstructor != null && CodeGen.isCallableConstructor(noArgsConstructor)) {
            writer.emitEmptyLine();
            writer.emitAnnotation(Override.class);
            writer.beginMethod(typeName, "newModule", 4, new String[0]);
            writer.emitStatement("return new %s()", new Object[]{typeName});
            writer.endMethod();
        }
        LinkedHashMap<ExecutableElement, String> methodToClassName = new LinkedHashMap<ExecutableElement, String>();
        LinkedHashMap<String, AtomicInteger> methodNameToNextId = new LinkedHashMap<String, AtomicInteger>();
        if (!providerMethods.isEmpty()) {
            writer.emitEmptyLine();
            writer.emitJavadoc("Used internally obtain dependency information, such as for cyclical\ngraph detection.", new Object[0]);
            writer.emitAnnotation(Override.class);
            writer.beginMethod("void", "getBindings", 1, new String[]{BINDINGS_MAP, "map"});
            block7: for (ExecutableElement providerMethod : providerMethods) {
                Provides provides = providerMethod.getAnnotation(Provides.class);
                switch (provides.type()) {
                    case UNIQUE: {
                        String key = GeneratorKeys.get(providerMethod);
                        writer.emitStatement("map.put(%s, new %s(module))", new Object[]{JavaWriter.stringLiteral((String)key), this.bindingClassName(providerMethod, methodToClassName, methodNameToNextId)});
                        continue block7;
                    }
                    case SET: {
                        String key = GeneratorKeys.getSetKey(providerMethod);
                        writer.emitStatement("SetBinding.add(map, %s, new %s(module))", new Object[]{JavaWriter.stringLiteral((String)key), this.bindingClassName(providerMethod, methodToClassName, methodNameToNextId)});
                        continue block7;
                    }
                }
                throw new AssertionError((Object)("Unknown @Provides type " + provides.type()));
            }
            writer.endMethod();
        }
        for (ExecutableElement providerMethod : providerMethods) {
            this.writeProvidesAdapter(writer, providerMethod, methodToClassName, methodNameToNextId, library);
        }
        writer.endType();
        writer.close();
    }

    private Set<String> getImports(boolean multibindings, boolean providers, boolean dependencies) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        imports.add(ModuleAdapter.class.getCanonicalName());
        if (providers) {
            imports.add(Binding.class.getCanonicalName());
            imports.add(Map.class.getCanonicalName());
            imports.add(Provider.class.getCanonicalName());
        }
        if (dependencies) {
            imports.add(Linker.class.getCanonicalName());
            imports.add(Set.class.getCanonicalName());
        }
        if (multibindings) {
            imports.add(SetBinding.class.getCanonicalName());
        }
        return imports;
    }

    private boolean checkForDependencies(List<ExecutableElement> providerMethods) {
        for (ExecutableElement element : providerMethods) {
            if (element.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean checkForMultibindings(List<ExecutableElement> providerMethods) {
        for (ExecutableElement element : providerMethods) {
            if (element.getAnnotation(Provides.class).type() != Provides.Type.SET) continue;
            return true;
        }
        return false;
    }

    private String bindingClassName(ExecutableElement providerMethod, Map<ExecutableElement, String> methodToClassName, Map<String, AtomicInteger> methodNameToNextId) {
        String className = methodToClassName.get(providerMethod);
        if (className != null) {
            return className;
        }
        String methodName = providerMethod.getSimpleName().toString();
        String suffix = "";
        AtomicInteger id = methodNameToNextId.get(methodName);
        if (id == null) {
            methodNameToNextId.put(methodName, new AtomicInteger(2));
        } else {
            suffix = id.toString();
            id.incrementAndGet();
        }
        String uppercaseMethodName = Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        className = uppercaseMethodName + "ProvidesAdapter" + suffix;
        methodToClassName.put(providerMethod, className);
        return className;
    }

    private void writeProvidesAdapter(JavaWriter writer, ExecutableElement providerMethod, Map<ExecutableElement, String> methodToClassName, Map<String, AtomicInteger> methodNameToNextId, boolean library) throws IOException {
        String methodName = providerMethod.getSimpleName().toString();
        String moduleType = CodeGen.typeToString(providerMethod.getEnclosingElement().asType());
        String className = this.bindingClassName(providerMethod, methodToClassName, methodNameToNextId);
        String returnType = CodeGen.typeToString(providerMethod.getReturnType());
        List<? extends VariableElement> parameters = providerMethod.getParameters();
        boolean dependent = !parameters.isEmpty();
        writer.emitEmptyLine();
        writer.emitJavadoc(ProcessorJavadocs.binderTypeDocs(returnType, false, false, dependent), new Object[0]);
        writer.beginType(className, "class", 25, JavaWriter.type(Binding.class, (String[])new String[]{returnType}), new String[]{JavaWriter.type(Provider.class, (String[])new String[]{returnType})});
        writer.emitField(moduleType, "module", 18);
        for (VariableElement variableElement : parameters) {
            TypeMirror parameterType = variableElement.asType();
            writer.emitField(JavaWriter.type(Binding.class, (String[])new String[]{CodeGen.typeToString(parameterType)}), this.parameterName(variableElement), 2);
        }
        writer.emitEmptyLine();
        writer.beginMethod(null, className, 1, new String[]{moduleType, "module"});
        boolean singleton = providerMethod.getAnnotation(Singleton.class) != null;
        String string = JavaWriter.stringLiteral((String)GeneratorKeys.get(providerMethod));
        Object membersKey = null;
        writer.emitStatement("super(%s, %s, %s, %s)", new Object[]{string, membersKey, singleton ? "IS_SINGLETON" : "NOT_SINGLETON", JavaWriter.stringLiteral((String)(moduleType + "." + methodName + "()"))});
        writer.emitStatement("this.module = module", new Object[0]);
        writer.emitStatement("setLibrary(%s)", new Object[]{library});
        writer.endMethod();
        if (dependent) {
            writer.emitEmptyLine();
            writer.emitJavadoc("Used internally to link bindings/providers together at run time\naccording to their dependency graph.", new Object[0]);
            writer.emitAnnotation(Override.class);
            writer.emitAnnotation(SuppressWarnings.class, (Object)JavaWriter.stringLiteral((String)"unchecked"));
            writer.beginMethod("void", "attach", 1, new String[]{Linker.class.getCanonicalName(), "linker"});
            for (VariableElement variableElement : parameters) {
                String string2 = GeneratorKeys.get(variableElement);
                writer.emitStatement("%s = (%s) linker.requestBinding(%s, %s.class)", new Object[]{this.parameterName(variableElement), writer.compressType(JavaWriter.type(Binding.class, (String[])new String[]{CodeGen.typeToString(variableElement.asType())})), JavaWriter.stringLiteral((String)string2), writer.compressType(moduleType)});
            }
            writer.endMethod();
            writer.emitEmptyLine();
            writer.emitJavadoc("Used internally obtain dependency information, such as for cyclical\ngraph detection.", new Object[0]);
            writer.emitAnnotation(Override.class);
            String setOfBindings = JavaWriter.type(Set.class, (String[])new String[]{"Binding<?>"});
            writer.beginMethod("void", "getDependencies", 1, new String[]{setOfBindings, "getBindings", setOfBindings, "injectMembersBindings"});
            for (VariableElement variableElement : parameters) {
                writer.emitStatement("getBindings.add(%s)", new Object[]{variableElement.getSimpleName().toString()});
            }
            writer.endMethod();
        }
        writer.emitEmptyLine();
        writer.emitJavadoc("Returns the fully provisioned instance satisfying the contract for\n{@code Provider<%s>}.", new Object[]{returnType});
        writer.emitAnnotation(Override.class);
        writer.beginMethod(returnType, "get", 1, new String[0]);
        StringBuilder args = new StringBuilder();
        boolean bl = true;
        for (VariableElement variableElement : parameters) {
            boolean bl2;
            if (!bl2) {
                args.append(", ");
            } else {
                bl2 = false;
            }
            args.append(String.format("%s.get()", variableElement.getSimpleName().toString()));
        }
        writer.emitStatement("return module.%s(%s)", new Object[]{methodName, args.toString()});
        writer.endMethod();
        writer.endType();
    }

    private String parameterName(Element parameter) {
        if (parameter.getSimpleName().contentEquals("module")) {
            return "parameter_" + parameter.getSimpleName().toString();
        }
        return parameter.getSimpleName().toString();
    }
}

