/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.Binding;
import dagger.internal.Linker;
import dagger.internal.codegen.CodeGen;
import dagger.internal.codegen.GeneratorKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class AtInjectBinding
extends Binding<Object> {
    private final TypeElement type;
    private final List<String> keys;
    private final Binding<?>[] bindings;
    private final String supertypeKey;
    private Binding supertypeBinding;

    private AtInjectBinding(String provideKey, String membersKey, TypeElement type, List<String> keys, String supertypeKey) {
        super(provideKey, membersKey, type.getAnnotation(Singleton.class) != null, (Object)type.getQualifiedName().toString());
        this.type = type;
        this.keys = keys;
        this.bindings = new Binding[keys.size()];
        this.supertypeKey = supertypeKey;
    }

    static AtInjectBinding create(TypeElement type, boolean mustHaveInjections) {
        ArrayList<String> requiredKeys = new ArrayList<String>();
        boolean hasInjectConstructor = false;
        boolean hasNoArgsConstructor = false;
        block4: for (Element element : type.getEnclosedElements()) {
            switch (element.getKind()) {
                case FIELD: {
                    if (!AtInjectBinding.hasAtInject(element) || element.getModifiers().contains((Object)Modifier.STATIC)) continue block4;
                    requiredKeys.add(GeneratorKeys.get((VariableElement)element));
                    break;
                }
                case CONSTRUCTOR: {
                    ExecutableElement constructor = (ExecutableElement)element;
                    List<? extends VariableElement> parameters = constructor.getParameters();
                    if (AtInjectBinding.hasAtInject(element)) {
                        if (hasInjectConstructor) {
                            throw new IllegalArgumentException("Too many injectable constructors on " + type.getQualifiedName().toString());
                        }
                        hasInjectConstructor = true;
                        for (VariableElement variableElement : parameters) {
                            requiredKeys.add(GeneratorKeys.get(variableElement));
                        }
                        continue block4;
                    }
                    if (!parameters.isEmpty()) continue block4;
                    hasNoArgsConstructor = true;
                    break;
                }
                default: {
                    if (!AtInjectBinding.hasAtInject(element)) continue block4;
                    throw new IllegalArgumentException("Unexpected @Inject annotation on " + element);
                }
            }
        }
        if (!hasInjectConstructor && requiredKeys.isEmpty() && mustHaveInjections) {
            throw new IllegalArgumentException("No injectable members on " + type.getQualifiedName().toString() + ". Do you want to add an injectable constructor?");
        }
        TypeMirror supertype = CodeGen.getApplicationSupertype(type);
        String string = supertype != null ? GeneratorKeys.rawMembersKey(supertype) : null;
        String provideKey = hasInjectConstructor || hasNoArgsConstructor && !requiredKeys.isEmpty() ? GeneratorKeys.get(type.asType()) : null;
        String membersKey = GeneratorKeys.rawMembersKey(type.asType());
        return new AtInjectBinding(provideKey, membersKey, type, requiredKeys, string);
    }

    private static boolean hasAtInject(Element enclosed) {
        return enclosed.getAnnotation(Inject.class) != null;
    }

    public void attach(Linker linker) {
        String requiredBy = this.type.getQualifiedName().toString();
        for (int i = 0; i < this.keys.size(); ++i) {
            this.bindings[i] = linker.requestBinding(this.keys.get(i), (Object)requiredBy);
        }
        if (this.supertypeKey != null) {
            this.supertypeBinding = linker.requestBinding(this.supertypeKey, (Object)requiredBy, false, true);
        }
    }

    public Object get() {
        throw new AssertionError((Object)"Compile-time binding should never be called to inject.");
    }

    public void injectMembers(Object t) {
        throw new AssertionError((Object)"Compile-time binding should never be called to inject.");
    }

    public void getDependencies(Set<Binding<?>> get, Set<Binding<?>> injectMembers) {
        Collections.addAll(get, this.bindings);
    }
}

