/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.Keys;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;

final class CodeGen {
    private static final AnnotationValueVisitor<Object, Void> VALUE_EXTRACTOR = new SimpleAnnotationValueVisitor6<Object, Void>(){

        @Override
        protected Object defaultAction(Object o, Void v) {
            return o;
        }

        @Override
        public Object visitArray(List<? extends AnnotationValue> values, Void v) {
            Object[] result = new Object[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                result[i] = values.get(i).accept(this, null);
            }
            return result;
        }
    };

    private CodeGen() {
    }

    public static PackageElement getPackage(Element type) {
        while (type.getKind() != ElementKind.PACKAGE) {
            type = type.getEnclosingElement();
        }
        return (PackageElement)type;
    }

    public static TypeMirror getApplicationSupertype(TypeElement type) {
        TypeMirror supertype = type.getSuperclass();
        return Keys.isPlatformType((String)((Object)supertype).toString()) ? null : supertype;
    }

    public static String adapterName(TypeElement typeElement, String suffix) {
        StringBuilder builder = new StringBuilder();
        CodeGen.rawTypeToString(builder, typeElement, '$');
        builder.append(suffix);
        return builder.toString();
    }

    public static String typeToString(TypeMirror type) {
        StringBuilder result = new StringBuilder();
        CodeGen.typeToString(type, result, '.');
        return result.toString();
    }

    public static String rawTypeToString(TypeMirror type, char innerClassSeparator) {
        if (!(type instanceof DeclaredType)) {
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
        StringBuilder result = new StringBuilder();
        DeclaredType declaredType = (DeclaredType)type;
        CodeGen.rawTypeToString(result, (TypeElement)declaredType.asElement(), innerClassSeparator);
        return result.toString();
    }

    public static void typeToString(final TypeMirror type, final StringBuilder result, final char innerClassSeparator) {
        type.accept(new SimpleTypeVisitor6<Void, Void>(){

            @Override
            public Void visitDeclared(DeclaredType declaredType, Void v) {
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                CodeGen.rawTypeToString(result, typeElement, innerClassSeparator);
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!typeArguments.isEmpty()) {
                    result.append("<");
                    for (int i = 0; i < typeArguments.size(); ++i) {
                        if (i != 0) {
                            result.append(", ");
                        }
                        CodeGen.typeToString(typeArguments.get(i), result, innerClassSeparator);
                    }
                    result.append(">");
                }
                return null;
            }

            @Override
            public Void visitPrimitive(PrimitiveType primitiveType, Void v) {
                result.append(CodeGen.box((PrimitiveType)type).getName());
                return null;
            }

            @Override
            public Void visitArray(ArrayType arrayType, Void v) {
                CodeGen.typeToString(arrayType.getComponentType(), result, innerClassSeparator);
                result.append("[]");
                return null;
            }

            @Override
            public Void visitTypeVariable(TypeVariable typeVariable, Void v) {
                result.append(typeVariable.asElement().getSimpleName());
                return null;
            }

            @Override
            protected Void defaultAction(TypeMirror typeMirror, Void v) {
                throw new UnsupportedOperationException("Unexpected TypeKind " + (Object)((Object)typeMirror.getKind()) + " for " + typeMirror);
            }
        }, null);
    }

    public static Map<String, Object> getAnnotation(Class<?> annotationType, Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!CodeGen.rawTypeToString(annotationMirror.getAnnotationType(), '$').equals(annotationType.getName())) continue;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Method m : annotationType.getMethods()) {
                result.put(m.getName(), m.getDefaultValue());
            }
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                String name = e.getKey().getSimpleName().toString();
                Object value = e.getValue().accept(VALUE_EXTRACTOR, null);
                Object defaultValue = result.get(name);
                if (!CodeGen.lenientIsInstance(defaultValue.getClass(), value)) {
                    throw new IllegalStateException(String.format("Value of %s.%s is a %s but expected a %s\n    value: %s", annotationType, name, value.getClass().getName(), defaultValue.getClass().getName(), value instanceof Object[] ? Arrays.toString((Object[])value) : value));
                }
                result.put(name, value);
            }
            return result;
        }
        return null;
    }

    private static boolean lenientIsInstance(Class<?> expectedClass, Object value) {
        if (expectedClass.isArray()) {
            Class<?> componentType = expectedClass.getComponentType();
            if (!(value instanceof Object[])) {
                return false;
            }
            for (Object element : (Object[])value) {
                if (CodeGen.lenientIsInstance(componentType, element)) continue;
                return false;
            }
            return true;
        }
        if (expectedClass == Class.class) {
            return value instanceof TypeMirror;
        }
        return expectedClass == value.getClass();
    }

    static void rawTypeToString(StringBuilder result, TypeElement type, char innerClassSeparator) {
        String packageName = CodeGen.getPackage(type).getQualifiedName().toString();
        String qualifiedName = type.getQualifiedName().toString();
        if (packageName.isEmpty()) {
            result.append(qualifiedName.replace('.', innerClassSeparator));
        } else {
            result.append(packageName);
            result.append('.');
            result.append(qualifiedName.substring(packageName.length() + 1).replace('.', innerClassSeparator));
        }
    }

    private static Class<?> box(PrimitiveType primitiveType) {
        switch (primitiveType.getKind()) {
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case CHAR: {
                return Character.class;
            }
            case VOID: {
                return Void.class;
            }
        }
        throw new AssertionError();
    }

    public static ExecutableElement getNoArgsConstructor(TypeElement type) {
        for (Element element : type.getEnclosedElements()) {
            ExecutableElement constructor;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !(constructor = (ExecutableElement)element).getParameters().isEmpty()) continue;
            return constructor;
        }
        return null;
    }

    public static boolean isCallableConstructor(ExecutableElement constructor) {
        if (constructor.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        TypeElement type = (TypeElement)constructor.getEnclosingElement();
        return type.getEnclosingElement().getKind() == ElementKind.PACKAGE || type.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static <T> Set<T> setOf(T ... items) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(Arrays.asList(items));
        return set;
    }

    public static String methodName(ExecutableElement method) {
        return ((TypeElement)method.getEnclosingElement()).getQualifiedName() + "." + method.getSimpleName() + "()";
    }

    public static boolean isInterface(TypeMirror typeMirror) {
        return typeMirror instanceof DeclaredType && ((DeclaredType)typeMirror).asElement().getKind() == ElementKind.INTERFACE;
    }

    static boolean isStatic(Element element) {
        for (Modifier modifier : element.getModifiers()) {
            if (!modifier.equals((Object)Modifier.STATIC)) continue;
            return true;
        }
        return false;
    }
}

