/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.CodeGen;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class GeneratorKeys {
    private static final String SET_PREFIX = Set.class.getCanonicalName() + "<";

    private GeneratorKeys() {
    }

    public static String rawMembersKey(TypeMirror type) {
        return "members/" + CodeGen.rawTypeToString(type, '$');
    }

    public static String get(TypeMirror type) {
        StringBuilder result = new StringBuilder();
        CodeGen.typeToString(type, result, '$');
        return result.toString();
    }

    public static String get(ExecutableElement method) {
        StringBuilder result = new StringBuilder();
        AnnotationMirror qualifier = GeneratorKeys.getQualifier(method.getAnnotationMirrors(), method);
        if (qualifier != null) {
            GeneratorKeys.qualifierToString(qualifier, result);
        }
        CodeGen.typeToString(method.getReturnType(), result, '$');
        return result.toString();
    }

    public static String getSetKey(ExecutableElement method) {
        StringBuilder result = new StringBuilder();
        AnnotationMirror qualifier = GeneratorKeys.getQualifier(method.getAnnotationMirrors(), method);
        if (qualifier != null) {
            GeneratorKeys.qualifierToString(qualifier, result);
        }
        result.append(SET_PREFIX);
        CodeGen.typeToString(method.getReturnType(), result, '$');
        result.append(">");
        return result.toString();
    }

    public static String get(VariableElement variable) {
        StringBuilder result = new StringBuilder();
        AnnotationMirror qualifier = GeneratorKeys.getQualifier(variable.getAnnotationMirrors(), variable);
        if (qualifier != null) {
            GeneratorKeys.qualifierToString(qualifier, result);
        }
        CodeGen.typeToString(variable.asType(), result, '$');
        return result.toString();
    }

    private static void qualifierToString(AnnotationMirror qualifier, StringBuilder result) {
        result.append('@');
        CodeGen.typeToString(qualifier.getAnnotationType(), result, '$');
        result.append('(');
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : qualifier.getElementValues().entrySet()) {
            result.append(entry.getKey().getSimpleName());
            result.append('=');
            result.append(entry.getValue().getValue());
        }
        result.append(")/");
    }

    private static AnnotationMirror getQualifier(List<? extends AnnotationMirror> annotations, Object member) {
        AnnotationMirror qualifier = null;
        for (AnnotationMirror annotationMirror : annotations) {
            if (annotationMirror.getAnnotationType().asElement().getAnnotation(Qualifier.class) == null) continue;
            if (qualifier != null) {
                throw new IllegalArgumentException("Too many qualifier annotations on " + member);
            }
            qualifier = annotationMirror;
        }
        return qualifier;
    }
}

