/*
 * Copyright (C) 2012 Square, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package dagger.internal.codegen;

/**
 * Utility class providing some commonly used boilerplate between {@code InjectAdapterProcessor}
 * and {@code ModuleAdapterProcessor}.
 */
public final class AdapterJavadocs {
  static final String GENERATED_BY_DAGGER = "Code generated by dagger-compiler.  Do not edit.";
  static final String MEMBERS_INJECT_METHOD = ""
      + "Injects any {@code @Inject} annotated fields in the given instance,\n"
      + "satisfying the contract for {@code Provider<%s>}.";
  static final String GET_METHOD = ""
      + "Returns the fully provisioned instance satisfying the contract for\n"
      + "{@code Provider<%s>}.";
  static final String GET_DEPENDENCIES_METHOD = ""
      + "Used internally obtain dependency information, such as for cyclical\n"
      + "graph detection.";
  static final String ATTACH_METHOD = ""
      + "Used internally to link bindings/providers together at run time\n"
      + "according to their dependency graph.";
  static final String STATIC_INJECT_METHOD = ""
      + "Performs the injections of dependencies into static fields when requested by\n"
      + "the {@code dagger.ObjectGraph}.";
  static final String MODULE_TYPE = ""
      + "A manager of modules and provides adapters allowing for proper linking and\n"
      + "instance provision of types served by {@code @Provides} methods.";
  static final String STATIC_INJECTION_TYPE = ""
      + "A manager for {@code %s}'s injections into static fields.";

  /** Creates an appropriate javadoc depending on aspects of the type in question. */
  static String binderTypeDocs(String type, boolean abstrakt, boolean members, boolean dependent) {
    StringBuffer sb = new StringBuffer();
    sb.append("A {@code Binder<").append(type).append(">} implementation which satisfies\n");
    sb.append("Dagger's infrastructure requirements including:");
    if (dependent) {
      sb.append("\n\n");
      sb.append("Owning the dependency links between {@code " + type + "} and its\n");
      sb.append("dependencies.");
    }
    if (!abstrakt) {
      sb.append("\n\n");
      sb.append("Being a {@code Provider<" + type + ">} and handling creation and\n");
      sb.append("preparation of object instances.");
    }
    if (members) {
      sb.append("\n\n");
      sb.append("Being a {@code MembersInjector<" + type + ">} and handling injection\n");
      sb.append("of annotated fields.");
    }
    return sb.toString();
  }

}
