/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.Binding;
import dagger.internal.codegen.GraphVizWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GraphVisualizer {
    private static final Pattern KEY_PATTERN = Pattern.compile("(?:@(?:[\\w$]+\\.)*([\\w$]+)(?:\\(.*\\))?/)?(?:members/)?(?:[\\w$]+\\.)*([\\w$]+)(\\<[^/]+\\>)?((\\[\\])*)");

    public void write(Map<String, Binding<?>> bindings, GraphVizWriter writer) throws IOException {
        Map<Binding<?>, String> namesIndex = this.buildNamesIndex(bindings);
        writer.beginGraph("concentrate", "true");
        for (Map.Entry<Binding<?>, String> entry : namesIndex.entrySet()) {
            Binding<?> sourceBinding = entry.getKey();
            String sourceName = entry.getValue();
            HashSet dependencies = new HashSet();
            sourceBinding.getDependencies(dependencies, dependencies);
            for (Binding targetBinding : dependencies) {
                String targetName = namesIndex.get(targetBinding);
                if (targetName == null) {
                    targetName = "Unbound:" + targetBinding.provideKey;
                }
                writer.edge(sourceName, targetName, new String[0]);
            }
        }
        writer.endGraph();
    }

    private Map<Binding<?>, String> buildNamesIndex(Map<String, Binding<?>> bindings) {
        String shortName;
        TreeMap shortNameToBinding = new TreeMap();
        HashSet collisions = new HashSet();
        for (Map.Entry<String, Binding<?>> entry : bindings.entrySet()) {
            String key = entry.getKey();
            Binding<?> binding = entry.getValue();
            shortName = this.shortName(key);
            Binding<?> collision = shortNameToBinding.put(shortName, binding);
            if (collision == null || collision == binding) continue;
            collisions.add(binding);
            collisions.add(collision);
        }
        for (Map.Entry<String, Binding<?>> entry : bindings.entrySet()) {
            Binding<?> binding = entry.getValue();
            if (!collisions.contains(binding)) continue;
            String key = entry.getKey();
            shortName = this.shortName(key);
            shortNameToBinding.remove(shortName);
            shortNameToBinding.put(key, binding);
        }
        LinkedHashMap bindingToName = new LinkedHashMap();
        for (Map.Entry entry : shortNameToBinding.entrySet()) {
            bindingToName.put((Binding<?>)entry.getValue(), (String)entry.getKey());
        }
        return bindingToName;
    }

    String shortName(String key) {
        String arrays;
        Matcher matcher = KEY_PATTERN.matcher(key);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected key: " + key);
        }
        StringBuilder result = new StringBuilder();
        String annotationSimpleName = matcher.group(1);
        if (annotationSimpleName != null) {
            result.append('@').append(annotationSimpleName).append(' ');
        }
        String simpleName = matcher.group(2);
        result.append(simpleName);
        String typeParameters = matcher.group(3);
        if (typeParameters != null) {
            result.append(typeParameters);
        }
        if ((arrays = matcher.group(4)) != null) {
            result.append(arrays);
        }
        return result.toString();
    }
}

