/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javawriter.JavaWriter;
import dagger.MembersInjector;
import dagger.internal.Binding;
import dagger.internal.Linker;
import dagger.internal.StaticInjection;
import dagger.internal.codegen.AdapterJavadocs;
import dagger.internal.codegen.GeneratorKeys;
import dagger.internal.codegen.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"javax.inject.Inject"})
public final class InjectAdapterProcessor
extends AbstractProcessor {
    private final Set<String> remainingTypeNames = new LinkedHashSet<String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> types, RoundEnvironment env) {
        this.remainingTypeNames.addAll(this.getInjectedClassNames(env));
        Iterator<String> i = this.remainingTypeNames.iterator();
        while (i.hasNext()) {
            InjectedClass injectedClass = this.getInjectedClass(i.next());
            boolean missingDependentClasses = !this.allTypesExist(injectedClass.fields) || injectedClass.constructor != null && !this.allTypesExist(injectedClass.constructor.getParameters()) || !this.allTypesExist(injectedClass.staticFields);
            if (missingDependentClasses) continue;
            try {
                this.writeInjectionsForClass(injectedClass);
            }
            catch (IOException e) {
                this.error("Code gen failed: " + e, injectedClass.type);
            }
            i.remove();
        }
        if (env.processingOver() && !this.remainingTypeNames.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not find injection type required by " + this.remainingTypeNames);
        }
        return false;
    }

    private void writeInjectionsForClass(InjectedClass injectedClass) throws IOException {
        if (injectedClass.constructor != null || !injectedClass.fields.isEmpty()) {
            this.writeInjectAdapter(injectedClass.type, injectedClass.constructor, injectedClass.fields);
        }
        if (!injectedClass.staticFields.isEmpty()) {
            this.writeStaticInjection(injectedClass.type, injectedClass.staticFields);
        }
    }

    private boolean allTypesExist(Collection<? extends Element> elements) {
        for (Element element : elements) {
            if (element.asType().getKind() != TypeKind.ERROR) continue;
            return false;
        }
        return true;
    }

    private Set<String> getInjectedClassNames(RoundEnvironment env) {
        LinkedHashSet<String> injectedTypeNames = new LinkedHashSet<String>();
        for (Element element : env.getElementsAnnotatedWith(Inject.class)) {
            if (!this.validateInjectable(element)) continue;
            injectedTypeNames.add(Util.rawTypeToString(element.getEnclosingElement().asType(), '.'));
        }
        return injectedTypeNames;
    }

    private boolean validateInjectable(Element injectable) {
        Element injectableType = injectable.getEnclosingElement();
        if (injectable.getKind() == ElementKind.CLASS) {
            this.error("@Inject is not valid on a class: " + Util.elementToString(injectable), injectable);
            return false;
        }
        if (injectable.getKind() == ElementKind.METHOD) {
            this.error("Method injection is not supported: " + Util.elementToString(injectable), injectable);
            return false;
        }
        if (injectable.getKind() == ElementKind.FIELD && injectable.getModifiers().contains((Object)Modifier.FINAL)) {
            this.error("Can't inject a final field: " + Util.elementToString(injectable), injectable);
            return false;
        }
        if (injectable.getKind() == ElementKind.FIELD && injectable.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error("Can't inject a private field: " + Util.elementToString(injectable), injectable);
            return false;
        }
        if (injectable.getKind() == ElementKind.CONSTRUCTOR && injectable.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error("Can't inject a private constructor: " + Util.elementToString(injectable), injectable);
            return false;
        }
        ElementKind elementKind = injectableType.getEnclosingElement().getKind();
        boolean isClassOrInterface = elementKind.isClass() || elementKind.isInterface();
        boolean isStatic = injectableType.getModifiers().contains((Object)Modifier.STATIC);
        if (isClassOrInterface && !isStatic) {
            this.error("Can't inject a non-static inner class: " + Util.elementToString(injectable), injectableType);
            return false;
        }
        return true;
    }

    private InjectedClass getInjectedClass(String injectedClassName) {
        TypeElement type = this.processingEnv.getElementUtils().getTypeElement(injectedClassName);
        boolean isAbstract = type.getModifiers().contains((Object)Modifier.ABSTRACT);
        ArrayList<Element> staticFields = new ArrayList<Element>();
        ExecutableElement constructor = null;
        ArrayList<Element> fields = new ArrayList<Element>();
        block4: for (Element element : type.getEnclosedElements()) {
            if (element.getAnnotation(Inject.class) == null) continue;
            switch (element.getKind()) {
                case FIELD: {
                    if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                        staticFields.add(element);
                        continue block4;
                    }
                    fields.add(element);
                    continue block4;
                }
                case CONSTRUCTOR: {
                    if (constructor != null) {
                        this.error("Too many injectable constructors on " + type.getQualifiedName(), element);
                    } else if (isAbstract) {
                        this.error("Abstract class " + type.getQualifiedName() + " must not have an @Inject-annotated constructor.", element);
                    }
                    constructor = (ExecutableElement)element;
                    continue block4;
                }
            }
            this.error("Cannot inject " + Util.elementToString(element), element);
        }
        if (constructor == null && !isAbstract && (constructor = Util.getNoArgsConstructor(type)) != null && !Util.isCallableConstructor(constructor)) {
            constructor = null;
        }
        return new InjectedClass(type, staticFields, constructor, fields);
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    private void writeInjectAdapter(TypeElement type, ExecutableElement constructor, List<Element> fields) throws IOException {
        String packageName = Util.getPackage(type).getQualifiedName().toString();
        String strippedTypeName = this.strippedTypeName(type.getQualifiedName().toString(), packageName);
        TypeMirror supertype = Util.getApplicationSupertype(type);
        String adapterName = Util.adapterName(type, "$$InjectAdapter");
        JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(adapterName, type);
        JavaWriter writer = new JavaWriter(sourceFile.openWriter());
        boolean isAbstract = type.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean injectMembers = !fields.isEmpty() || supertype != null;
        boolean disambiguateFields = !fields.isEmpty() && constructor != null && !constructor.getParameters().isEmpty();
        boolean dependent = injectMembers || constructor != null && !constructor.getParameters().isEmpty();
        writer.emitSingleLineComment("Code generated by dagger-compiler.  Do not edit.", new Object[0]);
        writer.emitPackage(packageName);
        writer.emitEmptyLine();
        writer.emitImports(this.getImports(dependent, injectMembers, constructor != null));
        writer.emitEmptyLine();
        writer.emitJavadoc(AdapterJavadocs.binderTypeDocs(strippedTypeName, isAbstract, injectMembers, dependent), new Object[0]);
        writer.beginType(adapterName, "class", 17, JavaWriter.type(Binding.class, (String[])new String[]{strippedTypeName}), this.interfaces(strippedTypeName, injectMembers, constructor != null));
        if (constructor != null) {
            for (VariableElement variableElement : constructor.getParameters()) {
                writer.emitField(JavaWriter.type(Binding.class, (String[])new String[]{Util.typeToString(variableElement.asType())}), this.parameterName(disambiguateFields, variableElement), 2);
            }
        }
        for (Element element : fields) {
            writer.emitField(JavaWriter.type(Binding.class, (String[])new String[]{Util.typeToString(element.asType())}), this.fieldName(disambiguateFields, element), 2);
        }
        if (supertype != null) {
            writer.emitField(JavaWriter.type(Binding.class, (String[])new String[]{Util.rawTypeToString(supertype, '.')}), "supertype", 2);
        }
        writer.emitEmptyLine();
        writer.beginMethod(null, adapterName, 1, new String[0]);
        String key = constructor != null ? JavaWriter.stringLiteral((String)GeneratorKeys.get(type.asType())) : null;
        String string = JavaWriter.stringLiteral((String)GeneratorKeys.rawMembersKey(type.asType()));
        boolean singleton = type.getAnnotation(Singleton.class) != null;
        writer.emitStatement("super(%s, %s, %s, %s.class)", new Object[]{key, string, singleton ? "IS_SINGLETON" : "NOT_SINGLETON", strippedTypeName});
        writer.endMethod();
        if (dependent) {
            writer.emitEmptyLine();
            writer.emitJavadoc("Used internally to link bindings/providers together at run time\naccording to their dependency graph.", new Object[0]);
            writer.emitAnnotation(Override.class);
            writer.emitAnnotation(SuppressWarnings.class, (Object)JavaWriter.stringLiteral((String)"unchecked"));
            writer.beginMethod("void", "attach", 1, new String[]{Linker.class.getCanonicalName(), "linker"});
            if (constructor != null) {
                for (VariableElement variableElement : constructor.getParameters()) {
                    writer.emitStatement("%s = (%s) linker.requestBinding(%s, %s.class, getClass().getClassLoader())", new Object[]{this.parameterName(disambiguateFields, variableElement), writer.compressType(JavaWriter.type(Binding.class, (String[])new String[]{Util.typeToString(variableElement.asType())})), JavaWriter.stringLiteral((String)GeneratorKeys.get(variableElement)), strippedTypeName});
                }
            }
            for (Element element : fields) {
                writer.emitStatement("%s = (%s) linker.requestBinding(%s, %s.class, getClass().getClassLoader())", new Object[]{this.fieldName(disambiguateFields, element), writer.compressType(JavaWriter.type(Binding.class, (String[])new String[]{Util.typeToString(element.asType())})), JavaWriter.stringLiteral((String)GeneratorKeys.get((VariableElement)element)), strippedTypeName});
            }
            if (supertype != null) {
                writer.emitStatement("%s = (%s) linker.requestBinding(%s, %s.class, getClass().getClassLoader(), false, true)", new Object[]{"supertype", writer.compressType(JavaWriter.type(Binding.class, (String[])new String[]{Util.rawTypeToString(supertype, '.')})), JavaWriter.stringLiteral((String)GeneratorKeys.rawMembersKey(supertype)), strippedTypeName});
            }
            writer.endMethod();
            writer.emitEmptyLine();
            writer.emitJavadoc("Used internally obtain dependency information, such as for cyclical\ngraph detection.", new Object[0]);
            writer.emitAnnotation(Override.class);
            String setOfBindings = JavaWriter.type(Set.class, (String[])new String[]{"Binding<?>"});
            writer.beginMethod("void", "getDependencies", 1, new String[]{setOfBindings, "getBindings", setOfBindings, "injectMembersBindings"});
            if (constructor != null) {
                for (Element element : constructor.getParameters()) {
                    writer.emitStatement("getBindings.add(%s)", new Object[]{this.parameterName(disambiguateFields, element)});
                }
            }
            for (Element element : fields) {
                writer.emitStatement("injectMembersBindings.add(%s)", new Object[]{this.fieldName(disambiguateFields, element)});
            }
            if (supertype != null) {
                writer.emitStatement("injectMembersBindings.add(%s)", new Object[]{"supertype"});
            }
            writer.endMethod();
        }
        if (constructor != null) {
            writer.emitEmptyLine();
            writer.emitJavadoc("Returns the fully provisioned instance satisfying the contract for\n{@code Provider<%s>}.", new Object[]{strippedTypeName});
            writer.emitAnnotation(Override.class);
            writer.beginMethod(strippedTypeName, "get", 1, new String[0]);
            StringBuilder newInstance = new StringBuilder();
            newInstance.append(strippedTypeName).append(" result = new ");
            newInstance.append(strippedTypeName).append('(');
            boolean bl = true;
            for (VariableElement variableElement : constructor.getParameters()) {
                boolean bl2;
                if (!bl2) {
                    newInstance.append(", ");
                } else {
                    bl2 = false;
                }
                newInstance.append(this.parameterName(disambiguateFields, variableElement)).append(".get()");
            }
            newInstance.append(')');
            writer.emitStatement(newInstance.toString(), new Object[0]);
            if (injectMembers) {
                writer.emitStatement("injectMembers(result)", new Object[0]);
            }
            writer.emitStatement("return result", new Object[0]);
            writer.endMethod();
        }
        if (injectMembers) {
            writer.emitEmptyLine();
            writer.emitJavadoc("Injects any {@code @Inject} annotated fields in the given instance,\nsatisfying the contract for {@code Provider<%s>}.", new Object[]{strippedTypeName});
            writer.emitAnnotation(Override.class);
            writer.beginMethod("void", "injectMembers", 1, new String[]{strippedTypeName, "object"});
            for (Element element : fields) {
                writer.emitStatement("object.%s = %s.get()", new Object[]{element.getSimpleName(), this.fieldName(disambiguateFields, element)});
            }
            if (supertype != null) {
                writer.emitStatement("supertype.injectMembers(object)", new Object[0]);
            }
            writer.endMethod();
        }
        writer.endType();
        writer.close();
    }

    private String[] interfaces(String strippedTypeName, boolean hasFields, boolean isProvider) {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (isProvider) {
            interfaces.add(JavaWriter.type(Provider.class, (String[])new String[]{strippedTypeName}));
        }
        if (hasFields) {
            interfaces.add(JavaWriter.type(MembersInjector.class, (String[])new String[]{strippedTypeName}));
        }
        return interfaces.toArray(new String[interfaces.size()]);
    }

    private Set<String> getImports(boolean dependent, boolean injectMembers, boolean isProvider) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        imports.add(Binding.class.getCanonicalName());
        if (dependent) {
            imports.add(Linker.class.getCanonicalName());
            imports.add(Set.class.getCanonicalName());
        }
        if (injectMembers) {
            imports.add(MembersInjector.class.getCanonicalName());
        }
        if (isProvider) {
            imports.add(Provider.class.getCanonicalName());
        }
        return imports;
    }

    private String strippedTypeName(String type, String packageName) {
        return type.substring(packageName.isEmpty() ? 0 : packageName.length() + 1);
    }

    private void writeStaticInjection(TypeElement type, List<Element> fields) throws IOException {
        String typeName = type.getQualifiedName().toString();
        String adapterName = Util.adapterName(type, "$$StaticInjection");
        JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(adapterName, type);
        JavaWriter writer = new JavaWriter(sourceFile.openWriter());
        writer.emitSingleLineComment("Code generated by dagger-compiler.  Do not edit.", new Object[0]);
        writer.emitPackage(Util.getPackage(type).getQualifiedName().toString());
        writer.emitEmptyLine();
        writer.emitImports(Arrays.asList(StaticInjection.class.getName(), Binding.class.getName(), Linker.class.getName()));
        writer.emitEmptyLine();
        writer.emitJavadoc("A manager for {@code %s}'s injections into static fields.", new Object[]{type.getSimpleName()});
        writer.beginType(adapterName, "class", 17, StaticInjection.class.getSimpleName(), new String[0]);
        for (Element field : fields) {
            writer.emitField(JavaWriter.type(Binding.class, (String[])new String[]{Util.typeToString(field.asType())}), this.fieldName(false, field), 2);
        }
        writer.emitEmptyLine();
        writer.emitJavadoc("Used internally to link bindings/providers together at run time\naccording to their dependency graph.", new Object[0]);
        writer.emitAnnotation(Override.class);
        writer.beginMethod("void", "attach", 1, new String[]{Linker.class.getName(), "linker"});
        for (Element field : fields) {
            writer.emitStatement("%s = (%s) linker.requestBinding(%s, %s.class, getClass().getClassLoader())", new Object[]{this.fieldName(false, field), writer.compressType(JavaWriter.type(Binding.class, (String[])new String[]{Util.typeToString(field.asType())})), JavaWriter.stringLiteral((String)GeneratorKeys.get((VariableElement)field)), typeName});
        }
        writer.endMethod();
        writer.emitEmptyLine();
        writer.emitJavadoc("Performs the injections of dependencies into static fields when requested by\nthe {@code dagger.ObjectGraph}.", new Object[0]);
        writer.emitAnnotation(Override.class);
        writer.beginMethod("void", "inject", 1, new String[0]);
        for (Element field : fields) {
            writer.emitStatement("%s.%s = %s.get()", new Object[]{writer.compressType(typeName), field.getSimpleName().toString(), this.fieldName(false, field)});
        }
        writer.endMethod();
        writer.endType();
        writer.close();
    }

    private String fieldName(boolean disambiguateFields, Element field) {
        return (disambiguateFields ? "field_" : "") + field.getSimpleName().toString();
    }

    private String parameterName(boolean disambiguateFields, Element parameter) {
        return (disambiguateFields ? "parameter_" : "") + parameter.getSimpleName().toString();
    }

    static class InjectedClass {
        final TypeElement type;
        final List<Element> staticFields;
        final ExecutableElement constructor;
        final List<Element> fields;

        InjectedClass(TypeElement type, List<Element> staticFields, ExecutableElement constructor, List<Element> fields) {
            this.type = type;
            this.staticFields = staticFields;
            this.constructor = constructor;
            this.fields = fields;
        }
    }
}

