/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"*"})
public final class ValidationProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> types, RoundEnvironment env) {
        ArrayList<Element> allElements = new ArrayList<Element>();
        LinkedHashMap<Element, Element> parametersToTheirMethods = new LinkedHashMap<Element, Element>();
        this.getAllElements(env, allElements, parametersToTheirMethods);
        for (Element element : allElements) {
            this.validateProvides(element);
            this.validateScoping(element);
            this.validateQualifiers(element, parametersToTheirMethods);
        }
        return false;
    }

    private void validateProvides(Element element) {
        if (element.getAnnotation(Provides.class) != null && element.getEnclosingElement().getAnnotation(Module.class) == null) {
            this.error("@Provides methods must be declared in modules: " + Util.elementToString(element), element);
        }
    }

    private void validateQualifiers(Element element, Map<Element, Element> parametersToTheirMethods) {
        boolean suppressWarnings = element.getAnnotation(SuppressWarnings.class) != null && Arrays.asList(element.getAnnotation(SuppressWarnings.class).value()).contains("qualifiers");
        int numberOfQualifiersOnElement = 0;
        block5: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (annotationMirror.getAnnotationType().asElement().getAnnotation(Qualifier.class) == null) continue;
            switch (element.getKind()) {
                case FIELD: {
                    ++numberOfQualifiersOnElement;
                    if (element.getAnnotation(Inject.class) != null || suppressWarnings) continue block5;
                    this.warning("Dagger will ignore qualifier annotations on fields that are not annotated with @Inject: " + Util.elementToString(element), element);
                    continue block5;
                }
                case METHOD: {
                    ++numberOfQualifiersOnElement;
                    if (this.isProvidesMethod(element) || suppressWarnings) continue block5;
                    this.warning("Dagger will ignore qualifier annotations on methods that are not @Provides methods: " + Util.elementToString(element), element);
                    continue block5;
                }
                case PARAMETER: {
                    ++numberOfQualifiersOnElement;
                    if (this.isInjectableConstructorParameter(element, parametersToTheirMethods) || this.isProvidesMethodParameter(element, parametersToTheirMethods) || suppressWarnings) continue block5;
                    this.warning("Dagger will ignore qualifier annotations on parameters that are not @Inject constructor parameters or @Provides method parameters: " + Util.elementToString(element), element);
                    continue block5;
                }
            }
            this.error("Qualifier annotations are only allowed on fields, methods, and parameters: " + Util.elementToString(element), element);
        }
        if (numberOfQualifiersOnElement > 1) {
            this.error("Only one qualifier annotation is allowed per element: " + Util.elementToString(element), element);
        }
    }

    private void validateScoping(Element element) {
        boolean suppressWarnings = element.getAnnotation(SuppressWarnings.class) != null && Arrays.asList(element.getAnnotation(SuppressWarnings.class).value()).contains("scoping");
        int numberOfScopingAnnotationsOnElement = 0;
        block4: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (annotationMirror.getAnnotationType().asElement().getAnnotation(Scope.class) == null) continue;
            switch (element.getKind()) {
                case METHOD: {
                    ++numberOfScopingAnnotationsOnElement;
                    if (this.isProvidesMethod(element) || suppressWarnings) continue block4;
                    this.warning("Dagger will ignore scoping annotations on methods that are not @Provides methods: " + Util.elementToString(element), element);
                    continue block4;
                }
                case CLASS: {
                    if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) break;
                    ++numberOfScopingAnnotationsOnElement;
                    continue block4;
                }
            }
            this.error("Scoping annotations are only allowed on concrete types and @Provides methods: " + Util.elementToString(element), element);
        }
        if (numberOfScopingAnnotationsOnElement > 1) {
            this.error("Only one scoping annotation is allowed per element: " + Util.elementToString(element), element);
        }
    }

    private void getAllElements(RoundEnvironment env, List<Element> result, Map<Element, Element> parametersToTheirMethods) {
        for (Element element : env.getRootElements()) {
            this.addAllEnclosed(element, result, parametersToTheirMethods);
        }
    }

    private void addAllEnclosed(Element element, List<Element> result, Map<Element, Element> parametersToTheirMethods) {
        result.add(element);
        for (Element element2 : element.getEnclosedElements()) {
            this.addAllEnclosed(element2, result, parametersToTheirMethods);
            if (element2.getKind() != ElementKind.METHOD && element2.getKind() != ElementKind.CONSTRUCTOR) continue;
            for (Element element3 : ((ExecutableElement)element2).getParameters()) {
                result.add(element3);
                parametersToTheirMethods.put(element3, element2);
            }
        }
    }

    private boolean isProvidesMethod(Element element) {
        return element.getKind() == ElementKind.METHOD && element.getAnnotation(Provides.class) != null;
    }

    private boolean isProvidesMethodParameter(Element parameter, Map<Element, Element> parametersToTheirMethods) {
        return parametersToTheirMethods.get(parameter).getAnnotation(Provides.class) != null;
    }

    private boolean isInjectableConstructorParameter(Element parameter, Map<Element, Element> parametersToTheirMethods) {
        return parametersToTheirMethods.get(parameter).getKind() == ElementKind.CONSTRUCTOR && parametersToTheirMethods.get(parameter).getAnnotation(Inject.class) != null;
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    private void warning(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, element);
    }
}

