/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.Module;
import dagger.Provides;
import dagger.internal.Binding;
import dagger.internal.Linker;
import dagger.internal.Loader;
import dagger.internal.ProblemDetector;
import dagger.internal.SetBinding;
import dagger.internal.codegen.GeneratorKeys;
import dagger.internal.codegen.GraphAnalysisErrorHandler;
import dagger.internal.codegen.GraphAnalysisLoader;
import dagger.internal.codegen.GraphAnalysisStaticInjection;
import dagger.internal.codegen.GraphVisualizer;
import dagger.internal.codegen.GraphVizWriter;
import dagger.internal.codegen.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"dagger.Module"})
public final class GraphAnalysisProcessor
extends AbstractProcessor {
    private static final Set<String> ERROR_NAMES_TO_PROPAGATE = new LinkedHashSet<String>(Arrays.asList("com.sun.tools.javac.code.Symbol$CompletionFailure"));
    private final Set<String> delayedModuleNames = new LinkedHashSet<String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> types, RoundEnvironment env) {
        if (!env.processingOver()) {
            for (Element element : env.getElementsAnnotatedWith(Module.class)) {
                if (!(element instanceof TypeElement)) {
                    this.error("@Module applies to a type, " + element.getSimpleName() + " is a " + (Object)((Object)element.getKind()), element);
                    continue;
                }
                this.delayedModuleNames.add(((TypeElement)element).getQualifiedName().toString());
            }
            return false;
        }
        LinkedHashSet<TypeElement> modules = new LinkedHashSet<TypeElement>();
        for (String string : this.delayedModuleNames) {
            modules.add(this.elements().getTypeElement(string));
        }
        for (Element element : modules) {
            Map<String, Binding<?>> bindings;
            Map<String, Object> annotation = null;
            try {
                annotation = Util.getAnnotation(Module.class, element);
            }
            catch (Util.CodeGenerationIncompleteException e) {
                continue;
            }
            TypeElement moduleType = (TypeElement)element;
            if (annotation == null) {
                this.error("Missing @Module annotation.", moduleType);
                continue;
            }
            if (annotation.get("complete").equals(Boolean.TRUE)) {
                try {
                    bindings = this.processCompleteModule(moduleType, false);
                    new ProblemDetector().detectCircularDependencies(bindings.values());
                }
                catch (ModuleValidationException e) {
                    this.error("Graph validation failed: " + e.getMessage(), e.source);
                    continue;
                }
                catch (Binding.InvalidBindingException e) {
                    this.error("Graph validation failed: " + e.getMessage(), this.elements().getTypeElement(e.type));
                    continue;
                }
                catch (RuntimeException e) {
                    if (ERROR_NAMES_TO_PROPAGATE.contains(e.getClass().getName())) {
                        throw e;
                    }
                    this.error("Unknown error " + e.getClass().getName() + " thrown by javac in graph validation: " + e.getMessage(), moduleType);
                    continue;
                }
                try {
                    this.writeDotFile(moduleType, bindings);
                }
                catch (IOException e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Graph visualization failed. Please report this as a bug.\n\n" + sw, moduleType);
                }
            }
            if (!annotation.get("library").equals(Boolean.FALSE)) continue;
            bindings = this.processCompleteModule(moduleType, true);
            try {
                new ProblemDetector().detectUnusedBinding(bindings.values());
            }
            catch (IllegalStateException e) {
                this.error("Graph validation failed: " + e.getMessage(), moduleType);
            }
        }
        return false;
    }

    private void error(String message, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private Map<String, Binding<?>> processCompleteModule(TypeElement rootModule, boolean ignoreCompletenessErrors) {
        Linker linker;
        LinkedHashMap<String, TypeElement> allModules = new LinkedHashMap<String, TypeElement>();
        this.collectIncludesRecursively(rootModule, allModules, new LinkedList<String>());
        ArrayList<GraphAnalysisStaticInjection> staticInjections = new ArrayList<GraphAnalysisStaticInjection>();
        Linker.ErrorHandler errorHandler = ignoreCompletenessErrors ? Linker.ErrorHandler.NULL : new GraphAnalysisErrorHandler(this.processingEnv, rootModule.getQualifiedName().toString());
        Linker linker2 = linker = new Linker(null, (Loader)new GraphAnalysisLoader(this.processingEnv), errorHandler);
        synchronized (linker2) {
            LinkedHashMap baseBindings = new LinkedHashMap();
            LinkedHashMap<String, ProviderMethodBinding> overrideBindings = new LinkedHashMap<String, ProviderMethodBinding>();
            for (TypeElement module : allModules.values()) {
                Map<String, Object> annotation = Util.getAnnotation(Module.class, module);
                boolean overrides = (Boolean)annotation.get("overrides");
                boolean library = (Boolean)annotation.get("library");
                LinkedHashMap<String, ProviderMethodBinding> addTo = overrides ? overrideBindings : baseBindings;
                LinkedHashSet<String> injectsProvisionKeys = new LinkedHashSet<String>();
                for (Object injectableTypeObject : (Object[])annotation.get("injects")) {
                    TypeMirror injectableType = (TypeMirror)injectableTypeObject;
                    String providerKey = GeneratorKeys.get(injectableType);
                    injectsProvisionKeys.add(providerKey);
                    String key = Util.isInterface(injectableType) ? providerKey : GeneratorKeys.rawMembersKey(injectableType);
                    linker.requestBinding(key, (Object)module.getQualifiedName().toString(), this.getClass().getClassLoader(), false, true);
                }
                for (Object staticInjection : (Object[])annotation.get("staticInjections")) {
                    TypeMirror staticInjectionTypeMirror = (TypeMirror)staticInjection;
                    Element element = this.processingEnv.getTypeUtils().asElement(staticInjectionTypeMirror);
                    staticInjections.add(new GraphAnalysisStaticInjection(element));
                }
                block11: for (Element enclosed : module.getEnclosedElements()) {
                    Provides provides = enclosed.getAnnotation(Provides.class);
                    if (provides == null) continue;
                    ExecutableElement providerMethod = (ExecutableElement)enclosed;
                    String key = GeneratorKeys.get(providerMethod);
                    ProviderMethodBinding binding = new ProviderMethodBinding(key, providerMethod, library);
                    Binding previous = (Binding)addTo.get(key);
                    if (previous != null && (provides.type() != Provides.Type.SET && provides.type() != Provides.Type.SET_VALUES || !(previous instanceof SetBinding))) {
                        String message = "Duplicate bindings for " + key;
                        if (overrides) {
                            message = message + " in override module(s) - cannot override an override";
                        }
                        message = message + ":\n    " + previous.requiredBy + "\n    " + binding.requiredBy;
                        this.error(message, providerMethod);
                    }
                    switch (provides.type()) {
                        case UNIQUE: {
                            if (injectsProvisionKeys.contains(binding.provideKey)) {
                                binding.setDependedOn(true);
                            }
                            addTo.put(key, binding);
                            continue block11;
                        }
                        case SET: {
                            String setKey = GeneratorKeys.getSetKey(providerMethod);
                            SetBinding.add(addTo, (String)setKey, (Binding)binding);
                            continue block11;
                        }
                        case SET_VALUES: {
                            SetBinding.add(addTo, (String)key, (Binding)binding);
                            continue block11;
                        }
                    }
                    throw new AssertionError((Object)("Unknown @Provides type " + provides.type()));
                }
            }
            linker.installBindings(baseBindings);
            linker.installBindings(overrideBindings);
            for (GraphAnalysisStaticInjection staticInjection : staticInjections) {
                staticInjection.attach(linker);
            }
            return linker.linkAll();
        }
    }

    private Elements elements() {
        return this.processingEnv.getElementUtils();
    }

    private String shortMethodName(ExecutableElement method) {
        return method.getEnclosingElement().getSimpleName().toString() + "." + method.getSimpleName() + "()";
    }

    /*
     * WARNING - void declaration
     */
    void collectIncludesRecursively(TypeElement module, Map<String, TypeElement> result, Deque<String> path) {
        Map<String, Object> annotation = Util.getAnnotation(Module.class, module);
        if (annotation == null) {
            throw new ModuleValidationException("No @Module on " + module, module);
        }
        String name = module.getQualifiedName().toString();
        if (path.contains(name)) {
            StringBuilder message = new StringBuilder("Module Inclusion Cycle: ");
            if (path.size() == 1) {
                message.append(name).append(" includes itself directly.");
            } else {
                String current = null;
                String includer = name;
                boolean bl = false;
                while (path.size() > 0) {
                    void var9_13;
                    current = includer;
                    includer = path.pop();
                    message.append("\n").append((int)var9_13).append(". ").append(current).append(" included by ").append(includer);
                    ++var9_13;
                }
                message.append("\n0. ").append(name);
            }
            throw new ModuleValidationException(message.toString(), module);
        }
        result.put(name, module);
        Types types = this.processingEnv.getTypeUtils();
        ArrayList<Object> seedModules = new ArrayList<Object>();
        seedModules.addAll(Arrays.asList((Object[])annotation.get("includes")));
        if (!annotation.get("addsTo").equals(Void.class)) {
            seedModules.add(annotation.get("addsTo"));
        }
        for (Object e : seedModules) {
            if (!(e instanceof TypeMirror)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unexpected value for include: " + e + " in " + module, module);
                continue;
            }
            TypeElement includedModule = (TypeElement)types.asElement((TypeMirror)e);
            path.push(name);
            this.collectIncludesRecursively(includedModule, result, path);
            path.pop();
        }
    }

    void writeDotFile(TypeElement module, Map<String, Binding<?>> bindings) throws IOException {
        StandardLocation location = StandardLocation.SOURCE_OUTPUT;
        String path = Util.getPackage(module).getQualifiedName().toString();
        String file = module.getQualifiedName().toString().substring(path.length() + 1) + ".dot";
        FileObject resource = this.processingEnv.getFiler().createResource(location, path, file, module);
        Writer writer = resource.openWriter();
        GraphVizWriter dotWriter = new GraphVizWriter(writer);
        new GraphVisualizer().write(bindings, dotWriter);
        dotWriter.close();
    }

    static class ModuleValidationException
    extends IllegalStateException {
        final TypeElement source;

        public ModuleValidationException(String message, TypeElement source) {
            super(message);
            this.source = source;
        }
    }

    static class ProviderMethodBinding
    extends Binding<Object> {
        private final ExecutableElement method;
        private final Binding<?>[] parameters;

        protected ProviderMethodBinding(String provideKey, ExecutableElement method, boolean library) {
            super(provideKey, null, method.getAnnotation(Singleton.class) != null, (Object)Util.methodName(method));
            this.method = method;
            this.parameters = new Binding[method.getParameters().size()];
            this.setLibrary(library);
        }

        public void attach(Linker linker) {
            for (int i = 0; i < this.method.getParameters().size(); ++i) {
                VariableElement parameter = this.method.getParameters().get(i);
                String parameterKey = GeneratorKeys.get(parameter);
                this.parameters[i] = linker.requestBinding(parameterKey, (Object)this.method.toString(), ((Object)((Object)this)).getClass().getClassLoader());
            }
        }

        public Object get() {
            throw new AssertionError((Object)"Compile-time binding should never be called to inject.");
        }

        public void injectMembers(Object t) {
            throw new AssertionError((Object)"Compile-time binding should never be called to inject.");
        }

        public void getDependencies(Set<Binding<?>> get, Set<Binding<?>> injectMembers) {
            Collections.addAll(get, this.parameters);
        }
    }
}

