/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javawriter.JavaWriter;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import dagger.internal.Binding;
import dagger.internal.Linker;
import dagger.internal.ModuleAdapter;
import dagger.internal.SetBinding;
import dagger.internal.codegen.AdapterJavadocs;
import dagger.internal.codegen.GeneratorKeys;
import dagger.internal.codegen.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"*"})
public final class ModuleAdapterProcessor
extends AbstractProcessor {
    private static final String BINDINGS_MAP = JavaWriter.type(Map.class, (String[])new String[]{String.class.getCanonicalName(), Binding.class.getCanonicalName() + "<?>"});
    private static final List<String> INVALID_RETURN_TYPES = Arrays.asList(Provider.class.getCanonicalName(), Lazy.class.getCanonicalName());
    private final LinkedHashMap<String, List<ExecutableElement>> remainingTypes = new LinkedHashMap();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> types, RoundEnvironment env) {
        this.remainingTypes.putAll(this.providerMethodsByClass(env));
        Iterator<String> i = this.remainingTypes.keySet().iterator();
        while (i.hasNext()) {
            String typeName = i.next();
            TypeElement type = this.processingEnv.getElementUtils().getTypeElement(typeName);
            List<ExecutableElement> providesTypes = this.remainingTypes.get(typeName);
            try {
                Map<String, Object> parsedAnnotation = Util.getAnnotation(Module.class, type);
                StringWriter stringWriter = new StringWriter();
                String adapterName = Util.adapterName(type, "$$ModuleAdapter");
                this.generateModuleAdapter(stringWriter, adapterName, type, parsedAnnotation, providesTypes);
                JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(adapterName, type);
                Writer sourceWriter = sourceFile.openWriter();
                sourceWriter.append(stringWriter.getBuffer());
                sourceWriter.close();
            }
            catch (Util.CodeGenerationIncompleteException e) {
                continue;
            }
            catch (IOException e) {
                this.error("Code gen failed: " + e, type);
            }
            i.remove();
        }
        if (env.processingOver() && this.remainingTypes.size() > 0) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not find types required by provides methods for " + this.remainingTypes.keySet());
        }
        return false;
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    private Map<String, List<ExecutableElement>> providerMethodsByClass(RoundEnvironment env) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        HashMap<String, List<ExecutableElement>> result = new HashMap<String, List<ExecutableElement>>();
        block3: for (Element element : this.findProvidesMethods(env)) {
            ArrayList<ExecutableElement> methods;
            switch (element.getEnclosingElement().getKind()) {
                case CLASS: {
                    break;
                }
                default: {
                    this.error("Unexpected @Provides on " + Util.elementToString(element), element);
                    continue block3;
                }
            }
            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
            Set<Modifier> typeModifiers = typeElement.getModifiers();
            if (typeModifiers.contains((Object)Modifier.PRIVATE) || typeModifiers.contains((Object)Modifier.ABSTRACT)) {
                this.error("Classes declaring @Provides methods must not be private or abstract: " + typeElement.getQualifiedName(), typeElement);
                continue;
            }
            Set<Modifier> methodModifiers = element.getModifiers();
            if (methodModifiers.contains((Object)Modifier.PRIVATE) || methodModifiers.contains((Object)Modifier.ABSTRACT) || methodModifiers.contains((Object)Modifier.STATIC)) {
                this.error("@Provides methods must not be private, abstract or static: " + typeElement.getQualifiedName() + "." + element, element);
                continue;
            }
            ExecutableElement providerMethodAsExecutable = (ExecutableElement)element;
            if (!providerMethodAsExecutable.getThrownTypes().isEmpty()) {
                this.error("@Provides methods must not have a throws clause: " + typeElement.getQualifiedName() + "." + element, element);
                continue;
            }
            TypeMirror returnType = types.erasure(providerMethodAsExecutable.getReturnType());
            if (!returnType.getKind().equals((Object)TypeKind.ERROR)) {
                for (String invalidTypeName : INVALID_RETURN_TYPES) {
                    TypeElement invalidTypeElement = elementUtils.getTypeElement(invalidTypeName);
                    if (invalidTypeElement == null || !types.isSameType(returnType, types.erasure(invalidTypeElement.asType()))) continue;
                    this.error(String.format("@Provides method must not return %s directly: %s.%s", invalidTypeElement, typeElement.getQualifiedName(), element), element);
                    continue block3;
                }
            }
            if ((methods = (ArrayList<ExecutableElement>)result.get(typeElement.getQualifiedName().toString())) == null) {
                methods = new ArrayList<ExecutableElement>();
                result.put(typeElement.getQualifiedName().toString(), methods);
            }
            methods.add(providerMethodAsExecutable);
        }
        TypeMirror objectType = elementUtils.getTypeElement("java.lang.Object").asType();
        for (Element element : env.getElementsAnnotatedWith(Module.class)) {
            String moduleName;
            if (!element.getKind().equals((Object)ElementKind.CLASS)) {
                this.error("Modules must be classes: " + Util.elementToString(element), element);
                continue;
            }
            TypeElement moduleType = (TypeElement)element;
            if (!moduleType.getSuperclass().equals(objectType)) {
                this.error("Modules must not extend from other classes: " + Util.elementToString(element), element);
            }
            if (result.containsKey(moduleName = moduleType.getQualifiedName().toString())) continue;
            result.put(moduleName, new ArrayList());
        }
        return result;
    }

    private Set<? extends Element> findProvidesMethods(RoundEnvironment env) {
        LinkedHashSet<? extends Element> result = new LinkedHashSet<Element>();
        result.addAll(env.getElementsAnnotatedWith(Provides.class));
        return result;
    }

    private void generateModuleAdapter(Writer ioWriter, String adapterName, TypeElement type, Map<String, Object> module, List<ExecutableElement> providerMethods) throws IOException {
        if (module == null) {
            this.error(type + " has @Provides methods but no @Module annotation", type);
            return;
        }
        Object[] staticInjections = (Object[])module.get("staticInjections");
        Object[] injects = (Object[])module.get("injects");
        Object[] includes = (Object[])module.get("includes");
        boolean overrides = (Boolean)module.get("overrides");
        boolean complete = (Boolean)module.get("complete");
        boolean library = (Boolean)module.get("library");
        JavaWriter writer = new JavaWriter(ioWriter);
        boolean multibindings = this.checkForMultibindings(providerMethods);
        boolean providerMethodDependencies = this.checkForDependencies(providerMethods);
        writer.emitSingleLineComment("Code generated by dagger-compiler.  Do not edit.", new Object[0]);
        writer.emitPackage(Util.getPackage(type).getQualifiedName().toString());
        writer.emitImports(this.findImports(multibindings, !providerMethods.isEmpty(), providerMethodDependencies));
        String typeName = type.getQualifiedName().toString();
        writer.emitEmptyLine();
        writer.emitJavadoc("A manager of modules and provides adapters allowing for proper linking and\ninstance provision of types served by {@code @Provides} methods.", new Object[0]);
        writer.beginType(adapterName, "class", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL), JavaWriter.type(ModuleAdapter.class, (String[])new String[]{typeName}), new String[0]);
        StringBuilder injectsField = new StringBuilder().append("{ ");
        for (Object injectableType : injects) {
            TypeMirror typeMirror = (TypeMirror)injectableType;
            String key = Util.isInterface(typeMirror) ? GeneratorKeys.get(typeMirror) : GeneratorKeys.rawMembersKey(typeMirror);
            injectsField.append(JavaWriter.stringLiteral((String)key)).append(", ");
        }
        injectsField.append("}");
        writer.emitField("String[]", "INJECTS", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), injectsField.toString());
        StringBuilder staticInjectionsField = new StringBuilder().append("{ ");
        for (Object staticInjection : staticInjections) {
            TypeMirror typeMirror = (TypeMirror)staticInjection;
            staticInjectionsField.append(Util.typeToString(typeMirror)).append(".class, ");
        }
        staticInjectionsField.append("}");
        writer.emitField("Class<?>[]", "STATIC_INJECTIONS", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), staticInjectionsField.toString());
        StringBuilder includesField = new StringBuilder().append("{ ");
        for (Object include : includes) {
            if (!(include instanceof TypeMirror)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unexpected value: " + include + " in includes of " + type, type);
                continue;
            }
            TypeMirror typeMirror = (TypeMirror)include;
            includesField.append(Util.typeToString(typeMirror)).append(".class, ");
        }
        includesField.append("}");
        writer.emitField("Class<?>[]", "INCLUDES", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), includesField.toString());
        writer.emitEmptyLine();
        writer.beginMethod(null, adapterName, EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.emitStatement("super(%s.class, INJECTS, STATIC_INJECTIONS, %s /*overrides*/, INCLUDES, %s /*complete*/, %s /*library*/)", new Object[]{typeName, overrides, complete, library});
        writer.endMethod();
        ExecutableElement noArgsConstructor = Util.getNoArgsConstructor(type);
        if (noArgsConstructor != null && Util.isCallableConstructor(noArgsConstructor)) {
            writer.emitEmptyLine();
            writer.emitAnnotation(Override.class);
            writer.beginMethod(typeName, "newModule", EnumSet.of(Modifier.PUBLIC), new String[0]);
            writer.emitStatement("return new %s()", new Object[]{typeName});
            writer.endMethod();
        }
        LinkedHashMap<ExecutableElement, String> methodToClassName = new LinkedHashMap<ExecutableElement, String>();
        LinkedHashMap<String, AtomicInteger> methodNameToNextId = new LinkedHashMap<String, AtomicInteger>();
        if (!providerMethods.isEmpty()) {
            writer.emitEmptyLine();
            writer.emitJavadoc("Used internally obtain dependency information, such as for cyclical\ngraph detection.", new Object[0]);
            writer.emitAnnotation(Override.class);
            writer.beginMethod("void", "getBindings", EnumSet.of(Modifier.PUBLIC), new String[]{BINDINGS_MAP, "map", typeName, "module"});
            block8: for (ExecutableElement providerMethod : providerMethods) {
                Provides provides = providerMethod.getAnnotation(Provides.class);
                switch (provides.type()) {
                    case UNIQUE: {
                        String key = GeneratorKeys.get(providerMethod);
                        writer.emitStatement("map.put(%s, new %s(module))", new Object[]{JavaWriter.stringLiteral((String)key), this.bindingClassName(providerMethod, methodToClassName, methodNameToNextId)});
                        continue block8;
                    }
                    case SET: {
                        String key = GeneratorKeys.getSetKey(providerMethod);
                        writer.emitStatement("SetBinding.add(map, %s, new %s(module))", new Object[]{JavaWriter.stringLiteral((String)key), this.bindingClassName(providerMethod, methodToClassName, methodNameToNextId)});
                        continue block8;
                    }
                    case SET_VALUES: {
                        String key = GeneratorKeys.get(providerMethod);
                        writer.emitStatement("SetBinding.add(map, %s, new %s(module))", new Object[]{JavaWriter.stringLiteral((String)key), this.bindingClassName(providerMethod, methodToClassName, methodNameToNextId)});
                        continue block8;
                    }
                }
                throw new AssertionError((Object)("Unknown @Provides type " + provides.type()));
            }
            writer.endMethod();
        }
        for (ExecutableElement providerMethod : providerMethods) {
            this.generateProvidesAdapter(writer, providerMethod, methodToClassName, methodNameToNextId, library);
        }
        writer.endType();
        writer.close();
    }

    private Set<String> findImports(boolean multibindings, boolean providers, boolean dependencies) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        imports.add(ModuleAdapter.class.getCanonicalName());
        if (providers) {
            imports.add(Binding.class.getCanonicalName());
            imports.add(Map.class.getCanonicalName());
            imports.add(Provider.class.getCanonicalName());
        }
        if (dependencies) {
            imports.add(Linker.class.getCanonicalName());
            imports.add(Set.class.getCanonicalName());
        }
        if (multibindings) {
            imports.add(SetBinding.class.getCanonicalName());
        }
        return imports;
    }

    private boolean checkForDependencies(List<ExecutableElement> providerMethods) {
        for (ExecutableElement element : providerMethods) {
            if (element.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean checkForMultibindings(List<ExecutableElement> providerMethods) {
        for (ExecutableElement element : providerMethods) {
            Provides.Type providesType = element.getAnnotation(Provides.class).type();
            if (providesType != Provides.Type.SET && providesType != Provides.Type.SET_VALUES) continue;
            return true;
        }
        return false;
    }

    private String bindingClassName(ExecutableElement providerMethod, Map<ExecutableElement, String> methodToClassName, Map<String, AtomicInteger> methodNameToNextId) {
        String className = methodToClassName.get(providerMethod);
        if (className != null) {
            return className;
        }
        String methodName = providerMethod.getSimpleName().toString();
        String suffix = "";
        AtomicInteger id = methodNameToNextId.get(methodName);
        if (id == null) {
            methodNameToNextId.put(methodName, new AtomicInteger(2));
        } else {
            suffix = id.toString();
            id.incrementAndGet();
        }
        String uppercaseMethodName = Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        className = uppercaseMethodName + "ProvidesAdapter" + suffix;
        methodToClassName.put(providerMethod, className);
        return className;
    }

    private void generateProvidesAdapter(JavaWriter writer, ExecutableElement providerMethod, Map<ExecutableElement, String> methodToClassName, Map<String, AtomicInteger> methodNameToNextId, boolean library) throws IOException {
        String methodName = providerMethod.getSimpleName().toString();
        String moduleType = Util.typeToString(providerMethod.getEnclosingElement().asType());
        String className = this.bindingClassName(providerMethod, methodToClassName, methodNameToNextId);
        String returnType = Util.typeToString(providerMethod.getReturnType());
        List<? extends VariableElement> parameters = providerMethod.getParameters();
        boolean dependent = !parameters.isEmpty();
        writer.emitEmptyLine();
        writer.emitJavadoc(AdapterJavadocs.bindingTypeDocs(returnType, false, false, dependent), new Object[0]);
        writer.beginType(className, "class", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), JavaWriter.type(Binding.class, (String[])new String[]{returnType}), new String[]{JavaWriter.type(Provider.class, (String[])new String[]{returnType})});
        writer.emitField(moduleType, "module", EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
        for (Element element : parameters) {
            TypeMirror parameterType = element.asType();
            writer.emitField(JavaWriter.type(Binding.class, (String[])new String[]{Util.typeToString(parameterType)}), this.parameterName(element), EnumSet.of(Modifier.PRIVATE));
        }
        writer.emitEmptyLine();
        writer.beginMethod(null, className, EnumSet.of(Modifier.PUBLIC), new String[]{moduleType, "module"});
        boolean singleton = providerMethod.getAnnotation(Singleton.class) != null;
        String string = JavaWriter.stringLiteral((String)GeneratorKeys.get(providerMethod));
        Object membersKey = null;
        writer.emitStatement("super(%s, %s, %s, %s)", new Object[]{string, membersKey, singleton ? "IS_SINGLETON" : "NOT_SINGLETON", JavaWriter.stringLiteral((String)(moduleType + "." + methodName + "()"))});
        writer.emitStatement("this.module = module", new Object[0]);
        writer.emitStatement("setLibrary(%s)", new Object[]{library});
        writer.endMethod();
        if (dependent) {
            writer.emitEmptyLine();
            writer.emitJavadoc("Used internally to link bindings/providers together at run time\naccording to their dependency graph.", new Object[0]);
            writer.emitAnnotation(Override.class);
            writer.emitAnnotation(SuppressWarnings.class, (Object)JavaWriter.stringLiteral((String)"unchecked"));
            writer.beginMethod("void", "attach", EnumSet.of(Modifier.PUBLIC), new String[]{Linker.class.getCanonicalName(), "linker"});
            for (VariableElement variableElement : parameters) {
                String string2 = GeneratorKeys.get(variableElement);
                writer.emitStatement("%s = (%s) linker.requestBinding(%s, %s.class, getClass().getClassLoader())", new Object[]{this.parameterName(variableElement), writer.compressType(JavaWriter.type(Binding.class, (String[])new String[]{Util.typeToString(variableElement.asType())})), JavaWriter.stringLiteral((String)string2), writer.compressType(moduleType)});
            }
            writer.endMethod();
            writer.emitEmptyLine();
            writer.emitJavadoc("Used internally obtain dependency information, such as for cyclical\ngraph detection.", new Object[0]);
            writer.emitAnnotation(Override.class);
            String setOfBindings = JavaWriter.type(Set.class, (String[])new String[]{"Binding<?>"});
            writer.beginMethod("void", "getDependencies", EnumSet.of(Modifier.PUBLIC), new String[]{setOfBindings, "getBindings", setOfBindings, "injectMembersBindings"});
            for (Element element : parameters) {
                writer.emitStatement("getBindings.add(%s)", new Object[]{this.parameterName(element)});
            }
            writer.endMethod();
        }
        writer.emitEmptyLine();
        writer.emitJavadoc("Returns the fully provisioned instance satisfying the contract for\n{@code Provider<%s>}.", new Object[]{returnType});
        writer.emitAnnotation(Override.class);
        writer.beginMethod(returnType, "get", EnumSet.of(Modifier.PUBLIC), new String[0]);
        StringBuilder args = new StringBuilder();
        boolean bl = true;
        for (Element element : parameters) {
            boolean bl2;
            if (!bl2) {
                args.append(", ");
            } else {
                bl2 = false;
            }
            args.append(String.format("%s.get()", this.parameterName(element)));
        }
        writer.emitStatement("return module.%s(%s)", new Object[]{methodName, args.toString()});
        writer.endMethod();
        writer.endType();
    }

    private String parameterName(Element parameter) {
        if (parameter.getSimpleName().contentEquals("module")) {
            return "parameter_" + parameter.getSimpleName().toString();
        }
        return parameter.getSimpleName().toString();
    }
}

