/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Binding;
import dagger.internal.Linker;
import dagger.internal.codegen.AdapterJavadocs;
import dagger.internal.codegen.GeneratorKeys;
import dagger.internal.codegen.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"javax.inject.Inject"})
public final class InjectAdapterProcessor
extends AbstractProcessor {
    private final Set<String> remainingTypeNames = new LinkedHashSet<String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> types, RoundEnvironment env) {
        this.remainingTypeNames.addAll(this.findInjectedClassNames(env));
        Iterator<String> i = this.remainingTypeNames.iterator();
        while (i.hasNext()) {
            InjectedClass injectedClass = this.createInjectedClass(i.next());
            boolean missingDependentClasses = !this.allTypesExist(injectedClass.fields) || injectedClass.constructor != null && !this.allTypesExist(injectedClass.constructor.getParameters());
            if (missingDependentClasses) continue;
            try {
                this.generateInjectionsForClass(injectedClass);
            }
            catch (IOException e) {
                this.error("Code gen failed: " + e, injectedClass.type);
            }
            i.remove();
        }
        if (env.processingOver() && !this.remainingTypeNames.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not find injection type required by " + this.remainingTypeNames);
        }
        return false;
    }

    private void generateInjectionsForClass(InjectedClass injectedClass) throws IOException {
        if (injectedClass.constructor != null || !injectedClass.fields.isEmpty()) {
            this.generateInjectAdapter(injectedClass.type, injectedClass.constructor, injectedClass.fields);
        }
    }

    private boolean allTypesExist(Collection<? extends Element> elements) {
        for (Element element : elements) {
            if (element.asType().getKind() != TypeKind.ERROR) continue;
            return false;
        }
        return true;
    }

    private Set<String> findInjectedClassNames(RoundEnvironment env) {
        LinkedHashSet<String> injectedTypeNames = new LinkedHashSet<String>();
        for (Element element : env.getElementsAnnotatedWith(Inject.class)) {
            if (!this.validateInjectable(element)) continue;
            injectedTypeNames.add(Util.rawTypeToString(element.getEnclosingElement().asType(), '.'));
        }
        return injectedTypeNames;
    }

    private boolean validateInjectable(Element injectable) {
        Element injectableType = injectable.getEnclosingElement();
        if (injectable.getKind() == ElementKind.CLASS) {
            this.error("@Inject is not valid on a class: " + Util.elementToString(injectable), injectable);
            return false;
        }
        if (injectable.getKind() == ElementKind.METHOD) {
            this.error("Method injection is not supported: " + Util.elementToString(injectable), injectable);
            return false;
        }
        if (injectable.getKind() == ElementKind.FIELD && injectable.getModifiers().contains((Object)Modifier.FINAL)) {
            this.error("Can't inject a final field: " + Util.elementToString(injectable), injectable);
            return false;
        }
        if (injectable.getKind() == ElementKind.FIELD && injectable.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error("Can't inject a private field: " + Util.elementToString(injectable), injectable);
            return false;
        }
        if (injectable.getKind() == ElementKind.CONSTRUCTOR && injectable.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error("Can't inject a private constructor: " + Util.elementToString(injectable), injectable);
            return false;
        }
        ElementKind elementKind = injectableType.getEnclosingElement().getKind();
        boolean isClassOrInterface = elementKind.isClass() || elementKind.isInterface();
        boolean isStatic = injectableType.getModifiers().contains((Object)Modifier.STATIC);
        if (isClassOrInterface && !isStatic) {
            this.error("Can't inject a non-static inner class: " + Util.elementToString(injectable), injectableType);
            return false;
        }
        return true;
    }

    private InjectedClass createInjectedClass(String injectedClassName) {
        TypeElement type = this.processingEnv.getElementUtils().getTypeElement(injectedClassName);
        boolean isAbstract = type.getModifiers().contains((Object)Modifier.ABSTRACT);
        ExecutableElement constructor = null;
        ArrayList<Element> fields = new ArrayList<Element>();
        block4: for (Element element : type.getEnclosedElements()) {
            if (element.getAnnotation(Inject.class) == null) continue;
            switch (element.getKind()) {
                case FIELD: {
                    if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                        this.error("@Inject not supported on static field " + type.getQualifiedName(), element);
                        continue block4;
                    }
                    fields.add(element);
                    continue block4;
                }
                case CONSTRUCTOR: {
                    if (constructor != null) {
                        this.error("Too many injectable constructors on " + type.getQualifiedName(), element);
                    } else if (isAbstract) {
                        this.error("Abstract class " + type.getQualifiedName() + " must not have an @Inject-annotated constructor.", element);
                    }
                    constructor = (ExecutableElement)element;
                    continue block4;
                }
            }
            this.error("Cannot inject " + Util.elementToString(element), element);
        }
        if (constructor == null && !isAbstract && (constructor = Util.getNoArgsConstructor(type)) != null && !Util.isCallableConstructor(constructor)) {
            constructor = null;
        }
        return new InjectedClass(type, constructor, fields);
    }

    private void generateInjectAdapter(TypeElement type, ExecutableElement constructor, List<Element> fields) throws IOException {
        String packageName = Util.getPackage(type).getQualifiedName().toString();
        TypeMirror supertype = Util.getApplicationSupertype(type);
        ClassName injectedClassName = ClassName.get((TypeElement)type);
        ClassName adapterClassName = Util.adapterName(injectedClassName, "$$InjectAdapter");
        boolean isAbstract = type.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean injectMembers = !fields.isEmpty() || supertype != null;
        boolean disambiguateFields = !fields.isEmpty() && constructor != null && !constructor.getParameters().isEmpty();
        boolean dependent = injectMembers || constructor != null && !constructor.getParameters().isEmpty();
        TypeSpec.Builder result = TypeSpec.classBuilder((String)adapterClassName.simpleName()).addOriginatingElement((Element)type).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Binding.class), (TypeName[])new TypeName[]{injectedClassName})).addJavadoc("$L", new Object[]{AdapterJavadocs.bindingTypeDocs(Util.injectableType(type.asType()), isAbstract, injectMembers, dependent).toString()});
        for (Element element : fields) {
            result.addField(this.memberBindingField(disambiguateFields, element));
        }
        if (constructor != null) {
            for (VariableElement variableElement : constructor.getParameters()) {
                result.addField(this.parameterBindingField(disambiguateFields, variableElement));
            }
        }
        if (supertype != null) {
            result.addField(this.supertypeBindingField(supertype));
        }
        result.addMethod(this.writeInjectAdapterConstructor(constructor, type, injectedClassName));
        if (dependent) {
            result.addMethod(this.attachMethod(constructor, fields, disambiguateFields, injectedClassName, supertype, true));
            result.addMethod(this.getDependenciesMethod(constructor, fields, disambiguateFields, supertype, true));
        }
        if (constructor != null) {
            result.addMethod(this.getMethod(constructor, disambiguateFields, injectMembers, injectedClassName));
        }
        if (injectMembers) {
            result.addMethod(this.membersInjectMethod(fields, disambiguateFields, injectedClassName, supertype));
        }
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)result.build()).addFileComment("Code generated by dagger-compiler.  Do not edit.", new Object[0]).build();
        javaFile.writeTo(this.processingEnv.getFiler());
    }

    private FieldSpec memberBindingField(boolean disambiguateFields, Element field) {
        return FieldSpec.builder((TypeName)Util.bindingOf(field.asType()), (String)this.fieldName(disambiguateFields, field), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private FieldSpec parameterBindingField(boolean disambiguateFields, VariableElement parameter) {
        return FieldSpec.builder((TypeName)Util.bindingOf(parameter.asType()), (String)this.parameterName(disambiguateFields, parameter), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private FieldSpec supertypeBindingField(TypeMirror supertype) {
        return FieldSpec.builder((TypeName)Util.bindingOf(supertype), (String)"supertype", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec writeInjectAdapterConstructor(ExecutableElement constructor, TypeElement type, ClassName strippedTypeName) {
        String key = constructor != null ? GeneratorKeys.get(type.asType()) : null;
        String membersKey = GeneratorKeys.rawMembersKey(type.asType());
        boolean singleton = type.getAnnotation(Singleton.class) != null;
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($S, $S, $N, $T.class)", new Object[]{key, membersKey, singleton ? "IS_SINGLETON" : "NOT_SINGLETON", strippedTypeName}).build();
    }

    private MethodSpec attachMethod(ExecutableElement constructor, List<Element> fields, boolean disambiguateFields, ClassName typeName, TypeMirror supertype, boolean extendsBinding) throws IOException {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"attach").addJavadoc("Used internally to link bindings/providers together at run time\naccording to their dependency graph.\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Linker.class, "linker", new Modifier[0]);
        if (extendsBinding) {
            result.addAnnotation(Override.class);
        }
        result.addAnnotation(Util.UNCHECKED);
        if (constructor != null) {
            for (VariableElement variableElement : constructor.getParameters()) {
                result.addStatement("$N = ($T) linker.requestBinding($S, $T.class, getClass().getClassLoader())", new Object[]{this.parameterName(disambiguateFields, variableElement), Util.bindingOf(variableElement.asType()), GeneratorKeys.get(variableElement), typeName});
            }
        }
        for (Element element : fields) {
            result.addStatement("$N = ($T) linker.requestBinding($S, $T.class, getClass().getClassLoader())", new Object[]{this.fieldName(disambiguateFields, element), Util.bindingOf(element.asType()), GeneratorKeys.get((VariableElement)element), typeName});
        }
        if (supertype != null) {
            result.addStatement("$N = ($T) linker.requestBinding($S, $T.class, getClass().getClassLoader(), false, true)", new Object[]{"supertype", Util.bindingOf(supertype), GeneratorKeys.rawMembersKey(supertype), typeName});
        }
        return result.build();
    }

    private MethodSpec getDependenciesMethod(ExecutableElement constructor, List<Element> fields, boolean disambiguateFields, TypeMirror supertype, boolean extendsBinding) throws IOException {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"getDependencies").addJavadoc("Used internally obtain dependency information, such as for cyclical\ngraph detection.\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Util.SET_OF_BINDINGS, "getBindings", new Modifier[0]).addParameter(Util.SET_OF_BINDINGS, "injectMembersBindings", new Modifier[0]);
        if (extendsBinding) {
            result.addAnnotation(Override.class);
        }
        if (constructor != null) {
            for (Element element : constructor.getParameters()) {
                result.addStatement("getBindings.add($N)", new Object[]{this.parameterName(disambiguateFields, element)});
            }
        }
        for (Element element : fields) {
            result.addStatement("injectMembersBindings.add($N)", new Object[]{this.fieldName(disambiguateFields, element)});
        }
        if (supertype != null) {
            result.addStatement("injectMembersBindings.add($N)", new Object[]{"supertype"});
        }
        return result.build();
    }

    private MethodSpec getMethod(ExecutableElement constructor, boolean disambiguateFields, boolean injectMembers, ClassName injectedClassName) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"get").addJavadoc("Returns the fully provisioned instance satisfying the contract for\n{@code Provider<$T>}.\n", new Object[]{injectedClassName}).addAnnotation(Override.class).returns((TypeName)injectedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        result.addCode("$T result = new $T(", new Object[]{injectedClassName, injectedClassName});
        boolean first = true;
        for (VariableElement variableElement : constructor.getParameters()) {
            if (!first) {
                result.addCode(", ", new Object[0]);
            } else {
                first = false;
            }
            result.addCode("$N.get()", new Object[]{this.parameterName(disambiguateFields, variableElement)});
        }
        result.addCode(");\n", new Object[0]);
        if (injectMembers) {
            result.addStatement("injectMembers(result)", new Object[0]);
        }
        result.addStatement("return result", new Object[0]);
        return result.build();
    }

    private MethodSpec membersInjectMethod(List<Element> fields, boolean disambiguateFields, ClassName injectedClassName, TypeMirror supertype) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"injectMembers").addJavadoc("Injects any {@code @Inject} annotated fields in the given instance,\nsatisfying the contract for {@code Provider<$T>}.\n", new Object[]{injectedClassName}).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)injectedClassName, "object", new Modifier[0]);
        for (Element field : fields) {
            result.addStatement("object.$N = $N.get()", new Object[]{field.getSimpleName(), this.fieldName(disambiguateFields, field)});
        }
        if (supertype != null) {
            result.addStatement("supertype.injectMembers(object)", new Object[0]);
        }
        return result.build();
    }

    private String fieldName(boolean disambiguateFields, Element field) {
        return (disambiguateFields ? "field_" : "") + field.getSimpleName().toString();
    }

    private String parameterName(boolean disambiguateFields, Element parameter) {
        return (disambiguateFields ? "parameter_" : "") + parameter.getSimpleName().toString();
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    static class InjectedClass {
        final TypeElement type;
        final ExecutableElement constructor;
        final List<Element> fields;

        InjectedClass(TypeElement type, ExecutableElement constructor, List<Element> fields) {
            this.type = type;
            this.constructor = constructor;
            this.fields = fields;
        }
    }
}

