/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.app;

import android.app.Notification;
import android.app.PendingIntent;
import android.graphics.Bitmap;
import java.util.ArrayList;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.LongAssert;
import org.fest.assertions.api.android.Utils;

public class NotificationAssert
extends AbstractAssert<NotificationAssert, Notification> {
    public NotificationAssert(Notification actual) {
        super((Object)actual, NotificationAssert.class);
    }

    public NotificationAssert hasContentIntent(PendingIntent intent) {
        this.isNotNull();
        Assertions.assertThat((Object)((Notification)this.actual).contentIntent).isEqualTo((Object)intent);
        return this;
    }

    public NotificationAssert hasDefaults(int defaults) {
        this.isNotNull();
        int actualDefaults = ((Notification)this.actual).defaults;
        ((IntegerAssert)Assertions.assertThat((int)actualDefaults).overridingErrorMessage("Expected defaults <%s> but was <%s>.", new Object[]{defaults, actualDefaults})).isEqualTo(defaults);
        return this;
    }

    public NotificationAssert hasDeleteIntent(PendingIntent intent) {
        this.isNotNull();
        Assertions.assertThat((Object)((Notification)this.actual).deleteIntent).isEqualTo((Object)intent);
        return this;
    }

    public NotificationAssert hasFlags(int flags) {
        this.isNotNull();
        int actualFlags = ((Notification)this.actual).flags;
        ((IntegerAssert)Assertions.assertThat((int)actualFlags).overridingErrorMessage("Expected flags <%s> but was <%s>.", new Object[]{NotificationAssert.flagsToString(flags), NotificationAssert.flagsToString(actualFlags)})).isEqualTo(flags);
        return this;
    }

    public NotificationAssert hasFullScreenIntent(PendingIntent intent) {
        this.isNotNull();
        Assertions.assertThat((Object)((Notification)this.actual).fullScreenIntent).isEqualTo((Object)intent);
        return this;
    }

    public NotificationAssert hasIcon(int resId) {
        this.isNotNull();
        int actualId = ((Notification)this.actual).icon;
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected icon with ID <%s> but was <%s>.", new Object[]{resId, actualId})).isEqualTo(resId);
        return this;
    }

    public NotificationAssert hasIconLevel(int level) {
        this.isNotNull();
        int actualLevel = ((Notification)this.actual).iconLevel;
        ((IntegerAssert)Assertions.assertThat((int)actualLevel).overridingErrorMessage("Expected icon level <%s> but was <%s>.", new Object[]{level, actualLevel})).isEqualTo(level);
        return this;
    }

    public NotificationAssert hasLargeIcon(Bitmap bitmap) {
        this.isNotNull();
        Assertions.assertThat((Object)((Notification)this.actual).largeIcon).isEqualTo((Object)bitmap);
        return this;
    }

    public NotificationAssert hasLedColor(int color) {
        this.isNotNull();
        int actualColor = ((Notification)this.actual).ledARGB;
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected LED color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    public NotificationAssert hasLedOffMs(int length) {
        this.isNotNull();
        int actualLength = ((Notification)this.actual).ledOffMS;
        ((IntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected LED off time (ms) <%s> but was <%s>.", new Object[]{length, actualLength})).isEqualTo(length);
        return this;
    }

    public NotificationAssert hasLedOnMs(int length) {
        this.isNotNull();
        int actualLength = ((Notification)this.actual).ledOnMS;
        ((IntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected LED on time (ms) <%s> but was <%s>.", new Object[]{length, actualLength})).isEqualTo(length);
        return this;
    }

    public NotificationAssert hasNumber(int number) {
        this.isNotNull();
        int actualNumber = ((Notification)this.actual).number;
        ((IntegerAssert)Assertions.assertThat((int)actualNumber).overridingErrorMessage("Expected number <%s> but was <%s>.", new Object[]{number, actualNumber})).isEqualTo(number);
        return this;
    }

    public NotificationAssert hasPriority(int priority) {
        this.isNotNull();
        int actualPriority = ((Notification)this.actual).priority;
        ((IntegerAssert)Assertions.assertThat((int)actualPriority).overridingErrorMessage("Expected priority <%s> but was <%s>.", new Object[]{NotificationAssert.priorityToString(priority), NotificationAssert.priorityToString(actualPriority)})).isEqualTo(priority);
        return this;
    }

    public NotificationAssert hasTickerText(CharSequence text) {
        this.isNotNull();
        Assertions.assertThat((Object)((Notification)this.actual).tickerText).isEqualTo((Object)text);
        return this;
    }

    public NotificationAssert hasVibration(long[] vibration) {
        this.isNotNull();
        Assertions.assertThat((long[])((Notification)this.actual).vibrate).isEqualTo((Object)vibration);
        return this;
    }

    public NotificationAssert hasWhen(long when) {
        this.isNotNull();
        long actualWhen = ((Notification)this.actual).when;
        ((LongAssert)Assertions.assertThat((long)actualWhen).overridingErrorMessage("Expected when <%s> but was <%s>.", new Object[]{when, actualWhen})).isEqualTo(when);
        return this;
    }

    private static String flagsToString(int flags) {
        if (flags == 0) {
            return "none";
        }
        ArrayList<String> parts = new ArrayList<String>();
        if ((flags & 0x10) != 0) {
            parts.add("autoCancel");
        }
        if ((flags & 0x40) != 0) {
            parts.add("foregroundService");
        }
        if ((flags & 4) != 0) {
            parts.add("insistent");
        }
        if ((flags & 0x20) != 0) {
            parts.add("noClear");
        }
        if ((flags & 2) != 0) {
            parts.add("ongoingEvent");
        }
        if ((flags & 8) != 0) {
            parts.add("onlyAlertOnce");
        }
        if ((flags & 1) != 0) {
            parts.add("showLights");
        }
        if ((flags & 0x80) != 0) {
            parts.add("highPriority");
        }
        return Utils.join(parts);
    }

    private static String priorityToString(int priority) {
        switch (priority) {
            case -2: {
                return "min";
            }
            case -1: {
                return "low";
            }
            case 0: {
                return "default";
            }
            case 1: {
                return "high";
            }
            case 2: {
                return "max";
            }
        }
        throw new IllegalArgumentException("Unknown priority: " + priority);
    }
}

