/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.database;

import android.database.Cursor;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;

public abstract class AbstractCursorAssert<S extends AbstractCursorAssert<S, A>, A extends Cursor>
extends AbstractAssert<S, A> {
    public AbstractCursorAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasColumnCount(int count) {
        this.isNotNull();
        int actualCount = ((Cursor)this.actual).getColumnCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected column count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S hasCount(int count) {
        this.isNotNull();
        int actualCount = ((Cursor)this.actual).getCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S hasPosition(int position) {
        this.isNotNull();
        int actualPosition = ((Cursor)this.actual).getPosition();
        ((IntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isAfterLast() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isAfterLast()).overridingErrorMessage("Expected to be after last but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotAfterLast() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isAfterLast()).overridingErrorMessage("Expected to not be after last but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isBeforeFirst() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isBeforeFirst()).overridingErrorMessage("Expected to be before first but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotBeforeFrist() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isBeforeFirst()).overridingErrorMessage("Expected to not be before first but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isClosed() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isClosed()).overridingErrorMessage("Expected to be closed but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotClosed() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isClosed()).overridingErrorMessage("Expected to not be closed but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isFirst() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isFirst()).overridingErrorMessage("Expected to be at first but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotFirst() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isFirst()).overridingErrorMessage("Expected to not be at first but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isLast() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isLast()).overridingErrorMessage("Expected to be at last but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }

    public S isNotLast() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Cursor)this.actual).isLast()).overridingErrorMessage("Expected to not be at last but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractCursorAssert)this.myself));
    }
}

