/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics.drawable;

import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.graphics.drawable.AbstractDrawableAssert;

public class BitmapDrawableAssert
extends AbstractDrawableAssert<BitmapDrawableAssert, BitmapDrawable> {
    public BitmapDrawableAssert(BitmapDrawable actual) {
        super(actual, BitmapDrawableAssert.class);
    }

    public BitmapDrawableAssert hasGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((BitmapDrawable)this.actual).getGravity();
        ((IntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(gravity);
        return this;
    }

    public BitmapDrawableAssert hasTileModeX(Shader.TileMode mode) {
        this.isNotNull();
        Shader.TileMode actualMode = ((BitmapDrawable)this.actual).getTileModeX();
        ((ObjectAssert)Assertions.assertThat((Object)actualMode).overridingErrorMessage("Expected X tile mode <%s> but was <%s>", new Object[]{mode, actualMode})).isEqualTo((Object)mode);
        return this;
    }

    public BitmapDrawableAssert hasTileModeY(Shader.TileMode mode) {
        this.isNotNull();
        Shader.TileMode actualMode = ((BitmapDrawable)this.actual).getTileModeY();
        ((ObjectAssert)Assertions.assertThat((Object)actualMode).overridingErrorMessage("Expected Y tile mode <%s> but was <%s>", new Object[]{mode, actualMode})).isEqualTo((Object)mode);
        return this;
    }
}

