/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.support.v4.util;

import android.support.v4.util.LruCache;
import java.util.Map;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.MapAssert;

public class LruCacheAssert
extends AbstractAssert<LruCacheAssert, LruCache> {
    public LruCacheAssert(LruCache actual) {
        super((Object)actual, LruCacheAssert.class);
    }

    public LruCacheAssert hasEntry(Object entry) {
        this.isNotNull();
        MapAssert a = Assertions.assertThat((Map)((LruCache)this.actual).snapshot());
        a.overridingErrorMessage("Expected to contain entry with key <%s> but did not.", new Object[0]);
        a.containsKey(entry);
        return this;
    }

    public LruCacheAssert hasCreateCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).createCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected create count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert hasEvictionCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).evictionCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected eviction count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert hasHitCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).hitCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected hit count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert hasMaxSize(int size) {
        this.isNotNull();
        int actualSize = ((LruCache)this.actual).maxSize();
        ((IntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected max size <%s> but was <%s>.", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }

    public LruCacheAssert hasMissCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).missCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected miss count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert hasPutCount(int count) {
        this.isNotNull();
        int actualCount = ((LruCache)this.actual).putCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected put count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public LruCacheAssert hasSize(int size) {
        this.isNotNull();
        int actualSize = ((LruCache)this.actual).size();
        ((IntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected size <%s> but was <%s>.", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }
}

