/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.graphics.Point;
import android.view.Display;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;

public class DisplayAssert
extends AbstractAssert<DisplayAssert, Display> {
    public DisplayAssert(Display actual) {
        super((Object)actual, DisplayAssert.class);
    }

    public DisplayAssert hasDisplayId(int id) {
        this.isNotNull();
        int actualId = ((Display)this.actual).getDisplayId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(actualId);
        return this;
    }

    public DisplayAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Display)this.actual).getHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public DisplayAssert hasOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((Display)this.actual).getOrientation();
        ((IntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>", new Object[]{orientation, actualOrientation})).isEqualTo(orientation);
        return this;
    }

    public DisplayAssert hasPixelFormat(int format) {
        this.isNotNull();
        int actualFormat = ((Display)this.actual).getPixelFormat();
        ((IntegerAssert)Assertions.assertThat((int)actualFormat).overridingErrorMessage("Expected pixel format <%s> but was <%s>", new Object[]{format, actualFormat})).isEqualTo(format);
        return this;
    }

    public DisplayAssert hasRefreshRate(float rate) {
        this.isNotNull();
        float actualRate = ((Display)this.actual).getRefreshRate();
        ((FloatAssert)Assertions.assertThat((float)actualRate).overridingErrorMessage("Expected refresh rate <%s> but was <%s>", new Object[]{Float.valueOf(rate), Float.valueOf(actualRate)})).isEqualTo(rate);
        return this;
    }

    public DisplayAssert hasRotation(int rotation) {
        this.isNotNull();
        int actualRotation = ((Display)this.actual).getRotation();
        ((IntegerAssert)Assertions.assertThat((int)actualRotation).overridingErrorMessage("Expected rotation <%s> but was <%s>", new Object[]{rotation, actualRotation})).isEqualTo(rotation);
        return this;
    }

    public DisplayAssert hasSize(int width, int height) {
        this.isNotNull();
        Point actualSize = new Point();
        ((Display)this.actual).getSize(actualSize);
        ((IntegerAssert)Assertions.assertThat((int)actualSize.x).overridingErrorMessage("Expected size of <%s, %s> but was <%s, %s>", new Object[]{width, height, actualSize.x, actualSize.y})).isEqualTo(width);
        ((IntegerAssert)Assertions.assertThat((int)actualSize.y).overridingErrorMessage("Expected size of <%s, %s> but was <%s, %s>", new Object[]{width, height, actualSize.x, actualSize.y})).isEqualTo(height);
        return this;
    }

    public DisplayAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Display)this.actual).getWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }
}

