/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.view.Menu;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public final class MenuAssert
extends AbstractAssert<MenuAssert, Menu> {
    public MenuAssert(Menu actual) {
        super((Object)actual, MenuAssert.class);
    }

    public MenuAssert hasItem(int id) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((Menu)this.actual).findItem(id)).overridingErrorMessage("Expected menu item with ID <%s> but was not found.", new Object[0])).isNotNull();
        return this;
    }

    public MenuAssert hasItemAt(int index) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((Menu)this.actual).getItem(index)).overridingErrorMessage("Expected menu item at index <%s> but was not found.", new Object[0])).isNotNull();
        return this;
    }

    public MenuAssert hasVisibleItems() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Menu)this.actual).hasVisibleItems()).overridingErrorMessage("Expected to have visible items but had no visible items.", new Object[0])).isTrue();
        return this;
    }

    public MenuAssert hasNoVisibleItems() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Menu)this.actual).hasVisibleItems()).overridingErrorMessage("Expected to have no visible items but had visible items.", new Object[0])).isFalse();
        return this;
    }

    public MenuAssert hasSize(int size) {
        this.isNotNull();
        int actualSize = ((Menu)this.actual).size();
        ((IntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected size <%s> but was <%s>.", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }
}

