/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.webkit;

import android.net.http.SslCertificate;
import android.webkit.WebView;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;
import org.fest.assertions.api.android.widget.AbstractAbsoluteLayoutAssert;

public class WebViewAssert
extends AbstractAbsoluteLayoutAssert<WebViewAssert, WebView> {
    public WebViewAssert(WebView actual) {
        super(actual, WebViewAssert.class);
    }

    public WebViewAssert canGoBack() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).canGoBack()).overridingErrorMessage("Expected to be able to go back but could not.", new Object[0])).isTrue();
        return this;
    }

    public WebViewAssert canNotGoBack() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).canGoBack()).overridingErrorMessage("Expected to not be able to go back but could.", new Object[0])).isFalse();
        return this;
    }

    public WebViewAssert canGoForward() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).canGoForward()).overridingErrorMessage("Expected to be able to go forward but could not.", new Object[0])).isTrue();
        return this;
    }

    public WebViewAssert canNotGoForward() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).canGoForward()).overridingErrorMessage("Expected to not be able to go forward but could.", new Object[0])).isFalse();
        return this;
    }

    public WebViewAssert hasCertifiate(SslCertificate certificate) {
        this.isNotNull();
        SslCertificate actualCertificate = ((WebView)this.actual).getCertificate();
        ((ObjectAssert)Assertions.assertThat((Object)actualCertificate).overridingErrorMessage("Expected certificate <%s> but was <%s>.", new Object[]{certificate, actualCertificate})).isSameAs((Object)certificate);
        return this;
    }

    public WebViewAssert hasContentHeight(int height) {
        this.isNotNull();
        int actualHeight = ((WebView)this.actual).getContentHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected content height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public WebViewAssert hasOriginalUrl(String url) {
        this.isNotNull();
        String actualUrl = ((WebView)this.actual).getOriginalUrl();
        ((StringAssert)Assertions.assertThat((String)actualUrl).overridingErrorMessage("Expected original URL <%s> but was <%s>.", new Object[]{url, actualUrl})).isEqualTo((Object)url);
        return this;
    }

    public WebViewAssert hasProgress(int progress) {
        this.isNotNull();
        int actualProgress = ((WebView)this.actual).getProgress();
        ((IntegerAssert)Assertions.assertThat((int)actualProgress).overridingErrorMessage("Expected progress <%s> but was <%s>.", new Object[]{progress, actualProgress})).isEqualTo(progress);
        return this;
    }

    public WebViewAssert hasTitle(String title) {
        this.isNotNull();
        String actualTitle = ((WebView)this.actual).getTitle();
        ((StringAssert)Assertions.assertThat((String)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return this;
    }

    public WebViewAssert hasUrl(String url) {
        this.isNotNull();
        String actualUrl = ((WebView)this.actual).getUrl();
        ((StringAssert)Assertions.assertThat((String)actualUrl).overridingErrorMessage("Expected URL <%s> but was <%s>.", new Object[]{url, actualUrl})).isEqualTo((Object)url);
        return this;
    }

    public WebViewAssert isPrivateBrowsingEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).isPrivateBrowsingEnabled()).overridingErrorMessage("Expected private browsing to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public WebViewAssert isPrivateBrowsingDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((WebView)this.actual).isPrivateBrowsingEnabled()).overridingErrorMessage("Expected private browsing to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }
}

