/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.LongAssert;
import org.fest.assertions.api.ObjectAssert;

public abstract class AbstractAdapterViewAssert<S extends AbstractAdapterViewAssert<S, A>, A extends AdapterView>
extends AbstractAssert<S, A> {
    protected AbstractAdapterViewAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdapter(Adapter adapter) {
        this.isNotNull();
        Adapter actualAdapter = ((AdapterView)this.actual).getAdapter();
        ((ObjectAssert)Assertions.assertThat((Object)actualAdapter).overridingErrorMessage("Expected adapter <%s> but was <%s>.", new Object[]{adapter, actualAdapter})).isSameAs((Object)adapter);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasCount(int count) {
        this.isNotNull();
        int actualCount = ((AdapterView)this.actual).getCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasFirstVisiblePosition(int position) {
        this.isNotNull();
        int actualPosition = ((AdapterView)this.actual).getFirstVisiblePosition();
        ((IntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected first visible position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasItemAtPosition(int position, Object item) {
        this.isNotNull();
        Object actualItem = ((AdapterView)this.actual).getItemAtPosition(position);
        ((ObjectAssert)Assertions.assertThat((Object)actualItem).overridingErrorMessage("Expected item <%s> at position %s but was <%s>.", new Object[]{item, position, actualItem})).isEqualTo(item);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasItemIdAtPosition(int position, long id) {
        this.isNotNull();
        long actualId = ((AdapterView)this.actual).getItemIdAtPosition(position);
        ((LongAssert)Assertions.assertThat((long)actualId).overridingErrorMessage("Expected item ID <%s> at position %s but was <%s>.", new Object[]{id, position, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasLastVisiblePosition(int position) {
        this.isNotNull();
        int actualPosition = ((AdapterView)this.actual).getLastVisiblePosition();
        ((IntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected last visible position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasPositionForView(View view, int position) {
        this.isNotNull();
        int actualPosition = ((AdapterView)this.actual).getPositionForView(view);
        ((IntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected position <%s> for view %s but was <%s>.", new Object[]{position, view, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasSelectedItem(Object item) {
        this.isNotNull();
        Object actualItem = ((AdapterView)this.actual).getSelectedItem();
        ((ObjectAssert)Assertions.assertThat((Object)actualItem).overridingErrorMessage("Expected selected item <%s> but was <%s>.", new Object[]{item, actualItem})).isEqualTo(item);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasSelectedItemId(long id) {
        this.isNotNull();
        long actualId = ((AdapterView)this.actual).getSelectedItemId();
        ((LongAssert)Assertions.assertThat((long)actualId).overridingErrorMessage("Expected selected item ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasSelectedItemPosition(int position) {
        this.isNotNull();
        int actualPosition = ((AdapterView)this.actual).getSelectedItemPosition();
        ((IntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected selected item position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }

    public S hasSelectedView(View view) {
        this.isNotNull();
        View actualView = ((AdapterView)this.actual).getSelectedView();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected selected view <%s> but was <%s>", new Object[]{view, actualView})).isSameAs((Object)view);
        return (S)((Object)((AbstractAdapterViewAssert)this.myself));
    }
}

