/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.LinearLayout;
import java.util.ArrayList;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.Utils;

public abstract class AbstractLinearLayoutAssert<S extends AbstractLinearLayoutAssert<S, A>, A extends LinearLayout>
extends AbstractAssert<S, A> {
    protected AbstractLinearLayoutAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasBaseline(int baseline) {
        this.isNotNull();
        int actualBaseline = ((LinearLayout)this.actual).getBaseline();
        ((IntegerAssert)Assertions.assertThat((int)actualBaseline).overridingErrorMessage("Expected baseline <%s> but was <%s>.", new Object[]{baseline, actualBaseline})).isEqualTo(baseline);
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S hasDividerPadding(int padding) {
        this.isNotNull();
        int actualPadding = ((LinearLayout)this.actual).getDividerPadding();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected divider padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S hasOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((LinearLayout)this.actual).getOrientation();
        ((IntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>.", new Object[]{AbstractLinearLayoutAssert.orientationToString(orientation), AbstractLinearLayoutAssert.orientationToString(actualOrientation)})).isEqualTo(orientation);
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S hasShowDividers(int dividers) {
        this.isNotNull();
        int actualDividers = ((LinearLayout)this.actual).getShowDividers();
        ((IntegerAssert)Assertions.assertThat((int)actualDividers).overridingErrorMessage("Expected showing dividers <%s> but was <%s>.", new Object[]{AbstractLinearLayoutAssert.showDividerToString(dividers), AbstractLinearLayoutAssert.showDividerToString(actualDividers)})).isEqualTo(dividers);
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S hasWeightSum(float sum) {
        this.isNotNull();
        float actualSum = ((LinearLayout)this.actual).getWeightSum();
        ((FloatAssert)Assertions.assertThat((float)actualSum).overridingErrorMessage("Expected weight sum <%s> but was <%s>.", new Object[]{Float.valueOf(sum), Float.valueOf(actualSum)})).isEqualTo(sum);
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S isBaselineAligned() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LinearLayout)this.actual).isBaselineAligned()).overridingErrorMessage("Expected to be baseline aligned but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S isNotBaselineAligned() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LinearLayout)this.actual).isBaselineAligned()).overridingErrorMessage("Expected to not be baseline aligned but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S isMeasuringWithLargestChild() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LinearLayout)this.actual).isMeasureWithLargestChildEnabled()).overridingErrorMessage("Expected to be measuring with largest child but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    public S isNotMeasuringWithLargestChild() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LinearLayout)this.actual).isMeasureWithLargestChildEnabled()).overridingErrorMessage("Expected to not be measuring with largest child but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractLinearLayoutAssert)this.myself));
    }

    static String showDividerToString(int dividers) {
        if (dividers == 0) {
            return "none";
        }
        ArrayList<String> parts = new ArrayList<String>();
        if ((dividers & 1) != 0) {
            parts.add("beginning");
        }
        if ((dividers & 2) != 0) {
            parts.add("middle");
        }
        if ((dividers & 4) != 0) {
            parts.add("end");
        }
        return Utils.join(parts);
    }

    private static String orientationToString(int orientation) {
        switch (orientation) {
            case 0: {
                return "horizontal";
            }
            case 1: {
                return "vertical";
            }
        }
        throw new IllegalArgumentException("Unknown orientation: " + orientation);
    }
}

