/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.TextView;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.view.AbstractViewAssert;

public abstract class AbstractTextViewAssert<S extends AbstractTextViewAssert<S, A>, A extends TextView>
extends AbstractViewAssert<S, A> {
    protected AbstractTextViewAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAutoLinkMask(int mask) {
        this.isNotNull();
        int actualMask = ((TextView)this.actual).getAutoLinkMask();
        ((IntegerAssert)Assertions.assertThat((int)actualMask).overridingErrorMessage("Expected auto-link mask <%s> but was <%s>.", new Object[]{mask, actualMask})).isEqualTo(mask);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundDrawablePadding(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundDrawablePadding();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundPaddingBottom(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingBottom();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable bottom padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundPaddingLeft(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingLeft();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable left padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundPaddingRight(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingRight();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable right padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCompoundPaddingTop(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getCompoundPaddingTop();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected compound drawable top padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCurrentHintTextColor(int color) {
        this.isNotNull();
        int actualColor = ((TextView)this.actual).getCurrentHintTextColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected current hint text color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasCurrentTextColor(int color) {
        this.isNotNull();
        int actualColor = ((TextView)this.actual).getCurrentTextColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected current text color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasExtendedPaddingBottom(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getExtendedPaddingBottom();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected extended bottom padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasExtendedPaddingTop(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getExtendedPaddingTop();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected extended top padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasFreezesText(boolean freezes) {
        this.isNotNull();
        boolean actualFreezes = ((TextView)this.actual).getFreezesText();
        ((BooleanAssert)Assertions.assertThat((boolean)actualFreezes).overridingErrorMessage("Expected freezes text <%s> but was <%s>.", new Object[]{freezes, actualFreezes})).isEqualTo(freezes);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((TextView)this.actual).getGravity();
        ((IntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(gravity);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasHighlightColor(int color) {
        this.isNotNull();
        int actualColor = ((TextView)this.actual).getHighlightColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected highlight color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasHint(CharSequence hint) {
        this.isNotNull();
        CharSequence actualHint = ((TextView)this.actual).getHint();
        ((ObjectAssert)Assertions.assertThat((Object)actualHint).overridingErrorMessage("Expected hint <%s> but was <%s>.", new Object[]{hint, actualHint})).isEqualTo((Object)hint);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasImeActionId(int id) {
        this.isNotNull();
        int actualId = ((TextView)this.actual).getImeActionId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected IME action ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasImeActionLabel(CharSequence label) {
        this.isNotNull();
        CharSequence actualLabel = ((TextView)this.actual).getImeActionLabel();
        ((ObjectAssert)Assertions.assertThat((Object)actualLabel).overridingErrorMessage("Expected IME action label <%s> but was <%s>.", new Object[]{label, actualLabel})).isEqualTo((Object)label);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasImeOptions(int options) {
        this.isNotNull();
        int actualOptions = ((TextView)this.actual).getImeOptions();
        ((IntegerAssert)Assertions.assertThat((int)actualOptions).overridingErrorMessage("Expected IME options <%s> but was <%s>.", new Object[]{options, actualOptions})).isEqualTo(options);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S isIncludingFontPadding() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).getIncludeFontPadding()).overridingErrorMessage("Expected to be including font padding but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S isNotIncludingFontPadding() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).getIncludeFontPadding()).overridingErrorMessage("Expected to not be including font padding but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasInputType(int type) {
        this.isNotNull();
        int actualType = ((TextView)this.actual).getInputType();
        ((IntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected input type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo(type);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasLineCount(int count) {
        this.isNotNull();
        int actualCount = ((TextView)this.actual).getLineCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected line count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasLineHeight(int height) {
        this.isNotNull();
        int actualHeight = ((TextView)this.actual).getLineHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected line height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasLineSpacingExtra(float extra) {
        this.isNotNull();
        float actualExtra = ((TextView)this.actual).getLineSpacingExtra();
        ((FloatAssert)Assertions.assertThat((float)actualExtra).overridingErrorMessage("Expected line spacing extra <%s> but was <%s>.", new Object[]{Float.valueOf(extra), Float.valueOf(actualExtra)})).isEqualTo(extra);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasLineSpacingMultiplier(float multiplier) {
        this.isNotNull();
        float actualMultiplier = ((TextView)this.actual).getLineSpacingMultiplier();
        ((FloatAssert)Assertions.assertThat((float)actualMultiplier).overridingErrorMessage("Expected line spacing multiplier <%s> but was <%s>.", new Object[]{Float.valueOf(multiplier), Float.valueOf(actualMultiplier)})).isEqualTo(multiplier);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasMarqueeRepeatLimit(int limit) {
        this.isNotNull();
        int actualLimit = ((TextView)this.actual).getMarqueeRepeatLimit();
        ((IntegerAssert)Assertions.assertThat((int)actualLimit).overridingErrorMessage("Expected marquee repeat limit <%s> but was <%s>.", new Object[]{limit, actualLimit})).isEqualTo(limit);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasMaxEms(int ems) {
        this.isNotNull();
        int actualEms = ((TextView)this.actual).getMaxEms();
        ((IntegerAssert)Assertions.assertThat((int)actualEms).overridingErrorMessage("Expected maximum EMs <%s> but was <%s>.", new Object[]{ems, actualEms})).isEqualTo(ems);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasMaxHeight(int height) {
        this.isNotNull();
        int actualHeight = ((TextView)this.actual).getMaxHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected maximum height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasMaxLines(int lines) {
        this.isNotNull();
        int actualLines = ((TextView)this.actual).getMaxLines();
        ((IntegerAssert)Assertions.assertThat((int)actualLines).overridingErrorMessage("Expected maximum lines <%s> but was <%s>.", new Object[]{lines, actualLines})).isEqualTo(lines);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasMaxWidth(int ems) {
        this.isNotNull();
        int actualWidth = ((TextView)this.actual).getMaxWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected maximum width <%s> but was <%s>.", new Object[]{ems, actualWidth})).isEqualTo(ems);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasMinEms(int ems) {
        this.isNotNull();
        int actualEms = ((TextView)this.actual).getMinEms();
        ((IntegerAssert)Assertions.assertThat((int)actualEms).overridingErrorMessage("Expected minimum EMs <%s> but was <%s>.", new Object[]{ems, actualEms})).isEqualTo(ems);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasMinHeight(int height) {
        this.isNotNull();
        int actualHeight = ((TextView)this.actual).getMinHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected minimum height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasMinLines(int lines) {
        this.isNotNull();
        int actualLines = ((TextView)this.actual).getMinLines();
        ((IntegerAssert)Assertions.assertThat((int)actualLines).overridingErrorMessage("Expected minimum lines <%s> but was <%s>.", new Object[]{lines, actualLines})).isEqualTo(lines);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasMinWidth(int ems) {
        this.isNotNull();
        int actualWidth = ((TextView)this.actual).getMinWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected minimum width <%s> but was <%s>.", new Object[]{ems, actualWidth})).isEqualTo(ems);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasPaintFlags(int flags) {
        this.isNotNull();
        int actualFlags = ((TextView)this.actual).getPaintFlags();
        ((IntegerAssert)Assertions.assertThat((int)actualFlags).overridingErrorMessage("Expected paint flags <%s> but was <%s>.", new Object[]{flags, actualFlags})).isEqualTo(flags);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasSelectionEnd(int position) {
        this.isNotNull();
        int actualPosition = ((TextView)this.actual).getSelectionEnd();
        ((IntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected selection end <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasSelectionStart(int position) {
        this.isNotNull();
        int actualPosition = ((TextView)this.actual).getSelectionStart();
        ((IntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected selection start <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasShadowColor(int color) {
        this.isNotNull();
        int actualColor = ((TextView)this.actual).getShadowColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected shadow color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasShadowDx(float dx) {
        this.isNotNull();
        float actualDx = ((TextView)this.actual).getShadowDx();
        ((FloatAssert)Assertions.assertThat((float)actualDx).overridingErrorMessage("Expected shadow DX <%s> but was <%s>.", new Object[]{Float.valueOf(dx), Float.valueOf(actualDx)})).isEqualTo(dx);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasShadowDy(float dy) {
        this.isNotNull();
        float actualDy = ((TextView)this.actual).getShadowDy();
        ((FloatAssert)Assertions.assertThat((float)actualDy).overridingErrorMessage("Expected shadow DY <%s> but was <%s>.", new Object[]{Float.valueOf(dy), Float.valueOf(actualDy)})).isEqualTo(dy);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasShadowRadius(float radius) {
        this.isNotNull();
        float actualRadius = ((TextView)this.actual).getShadowRadius();
        ((FloatAssert)Assertions.assertThat((float)actualRadius).overridingErrorMessage("Expected shadow radius <%s> but was <%s>.", new Object[]{Float.valueOf(radius), Float.valueOf(actualRadius)})).isEqualTo(radius);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((TextView)this.actual).getText();
        ((ObjectAssert)Assertions.assertThat((Object)actualText).overridingErrorMessage("Expected text <%s> but was <%s>", new Object[]{text, actualText})).isEqualTo((Object)text);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTextScaleX(float scale) {
        this.isNotNull();
        float actualScale = ((TextView)this.actual).getTextScaleX();
        ((FloatAssert)Assertions.assertThat((float)actualScale).overridingErrorMessage("Expected text X scale <%s> but was <%s>.", new Object[]{Float.valueOf(scale), Float.valueOf(actualScale)})).isEqualTo(scale);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTextSize(float size) {
        this.isNotNull();
        float actualSize = ((TextView)this.actual).getTextSize();
        ((FloatAssert)Assertions.assertThat((float)actualSize).overridingErrorMessage("Expected text size <%s> but was <%s>.", new Object[]{Float.valueOf(size), Float.valueOf(actualSize)})).isEqualTo(size);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTotalPaddingBottom(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingBottom();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total bottom padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTotalPaddingLeft(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingLeft();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total left padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTotalPaddingRight(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingRight();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total right padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasTotalPaddingTop(int padding) {
        this.isNotNull();
        int actualPadding = ((TextView)this.actual).getTotalPaddingTop();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected total top padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S isCursorVisible() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isCursorVisible()).overridingErrorMessage("Expected cursor to be visible but was not visible.", new Object[0])).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S isCursorNotVisible() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isCursorVisible()).overridingErrorMessage("Expected cursor to not be visible but was visible.", new Object[0])).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasSelectableText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isTextSelectable()).overridingErrorMessage("Expected text to be selectable but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasUnselectableText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((TextView)this.actual).isTextSelectable()).overridingErrorMessage("Expected text to not be selectable but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }

    public S hasLength(int length) {
        this.isNotNull();
        int actualLength = ((TextView)this.actual).length();
        ((IntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected length <%s> but was <%s>.", new Object[]{length, actualLength})).isEqualTo(length);
        return (S)((Object)((AbstractTextViewAssert)this.myself));
    }
}

