/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.GridLayout;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.view.AbstractViewGroupAssert;

public class GridLayoutAssert
extends AbstractViewGroupAssert<GridLayoutAssert, GridLayout> {
    public GridLayoutAssert(GridLayout actual) {
        super(actual, GridLayoutAssert.class);
    }

    public GridLayoutAssert hasAlignmentMode(int mode) {
        this.isNotNull();
        int actualMode = ((GridLayout)this.actual).getAlignmentMode();
        ((IntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected alignment mode <%s> but was <%s>.", new Object[]{GridLayoutAssert.alignmentModeToString(mode), GridLayoutAssert.alignmentModeToString(actualMode)})).isEqualTo(mode);
        return this;
    }

    public GridLayoutAssert hasColumnCount(int count) {
        this.isNotNull();
        int actualCount = ((GridLayout)this.actual).getColumnCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected column count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public GridLayoutAssert hasOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((GridLayout)this.actual).getOrientation();
        ((IntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>.", new Object[]{GridLayoutAssert.orientationToString(orientation), GridLayoutAssert.orientationToString(actualOrientation)})).isEqualTo(orientation);
        return this;
    }

    public GridLayoutAssert hasRowCount(int count) {
        this.isNotNull();
        int actualCount = ((GridLayout)this.actual).getRowCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected row count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public GridLayoutAssert isUsingDefaultMargins() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).getUseDefaultMargins()).overridingErrorMessage("Expected to be using default margins but was not.", new Object[0])).isTrue();
        return this;
    }

    public GridLayoutAssert isNotUsingDefaultMargins() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).getUseDefaultMargins()).overridingErrorMessage("Expected to not be using default margins but was.", new Object[0])).isFalse();
        return this;
    }

    public GridLayoutAssert isPreservingColumnOrder() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).isColumnOrderPreserved()).overridingErrorMessage("Expected to be preserving column order but was not.", new Object[0])).isTrue();
        return this;
    }

    public GridLayoutAssert isNotPreservingColumnOrder() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).isColumnOrderPreserved()).overridingErrorMessage("Expected to not be preserving column order but was.", new Object[0])).isFalse();
        return this;
    }

    public GridLayoutAssert isPreservingRowOrder() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).isRowOrderPreserved()).overridingErrorMessage("Expected to be preserving row order but was not.", new Object[0])).isTrue();
        return this;
    }

    public GridLayoutAssert isNotPreservingRowOrder() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).isRowOrderPreserved()).overridingErrorMessage("Expected to not be preserving row order but was.", new Object[0])).isFalse();
        return this;
    }

    private static String alignmentModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "alignBounds";
            }
            case 1: {
                return "alignMargins";
            }
        }
        throw new IllegalArgumentException("Unknown alignment mode: " + mode);
    }

    private static String orientationToString(int orientation) {
        switch (orientation) {
            case 0: {
                return "horizontal";
            }
            case 1: {
                return "vertical";
            }
        }
        throw new IllegalArgumentException("Unknown orientation: " + orientation);
    }
}

