/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.graphics.drawable.Drawable;
import android.widget.Spinner;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.widget.AbstractAbsSpinnerAssert;

public class SpinnerAssert
extends AbstractAbsSpinnerAssert<SpinnerAssert, Spinner> {
    public SpinnerAssert(Spinner actual) {
        super(actual, SpinnerAssert.class);
    }

    public SpinnerAssert hasDropDownHorizontalOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((Spinner)this.actual).getDropDownHorizontalOffset();
        ((IntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected drop-down horizontal offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    public SpinnerAssert hasDropDownVerticalOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((Spinner)this.actual).getDropDownVerticalOffset();
        ((IntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected drop-down vertical offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    public SpinnerAssert hasDropDownWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Spinner)this.actual).getDropDownWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected drop-down width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public SpinnerAssert hasGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((Spinner)this.actual).getGravity();
        ((IntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(gravity);
        return this;
    }

    public SpinnerAssert hasPopupBackground(Drawable background) {
        this.isNotNull();
        Drawable actualBackground = ((Spinner)this.actual).getPopupBackground();
        ((ObjectAssert)Assertions.assertThat((Object)actualBackground).overridingErrorMessage("Expected popup background <%s> but was <%s>.", new Object[]{background, actualBackground})).isSameAs((Object)background);
        return this;
    }

    public SpinnerAssert hasPrompt(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((Spinner)this.actual).getPrompt();
        ((ObjectAssert)Assertions.assertThat((Object)actualText).overridingErrorMessage("Expected prompt <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return this;
    }
}

