/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.MenuItem;
import android.view.View;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.CharacterAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public class MenuItemAssert
extends AbstractAssert<MenuItemAssert, MenuItem> {
    public MenuItemAssert(MenuItem actual) {
        super((Object)actual, MenuItemAssert.class);
    }

    public MenuItemAssert hasActionView(View view) {
        this.isNotNull();
        View actualView = ((MenuItem)this.actual).getActionView();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected action view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public MenuItemAssert hasAlphabeticShortcut(char shortcut) {
        this.isNotNull();
        char actualShortcut = ((MenuItem)this.actual).getAlphabeticShortcut();
        ((CharacterAssert)Assertions.assertThat((char)actualShortcut).overridingErrorMessage("Expected alphabetic shortcut <%s> but was <%s>.", new Object[]{Character.valueOf(shortcut), Character.valueOf(actualShortcut)})).isEqualTo(shortcut);
        return this;
    }

    public MenuItemAssert hasGroupId(int id) {
        this.isNotNull();
        int actualId = ((MenuItem)this.actual).getGroupId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected group ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public MenuItemAssert hasIcon(Drawable icon) {
        this.isNotNull();
        Drawable actualIcon = ((MenuItem)this.actual).getIcon();
        ((ObjectAssert)Assertions.assertThat((Object)actualIcon).overridingErrorMessage("Expected icon <%s> but was <%s>.", new Object[]{icon, actualIcon})).isSameAs((Object)icon);
        return this;
    }

    public MenuItemAssert hasIntent(Intent intent) {
        this.isNotNull();
        Intent actualIntent = ((MenuItem)this.actual).getIntent();
        ((ObjectAssert)Assertions.assertThat((Object)actualIntent).overridingErrorMessage("Expected intent <%s> but was <%s>.", new Object[]{intent, actualIntent})).isEqualTo((Object)intent);
        return this;
    }

    public MenuItemAssert hasItemId(int id) {
        this.isNotNull();
        int actualId = ((MenuItem)this.actual).getItemId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected item ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public MenuItemAssert hasNumericShortcut(char shortcut) {
        this.isNotNull();
        char actualShortcut = ((MenuItem)this.actual).getNumericShortcut();
        ((CharacterAssert)Assertions.assertThat((char)actualShortcut).overridingErrorMessage("Expected numeric shortcut <%s> but was <%s>.", new Object[]{Character.valueOf(shortcut), Character.valueOf(actualShortcut)})).isEqualTo(shortcut);
        return this;
    }

    public MenuItemAssert hasOrder(int order) {
        this.isNotNull();
        int actualOrder = ((MenuItem)this.actual).getOrder();
        ((IntegerAssert)Assertions.assertThat((int)actualOrder).overridingErrorMessage("Expected order <%s> but was <%s>.", new Object[]{order, actualOrder})).isEqualTo(order);
        return this;
    }

    public MenuItemAssert hasTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((MenuItem)this.actual).getTitle();
        ((ObjectAssert)Assertions.assertThat((Object)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return this;
    }

    public MenuItemAssert hasCondensedTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((MenuItem)this.actual).getTitleCondensed();
        ((ObjectAssert)Assertions.assertThat((Object)actualTitle).overridingErrorMessage("Expected condensed title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return this;
    }

    public MenuItemAssert hasSubMenu() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).hasSubMenu()).overridingErrorMessage("Expected to have sub-menu but sub-menu was not present.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert hasNoSubMenu() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).hasSubMenu()).overridingErrorMessage("Expected to not have a sub-menu but sub-menu was present.", new Object[0])).isFalse();
        return this;
    }

    public MenuItemAssert isActionViewExpanded() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isActionViewExpanded()).overridingErrorMessage("Expected expanded action view but action view was collapsed.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert isActionViewCollapsed() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isActionViewExpanded()).overridingErrorMessage("Expected collapsed action view but action view was expanded.", new Object[0])).isFalse();
        return this;
    }

    public MenuItemAssert isCheckable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isCheckable()).overridingErrorMessage("Expected to be checkable but was not checkable.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert isNotCheckable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isCheckable()).overridingErrorMessage("Expected to not be checkable but was checkable.", new Object[0])).isFalse();
        return this;
    }

    public MenuItemAssert isChecked() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isChecked()).overridingErrorMessage("Expected to be checked but was not checked.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert isNotChecked() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isChecked()).overridingErrorMessage("Expected to not be checked but was checked.", new Object[0])).isFalse();
        return this;
    }

    public MenuItemAssert isEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isEnabled()).overridingErrorMessage("Expected to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert isDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isEnabled()).overridingErrorMessage("Expected to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }

    public MenuItemAssert isVisible() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isVisible()).overridingErrorMessage("Expected to be visible but was not visible.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert isNotVisible() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isVisible()).overridingErrorMessage("Expected to not be visible but was visible.", new Object[0])).isFalse();
        return this;
    }
}

