/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.preference;

import android.preference.RingtonePreference;
import android.text.TextUtils;
import java.util.ArrayList;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.preference.AbstractPreferenceAssert;

public class RingtonePreferenceAssert
extends AbstractPreferenceAssert<RingtonePreferenceAssert, RingtonePreference> {
    public RingtonePreferenceAssert(RingtonePreference actual) {
        super(actual, RingtonePreferenceAssert.class);
    }

    public RingtonePreferenceAssert hasRingtoneType(int type) {
        this.isNotNull();
        int actualType = ((RingtonePreference)this.actual).getRingtoneType();
        ((IntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected ringtone type <%s> but was <%s>.", new Object[]{RingtonePreferenceAssert.ringtoneTypeToString(type), RingtonePreferenceAssert.ringtoneTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public RingtonePreferenceAssert isShowingDefault() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((RingtonePreference)this.actual).getShowDefault()).overridingErrorMessage("Expected to be showing default but was not.", new Object[0])).isTrue();
        return this;
    }

    public RingtonePreferenceAssert isNotShowingDefault() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((RingtonePreference)this.actual).getShowDefault()).overridingErrorMessage("Expected to not be showing default but was.", new Object[0])).isFalse();
        return this;
    }

    public RingtonePreferenceAssert isShowingSilent() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((RingtonePreference)this.actual).getShowSilent()).overridingErrorMessage("Expected to be showing silent but was not.", new Object[0])).isTrue();
        return this;
    }

    public RingtonePreferenceAssert isNotShowingSilent() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((RingtonePreference)this.actual).getShowSilent()).overridingErrorMessage("Expected to not be showing silent but was.", new Object[0])).isFalse();
        return this;
    }

    private static String ringtoneTypeToString(int type) {
        ArrayList<String> parts = new ArrayList<String>();
        if ((type & 4) != 0) {
            parts.add("alarm");
        }
        if ((type & 2) != 0) {
            parts.add("notification");
        }
        if ((type & 1) != 0) {
            parts.add("ringtone");
        }
        return TextUtils.join((CharSequence)", ", parts);
    }
}

