/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.GridView;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.widget.AbstractAbsListViewAssert;

public class GridViewAssert
extends AbstractAbsListViewAssert<GridViewAssert, GridView> {
    public GridViewAssert(GridView actual) {
        super(actual, GridViewAssert.class);
    }

    public GridViewAssert hasColumnWidth(int width) {
        this.isNotNull();
        int actualWidth = ((GridView)this.actual).getColumnWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected column width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public GridViewAssert hasGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((GridView)this.actual).getGravity();
        ((IntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(gravity);
        return this;
    }

    public GridViewAssert hasHorizontalSpacing(int spacing) {
        this.isNotNull();
        int actualSpacing = ((GridView)this.actual).getHorizontalSpacing();
        ((IntegerAssert)Assertions.assertThat((int)actualSpacing).overridingErrorMessage("Expected horizontal spacing <%s> but was <%s>.", new Object[]{spacing, actualSpacing})).isEqualTo(spacing);
        return this;
    }

    public GridViewAssert hasColumnCount(int count) {
        this.isNotNull();
        int actualCount = ((GridView)this.actual).getNumColumns();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected column count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public GridViewAssert hasRequestedColumnWidth(int width) {
        this.isNotNull();
        int actualWidth = ((GridView)this.actual).getRequestedColumnWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected requested column width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public GridViewAssert hasRequestedHorizontalSpacing(int spacing) {
        this.isNotNull();
        int actualSpacing = ((GridView)this.actual).getRequestedHorizontalSpacing();
        ((IntegerAssert)Assertions.assertThat((int)actualSpacing).overridingErrorMessage("Expected requested horizontal spacing <%s> but was <%s>.", new Object[]{spacing, actualSpacing})).isEqualTo(spacing);
        return this;
    }

    public GridViewAssert hasStretchMode(int mode) {
        this.isNotNull();
        int actualMode = ((GridView)this.actual).getStretchMode();
        ((IntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected stretch mode <%s> but was <%s>.", new Object[]{GridViewAssert.stretchModeToString(mode), GridViewAssert.stretchModeToString(actualMode)})).isEqualTo(mode);
        return this;
    }

    public GridViewAssert hasVerticalSpacing(int spacing) {
        this.isNotNull();
        int actualSpacing = ((GridView)this.actual).getVerticalSpacing();
        ((IntegerAssert)Assertions.assertThat((int)actualSpacing).overridingErrorMessage("Expected vertical spacing <%s> but was <%s>.", new Object[]{spacing, actualSpacing})).isEqualTo(spacing);
        return this;
    }

    private static String stretchModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "noStretch";
            }
            case 1: {
                return "stretchSpacing";
            }
            case 3: {
                return "stretchSpacingUniform";
            }
            case 2: {
                return "stretchColumnWidth";
            }
        }
        throw new IllegalArgumentException("Unknown stretch mode: " + mode);
    }
}

