/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.HorizontalScrollView;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.widget.AbstractFrameLayoutAssert;

public class HorizontalScrollViewAssert
extends AbstractFrameLayoutAssert<HorizontalScrollViewAssert, HorizontalScrollView> {
    public HorizontalScrollViewAssert(HorizontalScrollView actual) {
        super(actual, HorizontalScrollViewAssert.class);
    }

    public HorizontalScrollViewAssert hasMaximumScrollAmount(int amount) {
        this.isNotNull();
        int actualAmount = ((HorizontalScrollView)this.actual).getMaxScrollAmount();
        ((IntegerAssert)Assertions.assertThat((int)actualAmount).overridingErrorMessage("Expected maximum scroll amount <%s> but was <%s>.", new Object[]{amount, actualAmount})).isEqualTo(amount);
        return this;
    }

    public HorizontalScrollViewAssert isFillingViewport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((HorizontalScrollView)this.actual).isFillViewport()).overridingErrorMessage("Expected to be filling viewport but was not.", new Object[0])).isTrue();
        return this;
    }

    public HorizontalScrollViewAssert isNotFillingViewport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((HorizontalScrollView)this.actual).isFillViewport()).overridingErrorMessage("Expected to not be filling viewport but was.", new Object[0])).isFalse();
        return this;
    }

    public HorizontalScrollViewAssert isSmoothScrollingEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((HorizontalScrollView)this.actual).isSmoothScrollingEnabled()).overridingErrorMessage("Expected smooth scrolling to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public HorizontalScrollViewAssert isSmoothScrollingDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((HorizontalScrollView)this.actual).isSmoothScrollingEnabled()).overridingErrorMessage("Expected smooth scrolling to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }
}

