/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.graphics.drawable.Drawable;
import android.widget.Switch;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.widget.AbstractCompoundButtonAssert;

public class SwitchAssert
extends AbstractCompoundButtonAssert<SwitchAssert, Switch> {
    public SwitchAssert(Switch actual) {
        super(actual, SwitchAssert.class);
    }

    public SwitchAssert hasSwitchMinWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Switch)this.actual).getSwitchMinWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected switch min width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public SwitchAssert hasSwitchPadding(int padding) {
        this.isNotNull();
        int actualPadding = ((Switch)this.actual).getSwitchPadding();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected switch padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    public SwitchAssert hasOnText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((Switch)this.actual).getTextOn();
        ((ObjectAssert)Assertions.assertThat((Object)actualText).overridingErrorMessage("Expected 'on' text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return this;
    }

    public SwitchAssert hasOnText(int resId) {
        this.isNotNull();
        return this.hasOnText(((Switch)this.actual).getContext().getString(resId));
    }

    public SwitchAssert hasOffText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((Switch)this.actual).getTextOff();
        ((ObjectAssert)Assertions.assertThat((Object)actualText).overridingErrorMessage("Expected 'off' text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return this;
    }

    public SwitchAssert hasOffText(int resId) {
        this.isNotNull();
        return this.hasOffText(((Switch)this.actual).getContext().getString(resId));
    }

    public SwitchAssert hasThumbDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((Switch)this.actual).getThumbDrawable();
        ((ObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected thumb drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return this;
    }

    public SwitchAssert hasThumbTextPadding(int padding) {
        this.isNotNull();
        int actualPadding = ((Switch)this.actual).getThumbTextPadding();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected thumb text padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    public SwitchAssert hasTrackDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((Switch)this.actual).getTrackDrawable();
        ((ObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected track drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return this;
    }
}

