/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics;

import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.text.TextUtils;
import java.util.ArrayList;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public abstract class AbstractPaintAssert<S extends AbstractPaintAssert<S, A>, A extends Paint>
extends AbstractAssert<S, A> {
    protected AbstractPaintAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAscent(float ascent) {
        this.isNotNull();
        float actualAscent = ((Paint)this.actual).ascent();
        ((FloatAssert)Assertions.assertThat((float)actualAscent).overridingErrorMessage("Expected ascent <%s> but was <%s>.", new Object[]{Float.valueOf(ascent), Float.valueOf(actualAscent)})).isEqualTo(ascent);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasDescent(float descent) {
        this.isNotNull();
        float actualDescent = ((Paint)this.actual).descent();
        ((FloatAssert)Assertions.assertThat((float)actualDescent).overridingErrorMessage("Expected descent <%s> but was <%s>.", new Object[]{Float.valueOf(descent), Float.valueOf(actualDescent)})).isEqualTo(descent);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasAlpha(int alpha) {
        this.isNotNull();
        int actualAlpha = ((Paint)this.actual).getAlpha();
        ((IntegerAssert)Assertions.assertThat((int)actualAlpha).overridingErrorMessage("Expected alpha <%s> but was <%s>.", new Object[]{alpha, actualAlpha})).isEqualTo(alpha);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasColor(int color) {
        this.isNotNull();
        int actualColor = ((Paint)this.actual).getColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasFlags(int flags) {
        this.isNotNull();
        int actualFlags = ((Paint)this.actual).getFlags();
        ((IntegerAssert)Assertions.assertThat((int)actualFlags).overridingErrorMessage("Expected flags <%s> but was <%s>.", new Object[]{AbstractPaintAssert.flagsToString(flags), AbstractPaintAssert.flagsToString(actualFlags)})).isEqualTo(flags);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasFontSpacing(float spacing) {
        this.isNotNull();
        float actualSpacing = ((Paint)this.actual).getFontSpacing();
        ((FloatAssert)Assertions.assertThat((float)actualSpacing).overridingErrorMessage("Expected font spacing <%s> but was <%s>.", new Object[]{Float.valueOf(spacing), Float.valueOf(actualSpacing)})).isEqualTo(spacing);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasHinting(int hinting) {
        this.isNotNull();
        int actualHinting = ((Paint)this.actual).getHinting();
        ((IntegerAssert)Assertions.assertThat((int)actualHinting).overridingErrorMessage("Expected hinting <%s> but was <%s>.", new Object[]{hinting, actualHinting})).isEqualTo(hinting);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasMaskFilter(MaskFilter filter) {
        this.isNotNull();
        MaskFilter actualFilter = ((Paint)this.actual).getMaskFilter();
        ((ObjectAssert)Assertions.assertThat((Object)actualFilter).overridingErrorMessage("Expected mask filter <%s> but was <%s>.", new Object[]{filter, actualFilter})).isSameAs((Object)filter);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasPathEffect(PathEffect effect) {
        this.isNotNull();
        PathEffect actualEffect = ((Paint)this.actual).getPathEffect();
        ((ObjectAssert)Assertions.assertThat((Object)actualEffect).overridingErrorMessage("Expected path effect <%s> but was <%s>.", new Object[]{effect, actualEffect})).isSameAs((Object)effect);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasRasterizer(Rasterizer rasterizer) {
        this.isNotNull();
        Rasterizer actualRasterizer = ((Paint)this.actual).getRasterizer();
        ((ObjectAssert)Assertions.assertThat((Object)actualRasterizer).overridingErrorMessage("Expected rasterizer <%s> but was <%s>.", new Object[]{rasterizer, actualRasterizer})).isSameAs((Object)rasterizer);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasShader(Shader shader) {
        this.isNotNull();
        Shader actualShader = ((Paint)this.actual).getShader();
        ((ObjectAssert)Assertions.assertThat((Object)actualShader).overridingErrorMessage("Expected shader <%s> but was <%s>.", new Object[]{shader, actualShader})).isSameAs((Object)shader);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasStrokeCap(Paint.Cap cap) {
        this.isNotNull();
        Paint.Cap actualCap = ((Paint)this.actual).getStrokeCap();
        ((ObjectAssert)Assertions.assertThat((Object)actualCap).overridingErrorMessage("Expected stroke cap <%s> but was <%s>.", new Object[]{cap, actualCap})).isEqualTo((Object)cap);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasStrokeJoin(Paint.Join join) {
        this.isNotNull();
        Paint.Join actualJoin = ((Paint)this.actual).getStrokeJoin();
        ((ObjectAssert)Assertions.assertThat((Object)actualJoin).overridingErrorMessage("Expected stroke join <%s> but was <%s>.", new Object[]{join, actualJoin})).isEqualTo((Object)join);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasStrokeMiter(float miter) {
        this.isNotNull();
        float actualMiter = ((Paint)this.actual).getStrokeMiter();
        ((FloatAssert)Assertions.assertThat((float)actualMiter).overridingErrorMessage("Expected stroke miter <%s> but was <%s>.", new Object[]{Float.valueOf(miter), Float.valueOf(actualMiter)})).isEqualTo(miter);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasStrokeWidth(float width) {
        this.isNotNull();
        float actualWidth = ((Paint)this.actual).getStrokeWidth();
        ((FloatAssert)Assertions.assertThat((float)actualWidth).overridingErrorMessage("Expected stroke width <%s> but was <%s>.", new Object[]{Float.valueOf(width), Float.valueOf(actualWidth)})).isEqualTo(width);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasStyle(Paint.Style style) {
        this.isNotNull();
        Paint.Style actualStyle = ((Paint)this.actual).getStyle();
        ((ObjectAssert)Assertions.assertThat((Object)actualStyle).overridingErrorMessage("Expected style <%s> but was <%s>.", new Object[]{style, actualStyle})).isEqualTo((Object)style);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasTextAlign(Paint.Align align) {
        this.isNotNull();
        Paint.Align actualAlign = ((Paint)this.actual).getTextAlign();
        ((ObjectAssert)Assertions.assertThat((Object)actualAlign).overridingErrorMessage("Expected text align <%s> but was <%s>.", new Object[]{align, actualAlign})).isEqualTo((Object)align);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasTextScaleX(float scale) {
        this.isNotNull();
        float actualScale = ((Paint)this.actual).getTextScaleX();
        ((FloatAssert)Assertions.assertThat((float)actualScale).overridingErrorMessage("Expected text X scale <%s> but was <%s>.", new Object[]{Float.valueOf(scale), Float.valueOf(actualScale)})).isEqualTo(scale);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasTextSize(float size) {
        this.isNotNull();
        float actualSize = ((Paint)this.actual).getTextSize();
        ((FloatAssert)Assertions.assertThat((float)actualSize).overridingErrorMessage("Expected text size <%s> but was <%s>.", new Object[]{Float.valueOf(size), Float.valueOf(actualSize)})).isEqualTo(size);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasTextSkewX(float skew) {
        this.isNotNull();
        float actualSkew = ((Paint)this.actual).getTextSkewX();
        ((FloatAssert)Assertions.assertThat((float)actualSkew).overridingErrorMessage("Expected text X skew <%s> but was <%s>.", new Object[]{Float.valueOf(skew), Float.valueOf(actualSkew)})).isEqualTo(skew);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S hasTypeface(Typeface typeface) {
        this.isNotNull();
        Typeface actualTypeface = ((Paint)this.actual).getTypeface();
        ((ObjectAssert)Assertions.assertThat((Object)actualTypeface).overridingErrorMessage("Expected typeface <%s> but was <%s>.", new Object[]{typeface, actualTypeface})).isSameAs((Object)typeface);
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isAntiAliased() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isAntiAlias()).overridingErrorMessage("Expected to be anti-aliased but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isNotAntiAliased() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isAntiAlias()).overridingErrorMessage("Expected to not be anti-aliased but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isDithering() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isDither()).overridingErrorMessage("Expected to be dithering but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isNotDithering() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isDither()).overridingErrorMessage("Expected to not be dithering but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isFakingBoldText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isFakeBoldText()).overridingErrorMessage("Expected to not be faking bold text but was.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isNotFakingBoldText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isFakeBoldText()).overridingErrorMessage("Expected to not be faking bold text but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isStrikingThroughText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isStrikeThruText()).overridingErrorMessage("Expected to be striking through text but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isNotStrikingThroughText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isStrikeThruText()).overridingErrorMessage("Expected to be striking through text but was not.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isSubpixelText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isSubpixelText()).overridingErrorMessage("Expected to have subpixel text but did not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isNotSubpixelText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isSubpixelText()).overridingErrorMessage("Expected to not have subpixel text but did.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isUnderliningText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isUnderlineText()).overridingErrorMessage("Expected to be underlining text but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    public S isNotUnderliningText() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Paint)this.actual).isUnderlineText()).overridingErrorMessage("Expected to not be underlining text but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPaintAssert)this.myself));
    }

    private static String flagsToString(int flags) {
        ArrayList<String> parts = new ArrayList<String>();
        if ((flags & 1) != 0) {
            parts.add("antiAlias");
        }
        if ((flags & 0x100) != 0) {
            parts.add("devKern");
        }
        if ((flags & 4) != 0) {
            parts.add("dither");
        }
        if ((flags & 0x20) != 0) {
            parts.add("fakeBold");
        }
        if ((flags & 2) != 0) {
            parts.add("filterBitmap");
        }
        if ((flags & 0x40) != 0) {
            parts.add("linearText");
        }
        if ((flags & 0x10) != 0) {
            parts.add("strikeThrough");
        }
        if ((flags & 0x80) != 0) {
            parts.add("subpixelText");
        }
        if ((flags & 8) != 0) {
            parts.add("underline");
        }
        return TextUtils.join((CharSequence)", ", parts);
    }
}

