/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view.animation;

import android.text.TextUtils;
import android.view.animation.GridLayoutAnimationController;
import java.util.ArrayList;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.view.animation.AbstractLayoutAnimationControllerAssert;

public class GridLayoutAnimationControllerAssert
extends AbstractLayoutAnimationControllerAssert<GridLayoutAnimationControllerAssert, GridLayoutAnimationController> {
    public GridLayoutAnimationControllerAssert(GridLayoutAnimationController actual) {
        super(actual, GridLayoutAnimationControllerAssert.class);
    }

    public GridLayoutAnimationControllerAssert hasColumnDelay(float delay) {
        this.isNotNull();
        float actualDelay = ((GridLayoutAnimationController)this.actual).getColumnDelay();
        ((FloatAssert)Assertions.assertThat((float)actualDelay).overridingErrorMessage("Expected column delay <%s> but was <%s>.", new Object[]{Float.valueOf(delay), Float.valueOf(actualDelay)})).isEqualTo(delay);
        return this;
    }

    public GridLayoutAnimationControllerAssert hasDirection(int direction) {
        this.isNotNull();
        int actualDirection = ((GridLayoutAnimationController)this.actual).getDirection();
        ((IntegerAssert)Assertions.assertThat((int)actualDirection).overridingErrorMessage("Expected direction <%s> but was <%s>.", new Object[]{GridLayoutAnimationControllerAssert.directionToString(direction), GridLayoutAnimationControllerAssert.directionToString(actualDirection)})).isEqualTo(direction);
        return this;
    }

    public GridLayoutAnimationControllerAssert hasDirectionPriority(int priority) {
        this.isNotNull();
        int actualPriority = ((GridLayoutAnimationController)this.actual).getDirectionPriority();
        ((IntegerAssert)Assertions.assertThat((int)actualPriority).overridingErrorMessage("Expected direction priority <%s> but was <%s>.", new Object[]{GridLayoutAnimationControllerAssert.directionPriorityToString(priority), GridLayoutAnimationControllerAssert.directionPriorityToString(actualPriority)})).isEqualTo(priority);
        return this;
    }

    public GridLayoutAnimationControllerAssert hasRowDelay(float delay) {
        this.isNotNull();
        float actualDelay = ((GridLayoutAnimationController)this.actual).getRowDelay();
        ((FloatAssert)Assertions.assertThat((float)actualDelay).overridingErrorMessage("Expected row delay <%s> but was <%s>.", new Object[]{Float.valueOf(delay), Float.valueOf(actualDelay)})).isEqualTo(delay);
        return this;
    }

    private static String directionToString(int direction) {
        ArrayList<String> parts = new ArrayList<String>();
        int horizontal = direction & 1;
        int vertical = direction & 2;
        if ((horizontal & 1) != 0) {
            parts.add("rightToLeft");
        } else {
            parts.add("leftToRight");
        }
        if ((vertical & 2) != 0) {
            parts.add("bottomToTop");
        } else {
            parts.add("topToBottom");
        }
        return TextUtils.join((CharSequence)", ", parts);
    }

    private static String directionPriorityToString(int priority) {
        switch (priority) {
            case 0: {
                return "none";
            }
            case 1: {
                return "column";
            }
            case 2: {
                return "row";
            }
        }
        throw new IllegalArgumentException("Unknown priority: " + priority);
    }
}

