/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.Adapter;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;

public abstract class AbstractAdapterAssert<S extends AbstractAdapterAssert<S, A>, A extends Adapter>
extends AbstractAssert<S, A> {
    protected AbstractAdapterAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasCount(int count) {
        this.isNotNull();
        int actualCount = ((Adapter)this.actual).getCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S hasViewTypeCount(int count) {
        this.isNotNull();
        int actualCount = ((Adapter)this.actual).getViewTypeCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected view type count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S hasStableIds() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Adapter)this.actual).hasStableIds()).overridingErrorMessage("Expected to have stable IDs but did not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S hasUnstableIds() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Adapter)this.actual).hasStableIds()).overridingErrorMessage("Expected to not have stable IDs but.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S isEmpty() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Adapter)this.actual).isEmpty()).overridingErrorMessage("Expected to be empty but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S isNotEmpty() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Adapter)this.actual).isEmpty()).overridingErrorMessage("Expected to not be empty but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }
}

