/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics;

import android.graphics.NinePatch;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;

public class NinePatchAssert
extends AbstractAssert<NinePatchAssert, NinePatch> {
    public NinePatchAssert(NinePatch actual) {
        super((Object)actual, NinePatchAssert.class);
    }

    public NinePatchAssert hasDensity(int density) {
        this.isNotNull();
        int actualHeight = ((NinePatch)this.actual).getDensity();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected density <%s> but was <%s>.", new Object[]{density, actualHeight})).isEqualTo(density);
        return this;
    }

    public NinePatchAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((NinePatch)this.actual).getHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public NinePatchAssert hasWidth(int width) {
        this.isNotNull();
        int actualHeight = ((NinePatch)this.actual).getWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualHeight})).isEqualTo(width);
        return this;
    }

    public NinePatchAssert hasAlpha() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((NinePatch)this.actual).hasAlpha()).overridingErrorMessage("Expected to have alpha but did not.", new Object[0])).isTrue();
        return this;
    }

    public NinePatchAssert hasNoAlpha() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((NinePatch)this.actual).hasAlpha()).overridingErrorMessage("Expected to not have alpha but did.", new Object[0])).isFalse();
        return this;
    }
}

